/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.gegy.roles.PlayerRoles;
import dev.gegy.roles.SimpleRole;
import dev.gegy.roles.api.PlayerRolesApi;
import dev.gegy.roles.api.Role;
import dev.gegy.roles.api.RoleProvider;
import dev.gegy.roles.config.ConfigErrorConsumer;
import dev.gegy.roles.config.RoleApplyConfig;
import dev.gegy.roles.config.RoleConfig;
import dev.gegy.roles.config.RoleConfigMap;
import dev.gegy.roles.store.ServerRoleSet;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlayerRolesConfig
implements RoleProvider {
    private static PlayerRolesConfig instance = new PlayerRolesConfig(List.of(), SimpleRole.empty("everyone"));
    private final ImmutableMap<String, SimpleRole> roles;
    private final SimpleRole everyone;
    private ServerRoleSet commandBlockRoles;
    private ServerRoleSet functionRoles;

    private PlayerRolesConfig(List<SimpleRole> roles, SimpleRole everyone) {
        ImmutableMap.Builder roleMap = ImmutableMap.builder();
        for (SimpleRole role : roles) {
            roleMap.put((Object)role.getId(), (Object)role);
        }
        this.roles = roleMap.build();
        this.everyone = everyone;
    }

    private ServerRoleSet buildRoles(Predicate<RoleApplyConfig> apply) {
        ObjectAVLTreeSet roleSet = new ObjectAVLTreeSet();
        this.roles.values().stream().filter(role -> apply.test(role.getApply())).forEach(arg_0 -> ((ObjectAVLTreeSet)roleSet).add(arg_0));
        return ServerRoleSet.of((ObjectSortedSet<Role>)roleSet);
    }

    public static PlayerRolesConfig get() {
        return instance;
    }

    public static List<String> setup() {
        Path path = Paths.get("config/roles.json", new String[0]);
        if (!Files.exists(path, new LinkOption[0]) && !PlayerRolesConfig.createDefaultConfig(path)) {
            return ImmutableList.of();
        }
        ArrayList<String> errors = new ArrayList<String>();
        ConfigErrorConsumer errorConsumer = errors::add;
        try (BufferedReader reader = Files.newBufferedReader(path);){
            PlayerRolesConfig config;
            JsonElement root = JsonParser.parseReader((Reader)reader);
            instance = config = PlayerRolesConfig.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)root), errorConsumer);
            PlayerRolesApi.setRoleProvider((RoleProvider)config);
        }
        catch (IOException e) {
            errorConsumer.report("Failed to read roles.json configuration", e);
            PlayerRoles.LOGGER.warn("Failed to load roles.json configuration", (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            errorConsumer.report("Malformed syntax in roles.json configuration", e);
            PlayerRoles.LOGGER.warn("Malformed syntax in roles.json configuration", (Throwable)e);
        }
        return errors;
    }

    private static boolean createDefaultConfig(Path path) {
        boolean bl;
        block10: {
            Path legacyPath;
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            if (Files.exists(legacyPath = Paths.get("roles.json", new String[0]), new LinkOption[0])) {
                Files.move(legacyPath, path, new CopyOption[0]);
                return true;
            }
            InputStream input = PlayerRoles.class.getResourceAsStream("/data/player-roles/default_roles.json");
            try {
                Files.copy(input, path, new CopyOption[0]);
                bl = true;
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    PlayerRoles.LOGGER.warn("Failed to load default roles.json configuration", (Throwable)e);
                    return false;
                }
            }
            input.close();
        }
        return bl;
    }

    private static <T> PlayerRolesConfig parse(Dynamic<T> root, ConfigErrorConsumer error) {
        RoleConfigMap roleConfigs = RoleConfigMap.parse(root, error);
        SimpleRole everyone = SimpleRole.empty("everyone");
        ArrayList<SimpleRole> roles = new ArrayList<SimpleRole>();
        int index = 1;
        for (Pair<String, RoleConfig> entry : roleConfigs) {
            String name = (String)entry.getFirst();
            RoleConfig roleConfig = (RoleConfig)entry.getSecond();
            if (!name.equalsIgnoreCase("everyone")) {
                roles.add(roleConfig.create(name, index++));
                continue;
            }
            everyone = roleConfig.create(name, 0);
        }
        return new PlayerRolesConfig(roles, everyone);
    }

    @Nullable
    public SimpleRole get(String name) {
        return (SimpleRole)this.roles.get((Object)name);
    }

    @NotNull
    public SimpleRole everyone() {
        return this.everyone;
    }

    public ServerRoleSet getCommandBlockRoles() {
        ServerRoleSet commandBlockRoles = this.commandBlockRoles;
        if (commandBlockRoles == null) {
            this.commandBlockRoles = commandBlockRoles = this.buildRoles(RoleApplyConfig::commandBlock);
        }
        return commandBlockRoles;
    }

    public ServerRoleSet getFunctionRoles() {
        ServerRoleSet functionRoles = this.functionRoles;
        if (functionRoles == null) {
            this.functionRoles = functionRoles = this.buildRoles(RoleApplyConfig::functions);
        }
        return functionRoles;
    }

    @NotNull
    public Iterator<Role> iterator() {
        return this.roles.values().iterator();
    }

    public Stream<Role> stream() {
        return this.roles.values().stream();
    }
}

