/*
 * Decompiled with CFR 0.152.
 */
package com.everlastingutils.gui;

import com.everlastingutils.gui.CustomGui;
import com.everlastingutils.gui.GuiManagerKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\r\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0006J\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0006J\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0006J\r\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\u0006R\u001c\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/everlastingutils/gui/GuiTester;", "", "<init>", "()V", "", "testBasicButtonCreation", "()Z", "testHeadButtonCreation", "testItemManipulation", "testFormattingUtilities", "testLayoutCreation", "testComplexLore", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Companion", "everlastingutils"})
@SourceDebugExtension(value={"SMAP\nGuiTester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiTester.kt\ncom/everlastingutils/gui/GuiTester\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1863#2,2:215\n1#3:217\n*S KotlinDebug\n*F\n+ 1 GuiTester.kt\ncom/everlastingutils/gui/GuiTester\n*L\n112#1:215,2\n*E\n"})
public final class GuiTester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LoggerFactory.getLogger((String)"GuiTester");

    public final boolean testBasicButtonCreation() {
        try {
            class_1799 stoneButton = CustomGui.INSTANCE.createNormalButton(new class_1799((class_1935)class_1802.field_20391), "Stone Button", CollectionsKt.listOf((Object)"Click me!"));
            Object[] objectArray = new String[]{"Shiny!", "Very valuable"};
            class_1799 diamondButton = CustomGui.INSTANCE.createNormalButton(new class_1799((class_1935)class_1802.field_8477), "Diamond Button", CollectionsKt.listOf((Object[])objectArray));
            Object[] objectArray2 = new String[]{"Sharp!", "Combat ready"};
            class_1799 swordButton = CustomGui.INSTANCE.createNormalButton(new class_1799((class_1935)class_1802.field_8802), "Weapon Button", CollectionsKt.listOf((Object[])objectArray2));
            return true;
        }
        catch (Exception e) {
            this.logger.error("Basic button creation test failed", (Throwable)e);
            return false;
        }
    }

    public final boolean testHeadButtonCreation() {
        class_5250 class_52502 = class_2561.method_43470((String)"Long Name Test");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        class_1799 longNameHead = CustomGui.INSTANCE.createPlayerHeadButton("this_is_a_very_long_name_that_should_be_truncated", (class_2561)class_52502, CollectionsKt.listOf((Object)class_2561.method_43470((String)"Should work fine")), "test_texture_value");
        try {
            class_5250 class_52503 = class_2561.method_43470((String)"Basic Head");
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
            class_1799 basicHead = CustomGui.INSTANCE.createPlayerHeadButton("basic_head", (class_2561)class_52503, CollectionsKt.listOf((Object)class_2561.method_43470((String)"Simple head button")), "test_texture_value");
            class_5250 class_52504 = class_2561.method_43470((String)"\u00a76Fancy Head");
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
            Object[] objectArray = new class_5250[]{class_2561.method_43470((String)"\u00a7aLine 1"), class_2561.method_43470((String)"\u00a7bLine 2"), class_2561.method_43470((String)"\u00a7cLine 3")};
            class_1799 fancyHead = CustomGui.INSTANCE.createPlayerHeadButton("fancy_head", (class_2561)class_52504, CollectionsKt.listOf((Object[])objectArray), "another_texture_value");
            return true;
        }
        catch (Exception e) {
            this.logger.error("Head button creation test failed", (Throwable)e);
            return false;
        }
    }

    public final boolean testItemManipulation() {
        try {
            class_1799 testStack = new class_1799((class_1935)class_1802.field_8802);
            class_5250 class_52502 = class_2561.method_43470((String)"Super Sword");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            GuiManagerKt.setCustomName(testStack, (class_2561)class_52502);
            Object[] objectArray = new Object[]{"Plain text line", class_2561.method_43470((String)"Text component line"), "\u00a7cColored line", null, 123};
            CustomGui.INSTANCE.setItemLore(testStack, CollectionsKt.listOf((Object[])objectArray));
            CustomGui.INSTANCE.addEnchantmentGlint(testStack);
            return true;
        }
        catch (Exception e) {
            this.logger.error("Item manipulation test failed", (Throwable)e);
            return false;
        }
    }

    public final boolean testFormattingUtilities() {
        try {
            Object[] objectArray = new String[]{"\u00a7aGreen text", "\u00a7cRed\u00a7r reset \u00a7bblue", "\u00a7k\u00a7l\u00a7mMultiple\u00a7r formats", "\u00a70\u00a71\u00a72\u00a73\u00a74\u00a75\u00a76\u00a77\u00a78\u00a79\u00a7a\u00a7b\u00a7c\u00a7d\u00a7e\u00a7f all colors", "Normal text with no formatting"};
            List tests = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$forEach$iv = tests;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                CustomGui.INSTANCE.stripFormatting(it);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("Formatting utilities test failed", (Throwable)e);
            return false;
        }
    }

    public final boolean testLayoutCreation() {
        try {
            int it;
            List layout = new ArrayList();
            layout.add(CustomGui.INSTANCE.createNormalButton(new class_1799((class_1935)class_1802.field_8477), "Button 1", CollectionsKt.listOf((Object)"First button")));
            class_5250 class_52502 = class_2561.method_43470((String)"Head Button");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            layout.add(CustomGui.INSTANCE.createPlayerHeadButton("test_head", (class_2561)class_52502, CollectionsKt.listOf((Object)class_2561.method_43470((String)"Click me")), "texture_value"));
            int n = 7;
            int n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                class_1799 class_17992 = class_1799.field_8037;
                Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
                layout.add(class_17992);
            }
            n = 9;
            n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                class_1799 stack = new class_1799((class_1935)class_1802.field_8695);
                CustomGui.INSTANCE.addEnchantmentGlint(stack);
                layout.add(stack);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("Layout creation test failed", (Throwable)e);
            return false;
        }
    }

    public final boolean testComplexLore() {
        try {
            class_1799 testStack = new class_1799((class_1935)class_1802.field_8407);
            Object[] objectArray = new String[]{"\u00a77\u00a7m-------------------", "\u00a76\u25cf \u00a7eFirst bullet point", "\u00a76\u25cf \u00a7eSecond bullet point", "", "\u00a77\u00a7oItalic description line", "\u00a77\u00a7m-------------------"};
            CustomGui.INSTANCE.setItemLore(testStack, CollectionsKt.listOf((Object[])objectArray));
            class_1799 anotherStack = new class_1799((class_1935)class_1802.field_8529);
            Object[] objectArray2 = new String[]{"\u00a78<< \u00a77Description \u00a78>>", "\u00a77This is a longer description", "\u00a77that spans multiple lines", "", "\u00a7eRarity: \u00a76Legendary", "\u00a7bType: \u00a73Magic"};
            CustomGui.INSTANCE.setItemLore(anotherStack, CollectionsKt.listOf((Object[])objectArray2));
            return true;
        }
        catch (Exception e) {
            this.logger.error("Complex lore test failed", (Throwable)e);
            return false;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u0003\u00a8\u0006\u000b"}, d2={"Lcom/everlastingutils/gui/GuiTester$Companion;", "", "<init>", "()V", "", "", "", "runAllTests", "()Ljava/util/Map;", "", "printTestResults", "everlastingutils"})
    @SourceDebugExtension(value={"SMAP\nGuiTester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiTester.kt\ncom/everlastingutils/gui/GuiTester$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,214:1\n216#2,2:215\n*S KotlinDebug\n*F\n+ 1 GuiTester.kt\ncom/everlastingutils/gui/GuiTester$Companion\n*L\n208#1:215,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Boolean> runAllTests() {
            GuiTester tester = new GuiTester();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"basicButtons", (Object)tester.testBasicButtonCreation()), TuplesKt.to((Object)"headButtons", (Object)tester.testHeadButtonCreation()), TuplesKt.to((Object)"itemManipulation", (Object)tester.testItemManipulation()), TuplesKt.to((Object)"formatting", (Object)tester.testFormattingUtilities()), TuplesKt.to((Object)"layout", (Object)tester.testLayoutCreation()), TuplesKt.to((Object)"complexLore", (Object)tester.testComplexLore())};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        public final void printTestResults() {
            Map<String, Boolean> results = this.runAllTests();
            System.out.println((Object)"\n=== GUI API Test Results ===");
            Map<String, Boolean> $this$forEach$iv = results;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Boolean>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Boolean> element$iv;
                Map.Entry<String, Boolean> entry = element$iv = iterator.next();
                boolean bl = false;
                String test = entry.getKey();
                boolean passed = entry.getValue();
                System.out.println((Object)(StringsKt.padEnd$default((String)test, (int)20, (char)'\u0000', (int)2, null) + ": " + (passed ? "\u2713 PASSED" : "\u2717 FAILED")));
            }
            System.out.println((Object)"==========================\n");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

