/*
 * Decompiled with CFR 0.152.
 */
package com.everlastingutils;

import com.everlastingutils.command.CommandTester;
import com.everlastingutils.config.ConfigTester;
import com.everlastingutils.gui.GuiTester;
import com.everlastingutils.scheduling.SchedulerManager;
import com.everlastingutils.scheduling.SchedulerTester;
import com.everlastingutils.utils.LogDebugTester;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\u0003R\u001c\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/everlastingutils/EverlastingUtils;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "getModName", "()Ljava/lang/String;", "", "onInitialize", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "MOD_ID", "Ljava/lang/String;", "VERSION", "Colors", "everlastingutils"})
@SourceDebugExtension(value={"SMAP\nEverlastingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EverlastingUtils.kt\ncom/everlastingutils/EverlastingUtils\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,125:1\n216#2,2:126\n216#2,2:128\n216#2,2:130\n216#2,2:132\n216#2,2:134\n*S KotlinDebug\n*F\n+ 1 EverlastingUtils.kt\ncom/everlastingutils/EverlastingUtils\n*L\n65#1:126,2\n75#1:128,2\n85#1:130,2\n96#1:132,2\n105#1:134,2\n*E\n"})
public final class EverlastingUtils
implements ModInitializer {
    @NotNull
    public static final EverlastingUtils INSTANCE = new EverlastingUtils();
    private static final Logger logger = LoggerFactory.getLogger((String)"everlastingutils");
    @NotNull
    public static final String MOD_ID = "everlastingutils";
    @NotNull
    public static final String VERSION = "1.0.8";

    private EverlastingUtils() {
    }

    private final String getModName() {
        return Colors.INSTANCE.boldBrightPink("everlasting") + Colors.INSTANCE.boldPurple("utils");
    }

    /*
     * WARNING - void declaration
     */
    public void onInitialize() {
        String it22;
        CharSequence charSequence;
        Logger logger;
        String string;
        Colors colors;
        StringBuilder stringBuilder;
        String string2;
        String status;
        boolean passed;
        String testName;
        Map.Entry<String, Boolean> entry;
        Map.Entry<String, Boolean> element$iv;
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String prefix = Colors.INSTANCE.boldPurple("[") + this.getModName() + Colors.INSTANCE.boldPurple("]");
        EverlastingUtils.logger.info("");
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.boldPurple("============================"));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.brightPurple(this.getModName() + " v1.0.8"));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.boldPurple("A Tiny Tool, With Mighty Results."));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.brightBlack("Loading at: " + timestamp));
        ServerLifecycleEvents.SERVER_STOPPING.register(arg_0 -> EverlastingUtils.onInitialize$lambda$0(prefix, arg_0));
        Map<String, Boolean> results = ConfigTester.Companion.runAllTests();
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.boldYellow("Running Configuration Tests:"));
        Map<String, Boolean> $this$forEach$iv = results;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Boolean>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string3;
            entry = element$iv = iterator.next();
            boolean bl = false;
            testName = entry.getKey();
            passed = entry.getValue();
            status = passed ? Colors.INSTANCE.boldGreen("GOOD") : Colors.INSTANCE.boldRed("BAD");
            Logger logger2 = EverlastingUtils.logger;
            String string4 = prefix;
            Colors colors2 = Colors.INSTANCE;
            string2 = testName;
            if (((CharSequence)string2).length() > 0) {
                String string5;
                void it22;
                char c = string2.charAt(0);
                stringBuilder = new StringBuilder();
                colors = colors2;
                string = string4;
                logger = logger2;
                int n = 0;
                if (Character.isLowerCase((char)it22)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string5 = CharsKt.titlecase((char)it22, (Locale)locale);
                } else {
                    string5 = String.valueOf((char)it22);
                }
                charSequence = string5;
                logger2 = logger;
                string4 = string;
                colors2 = colors;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                it22 = string2;
                n = 1;
                String string6 = it22.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                string3 = stringBuilder2.append(string6).toString();
            } else {
                string3 = string2;
            }
            logger2.info(string4 + " " + colors2.brightBlack("- Test " + string3 + ": ") + status);
        }
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.boldYellow("Running GUI System Tests:"));
        $this$forEach$iv = GuiTester.Companion.runAllTests();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string7;
            entry = element$iv = iterator.next();
            boolean bl = false;
            testName = entry.getKey();
            passed = entry.getValue();
            status = passed ? Colors.INSTANCE.boldGreen("GOOD") : Colors.INSTANCE.boldRed("BAD");
            Logger logger3 = EverlastingUtils.logger;
            String string8 = prefix;
            Colors colors3 = Colors.INSTANCE;
            string2 = testName;
            if (((CharSequence)string2).length() > 0) {
                String string9;
                char it22 = string2.charAt(0);
                stringBuilder = new StringBuilder();
                colors = colors3;
                string = string8;
                logger = logger3;
                int n = 0;
                if (Character.isLowerCase(it22)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string9 = CharsKt.titlecase((char)it22, (Locale)locale);
                } else {
                    string9 = String.valueOf(it22);
                }
                charSequence = string9;
                logger3 = logger;
                string8 = string;
                colors3 = colors;
                StringBuilder stringBuilder3 = stringBuilder.append((Object)charSequence);
                it22 = string2;
                n = 1;
                String string10 = it22.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"substring(...)");
                string7 = stringBuilder3.append(string10).toString();
            } else {
                string7 = string2;
            }
            logger3.info(string8 + " " + colors3.brightBlack("- Test " + string7 + ": ") + status);
        }
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.boldYellow("Running Command System Tests:"));
        $this$forEach$iv = CommandTester.Companion.runAllTests();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string11;
            entry = element$iv = iterator.next();
            boolean bl = false;
            testName = entry.getKey();
            passed = entry.getValue();
            status = passed ? Colors.INSTANCE.boldGreen("GOOD") : Colors.INSTANCE.boldRed("BAD");
            Logger logger4 = EverlastingUtils.logger;
            String string12 = prefix;
            Colors colors4 = Colors.INSTANCE;
            string2 = testName;
            if (((CharSequence)string2).length() > 0) {
                String string13;
                char it = string2.charAt(0);
                stringBuilder = new StringBuilder();
                colors = colors4;
                string = string12;
                logger = logger4;
                int n = 0;
                if (Character.isLowerCase(it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string13 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string13 = String.valueOf(it);
                }
                charSequence = string13;
                logger4 = logger;
                string12 = string;
                colors4 = colors;
                StringBuilder stringBuilder4 = stringBuilder.append((Object)charSequence);
                it22 = string2;
                n = 1;
                String string14 = it22.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"substring(...)");
                string11 = stringBuilder4.append(string14).toString();
            } else {
                string11 = string2;
            }
            logger4.info(string12 + " " + colors4.brightBlack("- Test " + string11 + ": ") + status);
        }
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.boldYellow("Running LogDebug System Tests:"));
        $this$forEach$iv = LogDebugTester.Companion.runAllTests();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string15;
            entry = element$iv = iterator.next();
            boolean bl = false;
            testName = entry.getKey();
            passed = entry.getValue();
            status = passed ? Colors.INSTANCE.boldGreen("GOOD") : Colors.INSTANCE.boldRed("BAD");
            Logger logger5 = EverlastingUtils.logger;
            String string16 = prefix;
            Colors colors5 = Colors.INSTANCE;
            string2 = testName;
            if (((CharSequence)string2).length() > 0) {
                String string17;
                char it = string2.charAt(0);
                stringBuilder = new StringBuilder();
                colors = colors5;
                string = string16;
                logger = logger5;
                int n = 0;
                if (Character.isLowerCase(it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string17 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string17 = String.valueOf(it);
                }
                charSequence = string17;
                logger5 = logger;
                string16 = string;
                colors5 = colors;
                StringBuilder stringBuilder5 = stringBuilder.append((Object)charSequence);
                it22 = string2;
                n = 1;
                String string18 = it22.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"substring(...)");
                string15 = stringBuilder5.append(string18).toString();
            } else {
                string15 = string2;
            }
            logger5.info(string16 + " " + colors5.brightBlack("- Test " + string15 + ": ") + status);
        }
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.boldYellow("Running Scheduler System Tests:"));
        $this$forEach$iv = SchedulerTester.Companion.runAllTests();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string19;
            entry = element$iv = iterator.next();
            boolean bl = false;
            testName = entry.getKey();
            passed = entry.getValue();
            status = passed ? Colors.INSTANCE.boldGreen("GOOD") : Colors.INSTANCE.boldRed("BAD");
            Logger logger6 = EverlastingUtils.logger;
            String string20 = prefix;
            Colors colors6 = Colors.INSTANCE;
            string2 = testName;
            if (((CharSequence)string2).length() > 0) {
                String string21;
                char it = string2.charAt(0);
                stringBuilder = new StringBuilder();
                colors = colors6;
                string = string20;
                logger = logger6;
                boolean bl2 = false;
                if (Character.isLowerCase(it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string21 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string21 = String.valueOf(it);
                }
                charSequence = string21;
                logger6 = logger;
                string20 = string;
                colors6 = colors;
                StringBuilder stringBuilder6 = stringBuilder.append((Object)charSequence);
                String string22 = string2;
                int n = 1;
                String string23 = string22.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"substring(...)");
                string19 = stringBuilder6.append(string23).toString();
            } else {
                string19 = string2;
            }
            logger6.info(string20 + " " + colors6.brightBlack("- Test " + string19 + ": ") + status);
        }
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.boldGreen("Successfully initialized!"));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.brightBlack("Runtime: " + System.getProperty("java.version")));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.brightBlack("Environment: " + System.getProperty("java.vendor")));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.brightBlack("Cores Available: " + Runtime.getRuntime().availableProcessors()));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.brightBlack("Thread Count: " + Thread.activeCount()));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.brightBlack("Memory: " + Runtime.getRuntime().maxMemory() / (long)1024 / (long)1024 + "MB allocated"));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.brightBlack("Report issues at: https://github.com/Hysocs/EverlastingUtils"));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.brightBlack("Or join our discord at: https://discord.gg/KQyPEye7CT"));
        EverlastingUtils.logger.info(prefix + " " + Colors.INSTANCE.boldPurple("============================"));
        EverlastingUtils.logger.info("");
    }

    private static final void onInitialize$lambda$0(String $prefix, MinecraftServer server) {
        logger.info($prefix + " " + Colors.INSTANCE.brightBlack("Server stopping - shutting down all schedulers"));
        SchedulerManager.INSTANCE.shutdownAll();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\nJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\nJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\nJ\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\nJ\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/everlastingutils/EverlastingUtils$Colors;", "", "<init>", "()V", "", "text", "colorCode", "color", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "boldPurple", "(Ljava/lang/String;)Ljava/lang/String;", "boldBrightPink", "brightBlack", "boldYellow", "boldGreen", "boldRed", "brightPurple", "ESC", "Ljava/lang/String;", "BOLD", "everlastingutils"})
    public static final class Colors {
        @NotNull
        public static final Colors INSTANCE = new Colors();
        @NotNull
        private static final String ESC = "\u001b";
        @NotNull
        private static final String BOLD = "\u001b[1m";

        private Colors() {
        }

        private final String color(String text, String colorCode) {
            return colorCode + text + "\u001b[39m" + (StringsKt.contains$default((CharSequence)colorCode, (CharSequence)BOLD, (boolean)false, (int)2, null) ? "\u001b[22m" : "");
        }

        @NotNull
        public final String boldPurple(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.color(text, "\u001b[1;35m");
        }

        @NotNull
        public final String boldBrightPink(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.color(text, "\u001b[1;95m");
        }

        @NotNull
        public final String brightBlack(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.color(text, "\u001b[90m");
        }

        @NotNull
        public final String boldYellow(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.color(text, "\u001b[1;33m");
        }

        @NotNull
        public final String boldGreen(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.color(text, "\u001b[1;32m");
        }

        @NotNull
        public final String boldRed(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.color(text, "\u001b[1;31m");
        }

        @NotNull
        public final String brightPurple(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.color(text, "\u001b[95m");
        }
    }
}

