/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.misc.RollingBuffer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;

public class ParticleTrailEmitter {
    private final double idealSpacing;
    private final int maxParticlesPerTick;
    private final double minSpeed;
    private class_243 lastEmittedPos = null;
    private double accumulatedDistanceSinceLastParticle;
    private final RollingBuffer<class_243> previousVelocities = new RollingBuffer(3);
    private final RollingBuffer<class_243> previousPositions = new RollingBuffer(3);

    private ParticleTrailEmitter(Builder builder) {
        this.idealSpacing = builder.idealSpacing;
        this.maxParticlesPerTick = builder.maxParticlesPerTick;
        this.minSpeed = builder.minSpeed;
        this.accumulatedDistanceSinceLastParticle = -this.idealSpacing;
    }

    public void tick(class_1297 obj, class_2394 particleOptions) {
        this.tick(obj, particleOptions, true);
    }

    public void tick(class_1297 obj, class_2394 particleOptions, boolean followSpeed) {
        this.tick(obj, (class_243 position, class_243 velocity) -> {
            class_1937 level = obj.method_37908();
            if (followSpeed) {
                level.method_8406(particleOptions, position.field_1352, position.field_1351, position.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350);
            } else {
                level.method_8406(particleOptions, position.field_1352, position.field_1351, position.field_1350, 0.0, 0.0, 0.0);
            }
        });
    }

    public void tick(class_1297 obj, Emitter emitter) {
        class_243 currentVel = obj.method_18798();
        class_243 currentPos = obj.method_19538();
        this.previousVelocities.push(currentVel);
        this.previousPositions.push(currentPos);
        if (this.previousPositions.size() < 2) {
            return;
        }
        class_243 prevPos = this.previousPositions.get(0);
        class_243 currentPosBuf = this.previousPositions.get(1);
        class_243 prevVel = this.previousVelocities.get(0);
        double segmentLength = prevPos.method_1022(currentPosBuf);
        if (segmentLength < this.minSpeed) {
            return;
        }
        float h = obj.method_17682() / 2.0f;
        double totalAvailable = this.accumulatedDistanceSinceLastParticle + segmentLength;
        int particlesToEmit = (int)(totalAvailable / this.idealSpacing);
        if ((particlesToEmit = Math.min(particlesToEmit, this.maxParticlesPerTick)) == 0) {
            this.accumulatedDistanceSinceLastParticle += segmentLength;
            return;
        }
        class_243 lastPos = this.lastEmittedPos != null ? this.lastEmittedPos : prevPos;
        double spacingSum = 0.0;
        for (int i = 1; i <= particlesToEmit; ++i) {
            double targetDist = (double)i * this.idealSpacing - this.accumulatedDistanceSinceLastParticle;
            double t = targetDist / segmentLength;
            t = Math.max(0.0, Math.min(1.0, t));
            class_243 emitPos = prevPos.method_35590(currentPosBuf, t);
            class_243 emitVel = prevVel.method_35590(this.previousVelocities.get(1), t);
            class_243 direction = emitPos.method_1020(lastPos).method_1029();
            class_243 perfectPos = lastPos.method_1019(direction.method_1021(this.idealSpacing)).method_1031(0.0, (double)h, 0.0);
            emitter.emitParticle(perfectPos, emitVel);
            lastPos = perfectPos;
            spacingSum += this.idealSpacing;
        }
        this.lastEmittedPos = lastPos;
        this.accumulatedDistanceSinceLastParticle = totalAvailable - spacingSum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double idealSpacing = 0.5;
        private int maxParticlesPerTick = 5;
        private double minSpeed = 0.0;

        public Builder spacing(double spacing) {
            this.idealSpacing = spacing;
            return this;
        }

        public Builder maxParticlesPerTick(int max) {
            this.maxParticlesPerTick = max;
            return this;
        }

        public Builder minSpeed(double speed) {
            this.minSpeed = speed;
            return this;
        }

        public ParticleTrailEmitter build() {
            return new ParticleTrailEmitter(this);
        }
    }

    public static interface Emitter {
        public void emitParticle(class_243 var1, class_243 var2);
    }
}

