/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.mojang.datafixers.util.Either;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.api.model.data.BaseModelDataBuilder;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.util.TextureAtlases;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_793;
import net.minecraft.class_809;

public class BaseModelDataBuilderImpl
implements BaseModelDataBuilder<BaseModelDataBuilderImpl, BaseModelData> {
    private final Set<class_2960> parents = new LinkedHashSet<class_2960>();
    private final Map<String, String> textures = new HashMap<String, String>();

    @Override
    public BaseModelDataBuilderImpl parent(class_2960 parent) {
        return this.parents(parent);
    }

    @Override
    public BaseModelDataBuilderImpl parents(class_2960 ... parents) {
        this.parents.addAll(Arrays.asList(parents));
        return this;
    }

    @Override
    public BaseModelDataBuilderImpl texture(String key, String reference) {
        if (!key.matches("[a-zA-Z_]*")) {
            throw new IllegalArgumentException("Texture reference must only contain characters [a-zA-Z_]!");
        }
        if (((String)reference).charAt(0) != '#') {
            reference = "#" + (String)reference;
        }
        if (this.textures.containsKey(key)) {
            throw new RuntimeException("Duplicate texture entry for key '" + key + "': '" + this.textures.get(key) + "' and '" + (String)reference + "'!");
        }
        this.textures.put(key, (String)reference);
        return this;
    }

    @Override
    public BaseModelDataBuilderImpl texture(String key, class_2960 texture) {
        if (!key.matches("[a-zA-Z_]*")) {
            throw new IllegalArgumentException("Texture reference must only contain characters [a-zA-Z_]!");
        }
        if (this.textures.containsKey(key)) {
            throw new RuntimeException("Duplicate texture entry for key '" + key + "': '" + this.textures.get(key) + "' and '" + String.valueOf(texture) + "'!");
        }
        this.textures.put(key, texture.toString());
        return this;
    }

    @Override
    public BaseModelData build() {
        ArrayList<class_2960> parents = new ArrayList<class_2960>(this.parents);
        class_2960 parent = parents.isEmpty() ? null : (class_2960)parents.get(0);
        Map<String, Either> textures = this.textures.entrySet().stream().map(entry -> Pair.of((String)entry.getKey(), (String)entry.getValue())).map(pair -> pair.mapRight(s -> s.charAt(0) == '#' ? Either.right((Object)s) : Either.left((Object)new class_4730(TextureAtlases.getBlocks(), class_2960.method_60654((String)s))))).collect(Collectors.toMap(Pair::left, Pair::right));
        class_793 vanillaModel = new class_793(parent, Collections.emptyList(), textures, null, null, class_809.field_4301, Collections.emptyList());
        return new BaseModelDataImpl(vanillaModel, parents, Collections.emptyList());
    }
}

