/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.predicate;

import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.types.connecting.predicates.AndConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsDirectionConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.NotConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.OrConnectionPredicate;
import java.util.Arrays;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public final class DefaultConnectionPredicates {
    public static ConnectionPredicate and(ConnectionPredicate ... predicates) {
        return new AndConnectionPredicate(Arrays.asList(predicates));
    }

    public static ConnectionPredicate or(ConnectionPredicate ... predicates) {
        return new OrConnectionPredicate(Arrays.asList(predicates));
    }

    public static ConnectionPredicate not(ConnectionPredicate predicate) {
        return new NotConnectionPredicate(predicate);
    }

    public static ConnectionPredicate isDirection(ConnectionDirection ... directions) {
        return new IsDirectionConnectionPredicate(directions);
    }

    public static ConnectionPredicate isFaceVisible() {
        return IsFaceVisibleConnectionPredicate.INSTANCE;
    }

    public static ConnectionPredicate isSameBlock() {
        return IsSameBlockConnectionPredicate.INSTANCE;
    }

    public static ConnectionPredicate isSameState() {
        return IsSameStateConnectionPredicate.INSTANCE;
    }

    public static ConnectionPredicate matchBlock(class_2248 block) {
        return new MatchBlockConnectionPredicate(block);
    }

    public static ConnectionPredicate matchState(class_2248 block, Pair<class_2769<?>, ?> ... properties) {
        return new MatchStateConnectionPredicate(block, properties);
    }

    public static ConnectionPredicate matchState(class_2680 state) {
        return DefaultConnectionPredicates.matchState(state.method_26204(), (Pair[])state.method_28501().stream().map(p -> Pair.of(p, state.method_11654(p))).toArray(Pair[]::new));
    }

    public static ConnectionPredicate matchBlockInFront(class_2248 block) {
        return new MatchBlockInFrontConnectionPredicate(block);
    }

    public static ConnectionPredicate matchStateInFront(class_2248 block, Pair<class_2769<?>, ?> ... properties) {
        return new MatchStateInFrontConnectionPredicate(block, properties);
    }

    public static ConnectionPredicate matchStateInFront(class_2680 state) {
        return DefaultConnectionPredicates.matchStateInFront(state.method_26204(), (Pair[])state.method_28501().stream().map(p -> Pair.of(p, state.method_11654(p))).toArray(Pair[]::new));
    }
}

