/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.items;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.creeperhost.polylib.Serializable;
import net.creeperhost.polylib.inventory.items.ContainerHelpers;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class BlockInventory
implements class_1263,
Serializable,
ContainerHelpers {
    private final class_2586 blockEntity;
    private final Predicate<class_1657> canPlayerUse = player -> this.getBlockEntity().method_11016().method_10262((class_2382)player.method_24515()) <= 64.0;
    private BiPredicate<Integer, class_1799> stackValidator = null;
    private Map<Integer, Predicate<class_1799>> slotValidators = new HashMap<Integer, Predicate<class_1799>>();
    private final class_2371<class_1799> items;
    private int maxStackSize = 64;

    public BlockInventory(class_2586 blockEntity, int size) {
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        this.blockEntity = blockEntity;
    }

    public BlockInventory setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    public BlockInventory setStackValidator(BiPredicate<Integer, class_1799> stackValidator) {
        this.stackValidator = stackValidator;
        return this;
    }

    public BlockInventory setStackValidator(Predicate<class_1799> stackValidator) {
        this.stackValidator = (integer, stack) -> stackValidator.test((class_1799)stack);
        return this;
    }

    public BlockInventory setSlotValidator(int slot, Predicate<class_1799> validator) {
        this.slotValidators.put(slot, validator);
        return this;
    }

    public class_2586 getBlockEntity() {
        return this.blockEntity;
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        return this.items.stream().allMatch(class_1799::method_7960);
    }

    @NotNull
    public class_1799 method_5438(int i) {
        return (class_1799)this.items.get(i);
    }

    public class_1799 method_5434(int index, int count) {
        class_1799 itemstack = class_1262.method_5430(this.items, (int)index, (int)count);
        if (!itemstack.method_7960()) {
            this.method_5431();
        }
        return itemstack;
    }

    @NotNull
    public class_1799 method_5441(int i) {
        return class_1262.method_5428(this.items, (int)i);
    }

    public void method_5447(int index, @NotNull class_1799 stack) {
        this.items.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public void method_5431() {
        this.blockEntity.method_5431();
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return this.canPlayerUse.test(player);
    }

    public void method_5448() {
        this.items.clear();
    }

    @Override
    public void deserialize(class_7225.class_7874 provider, class_2487 compoundTag) {
        class_1262.method_5429((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
    }

    @Override
    public class_2487 serialize(class_7225.class_7874 provider, class_2487 compoundTag) {
        return class_1262.method_5426((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
    }

    public int method_5444() {
        return this.maxStackSize;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (this.slotValidators.containsKey(slot)) {
            return this.slotValidators.get(slot).test(stack);
        }
        return this.stackValidator == null || this.stackValidator.test(slot, stack);
    }
}

