/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric.inventory.power;

import net.creeperhost.polylib.inventory.power.IPolyEnergyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import team.reborn.energy.api.EnergyStorage;

public class PolyFabricEnergyWrapper
extends SnapshotParticipant<Long>
implements EnergyStorage {
    private final IPolyEnergyStorage storage;

    public PolyFabricEnergyWrapper(IPolyEnergyStorage storage) {
        this.storage = storage;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        long insertedAmount = this.storage.receiveEnergy(maxAmount, true);
        if (insertedAmount > 0L) {
            this.updateSnapshots(transaction);
            return this.storage.receiveEnergy(maxAmount, false);
        }
        return 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        long extractedAmount = this.storage.extractEnergy(maxAmount, true);
        if (extractedAmount > 0L) {
            this.updateSnapshots(transaction);
            return this.storage.extractEnergy(maxAmount, false);
        }
        return 0L;
    }

    public boolean supportsInsertion() {
        return this.storage.canReceive();
    }

    public boolean supportsExtraction() {
        return this.storage.canExtract();
    }

    public long getAmount() {
        return this.storage.getEnergyStored();
    }

    public long getCapacity() {
        return this.storage.getMaxEnergyStored();
    }

    protected Long createSnapshot() {
        return this.storage.getEnergyStored();
    }

    protected void readSnapshot(Long snapshot) {
        this.storage.modifyEnergyStored(snapshot - this.storage.getEnergyStored());
    }
}

