/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data;

import java.util.function.Consumer;
import net.creeperhost.polylib.PolyLibClient;
import net.creeperhost.polylib.data.TileDataManager;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.network.PolyLibNetwork;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_9129;

public interface DataManagerBlock {
    public static final int SAVE = 8;
    public static final int SYNC = 4;
    public static final int CLIENT_CONTROL = 2;
    public static final int SAVE_TO_ITEM = 1;
    public static final int SAVE_BOTH = 9;

    public TileDataManager<?> getDataManager();

    default public void sendPacketToServer(int id, Consumer<class_2540> packetWriter) {
        TileDataManager<?> manager = this.getDataManager();
        if (!manager.tile.method_10997().method_8608()) {
            return;
        }
        class_1657 player = PolyLibClient.getClientPlayer();
        if (player == null) {
            return;
        }
        class_1703 container = player.field_7512;
        PolyLibNetwork.sendPacketToServerTile(player.method_56673(), buf -> {
            buf.method_10804(container.field_7763);
            buf.method_10804(id);
            packetWriter.accept((class_2540)buf);
        });
    }

    default public <T> void sendDataValueToServer(AbstractDataStore<T> data, T value) {
        TileDataManager<?> manager = this.getDataManager();
        if (!manager.tile.method_10997().method_8608()) {
            return;
        }
        class_1657 player = PolyLibClient.getClientPlayer();
        if (player == null) {
            return;
        }
        int index = manager.dataOrder.indexOf(data);
        PolyLibNetwork.sendDataValueToServerTile(player.method_56673(), buf -> {
            buf.method_10804(player.field_7512.field_7763);
            Object prev = data.get();
            data.set(value);
            buf.method_10804(index);
            data.toBytes((class_9129)buf);
            data.set(prev);
            data.isDirty(true);
        });
    }

    default public void handlePacketFromClient(class_3222 player, int id, class_2540 buf) {
    }
}

