/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.config;

import dev.architectury.platform.Platform;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import net.creeperhost.polylib.blue.endless.jankson.Jankson;
import net.creeperhost.polylib.blue.endless.jankson.JsonElement;
import net.creeperhost.polylib.blue.endless.jankson.JsonObject;
import net.creeperhost.polylib.config.ConfigData;
import org.jetbrains.annotations.NotNull;

public class ConfigBuilder {
    String CONFIG_NAME;
    AtomicReference<ConfigData> CONFIG_DATA = new AtomicReference();
    Path CONFIG_PATH;
    Class<?> CONFIG_DATA_CLASS;
    Jankson JANKSON = Jankson.builder().build();

    public ConfigBuilder(@NotNull String configName, @NotNull Path configPath, @NotNull Class<?> clazz) {
        this.CONFIG_NAME = configName;
        this.CONFIG_PATH = configPath;
        this.CONFIG_DATA_CLASS = clazz;
        if (this.CONFIG_PATH.toFile().exists()) {
            this.load();
        } else {
            this.save();
        }
    }

    public ConfigBuilder(@NotNull String configName, @NotNull Path configPath, ConfigData data) {
        this.CONFIG_NAME = configName;
        this.CONFIG_PATH = configPath;
        this.CONFIG_DATA_CLASS = data.getClass();
        if (this.CONFIG_PATH.toFile().exists()) {
            this.load(data);
        } else {
            this.save(data);
        }
    }

    public ConfigBuilder(@NotNull String configName, @NotNull Class<?> clazz) {
        this.CONFIG_NAME = configName;
        this.CONFIG_PATH = Platform.getConfigFolder().resolve(configName + ".json5");
        this.CONFIG_DATA_CLASS = clazz;
        if (this.CONFIG_PATH.toFile().exists()) {
            this.load();
        } else {
            this.save();
        }
    }

    public void load() {
        try {
            JsonObject jObject = this.JANKSON.load(this.CONFIG_PATH.toFile());
            ConfigData newData = (ConfigData)this.JANKSON.fromJson(jObject, this.CONFIG_DATA_CLASS);
            this.CONFIG_DATA.set(newData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(ConfigData data) {
        try {
            ConfigData newData;
            JsonObject jObject = this.JANKSON.load(this.CONFIG_PATH.toFile());
            data = newData = (ConfigData)this.JANKSON.fromJson(jObject, this.CONFIG_DATA_CLASS);
            this.CONFIG_DATA.set(newData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            ConfigData data = (ConfigData)this.CONFIG_DATA_CLASS.newInstance();
            this.CONFIG_DATA.set(data);
            FileWriter fileWriter = new FileWriter(this.CONFIG_PATH.toFile());
            fileWriter.write(this.saveConfig());
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(ConfigData data) {
        try {
            this.CONFIG_DATA.set(data);
            FileWriter fileWriter = new FileWriter(this.CONFIG_PATH.toFile());
            fileWriter.write(this.saveConfig());
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String saveConfig() {
        ConfigData conf = this.CONFIG_DATA.get();
        JsonElement elem = this.JANKSON.toJson(conf);
        return elem.toJson(true, true);
    }

    public String getConfigName() {
        return this.CONFIG_NAME;
    }

    public Path getConfigPath() {
        return this.CONFIG_PATH;
    }

    public ConfigData getConfigData() {
        return this.CONFIG_DATA.get();
    }
}

