/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.chalk.common;

import com.mclegoman.releasetypeutils.common.version.Helper;
import de.dafuqs.chalk.common.blocks.ChalkMarkBlock;
import de.dafuqs.chalk.common.blocks.GlowChalkMarkBlock;
import de.dafuqs.chalk.common.data.CompatibilityData;
import de.dafuqs.chalk.common.data.Data;
import de.dafuqs.chalk.common.items.ChalkItem;
import de.dafuqs.chalk.common.items.GlowChalkItem;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class ChalkRegistry {
    public static Map<class_1767, Integer> dyeColors = new TreeMap<class_1767, Integer>(){
        {
            this.put(class_1767.field_7952, 0xFFFFFF);
            this.put(class_1767.field_7946, 14770689);
            this.put(class_1767.field_7958, 11154080);
            this.put(class_1767.field_7951, 2460360);
            this.put(class_1767.field_7947, 15793941);
            this.put(class_1767.field_7961, 6269465);
            this.put(class_1767.field_7954, 14050703);
            this.put(class_1767.field_7944, 0x292929);
            this.put(class_1767.field_7967, 0x8B8B8B);
            this.put(class_1767.field_7955, 1406599);
            this.put(class_1767.field_7945, 6561692);
            this.put(class_1767.field_7966, 2895502);
            this.put(class_1767.field_7957, 6372384);
            this.put(class_1767.field_7942, 4807460);
            this.put(class_1767.field_7964, 9380129);
            this.put(class_1767.field_7963, 0x171717);
        }
    };
    public static Map<class_1767, ChalkVariant> chalkVariants = new HashMap<class_1767, ChalkVariant>();

    public static void init() {
        Data.CURRENT_VERSION.sendToLog(Helper.LogType.INFO, "Registering blocks and items...");
        for (Map.Entry<class_1767, Integer> entry : dyeColors.entrySet()) {
            ChalkVariant chalkVariant;
            class_1767 dyeColor = entry.getKey();
            int color = entry.getValue();
            if (dyeColor.equals((Object)class_1767.field_7952)) {
                chalkVariant = new ChalkVariant(dyeColor, color, "");
                chalkVariant.register();
                chalkVariants.put(dyeColor, chalkVariant);
                continue;
            }
            if (!CompatibilityData.COLORFUL_ADDON) continue;
            chalkVariant = new ChalkVariant(dyeColor, color, String.valueOf(dyeColor) + "_");
            chalkVariant.register();
            chalkVariants.put(dyeColor, chalkVariant);
        }
    }

    private static void registerBlock(String name, class_2248 block) {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)Data.CURRENT_VERSION.getID(), (String)name), (Object)block);
    }

    private static void registerItem(String name, class_1792 item) {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)Data.CURRENT_VERSION.getID(), (String)name), (Object)item);
    }

    private static boolean always(class_2680 blockState, class_1922 blockView, class_2338 blockPos) {
        return true;
    }

    private static boolean never(class_2680 blockState, class_1922 blockView, class_2338 blockPos) {
        return false;
    }

    public static class ChalkVariant {
        public class_1792 chalkItem;
        public class_2248 chalkBlock;
        public class_1792 glowChalkItem;
        public class_2248 glowChalkBlock;
        String colorString;
        int color;

        public ChalkVariant(class_1767 dyeColor, int color, String colorString) {
            this.color = color;
            this.colorString = colorString;
            this.chalkItem = new ChalkItem(new class_1792.class_1793().method_7889(1).method_7895(64), dyeColor);
            this.chalkBlock = new ChalkMarkBlock(class_4970.class_2251.method_9637().method_51371().method_9634().method_22488().method_9626(class_2498.field_11529).method_50012(class_3619.field_15971), dyeColor);
            this.glowChalkItem = new GlowChalkItem(new class_1792.class_1793().method_7889(1).method_7895(64), dyeColor);
            this.glowChalkBlock = new GlowChalkMarkBlock(class_4970.class_2251.method_9637().method_51371().method_9634().method_22488().method_9626(class_2498.field_11529).method_9631(state -> CompatibilityData.CONTINUITY ? 0 : 1).method_26247(CompatibilityData.CONTINUITY ? ChalkRegistry::never : ChalkRegistry::always).method_26249(CompatibilityData.CONTINUITY ? ChalkRegistry::never : ChalkRegistry::always).method_50012(class_3619.field_15971), dyeColor);
            this.ItemGroups();
        }

        public void ItemGroups() {
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> entries.method_45421((class_1935)this.chalkItem));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> entries.method_45421((class_1935)this.chalkItem));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> entries.method_45421((class_1935)this.glowChalkItem));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> entries.method_45421((class_1935)this.glowChalkItem));
        }

        public void register() {
            ChalkRegistry.registerBlock(this.colorString + "chalk_mark", this.chalkBlock);
            ChalkRegistry.registerItem(this.colorString + "chalk", this.chalkItem);
            ChalkRegistry.registerBlock(this.colorString + "glow_chalk_mark", this.glowChalkBlock);
            ChalkRegistry.registerItem(this.colorString + "glow_chalk", this.glowChalkItem);
        }

        public void registerClient() {
            BlockRenderLayerMap.INSTANCE.putBlock(this.chalkBlock, class_1921.method_23581());
            BlockRenderLayerMap.INSTANCE.putBlock(this.glowChalkBlock, class_1921.method_23581());
            ColorProviderRegistry.BLOCK.register((state, world, pos, index) -> this.color, (Object[])new class_2248[]{this.chalkBlock});
            ColorProviderRegistry.BLOCK.register((state, world, pos, index) -> this.color, (Object[])new class_2248[]{this.glowChalkBlock});
        }
    }
}

