/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.chalk.client.config;

import com.mclegoman.releasetypeutils.common.version.Helper;
import com.mclegoman.simplefabriclibs.simple_config.SimpleConfig;
import com.mojang.datafixers.util.Pair;
import de.dafuqs.chalk.common.data.Data;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigProvider
implements SimpleConfig.DefaultConfig {
    private String CONTENTS = "";
    private List<Pair<String, ?>> CONFIG_LIST = new ArrayList();

    public List<Pair<String, ?>> getConfigList() {
        return this.CONFIG_LIST;
    }

    public void add(String ID, Pair<String, ?> keyValuePair) {
        this.CONFIG_LIST.add(keyValuePair);
        this.getContents(ID);
    }

    public String get(String namespace) {
        return this.CONTENTS;
    }

    public void getContents(String ID) {
        StringBuilder contents = new StringBuilder("#" + ID + " properties file\n");
        for (Pair<String, ?> option : this.CONFIG_LIST) {
            contents.append((String)option.getFirst()).append("=").append(option.getSecond()).append("\n");
        }
        this.CONTENTS = contents.toString();
    }

    public void setConfig(String KEY_NAME, Object KEY_VALUE) {
        try {
            List<Pair<String, ?>> NEW_CONFIG_LIST = this.CONFIG_LIST;
            for (Pair<String, ?> key : NEW_CONFIG_LIST) {
                String KEY_FIRST = (String)key.getFirst();
                int KEY_INDEX = NEW_CONFIG_LIST.indexOf(key);
                if (!KEY_FIRST.equals(KEY_NAME)) continue;
                NEW_CONFIG_LIST.set(KEY_INDEX, new Pair((Object)KEY_NAME, KEY_VALUE));
            }
            this.CONFIG_LIST = NEW_CONFIG_LIST;
        }
        catch (Exception error) {
            Data.CURRENT_VERSION.sendToLog(Helper.LogType.ERROR, String.valueOf(error));
        }
    }

    public void saveConfig(String ID) {
        try {
            this.getContents(ID);
            PrintWriter writer = new PrintWriter(FabricLoader.getInstance().getConfigDir().resolve(ID + ".properties").toFile(), StandardCharsets.UTF_8);
            writer.write(this.CONTENTS);
            writer.close();
        }
        catch (Exception error) {
            Data.CURRENT_VERSION.sendToLog(Helper.LogType.ERROR, String.valueOf(error));
        }
    }
}

