/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import io.wispforest.owo.itemgroup.json.WrapperGroup;
import io.wispforest.owo.moddata.ModDataConsumer;
import io.wispforest.owo.util.pond.OwoItemExtensions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class OwoItemGroupLoader
implements ModDataConsumer {
    public static final OwoItemGroupLoader INSTANCE = new OwoItemGroupLoader();
    private static final Map<class_2960, JsonObject> BUFFERED_GROUPS = new HashMap<class_2960, JsonObject>();

    private OwoItemGroupLoader() {
    }

    public static void onGroupCreated(class_1761 group) {
        class_2960 groupId = class_7923.field_44687.method_10221((Object)group);
        if (!BUFFERED_GROUPS.containsKey(groupId)) {
            return;
        }
        INSTANCE.acceptParsedFile(groupId, BUFFERED_GROUPS.remove(groupId));
    }

    @Override
    public void acceptParsedFile(class_2960 id, JsonObject json) {
        class_2960 targetGroupId = class_2960.method_60654((String)class_3518.method_15265((JsonObject)json, (String)"target_group"));
        class_1761 searchGroup = null;
        for (class_1761 group : class_7706.method_47341()) {
            if (!class_7923.field_44687.method_10221((Object)group).equals((Object)targetGroupId)) continue;
            searchGroup = group;
            break;
        }
        if (searchGroup == null) {
            BUFFERED_GROUPS.put(targetGroupId, json);
            return;
        }
        class_1761 targetGroup = searchGroup;
        JsonArray tabsArray = class_3518.method_15292((JsonObject)json, (String)"tabs", (JsonArray)new JsonArray());
        ArrayList<ItemGroupTab> tabs = new ArrayList<ItemGroupTab>();
        tabsArray.forEach(jsonElement -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject tabObject = jsonElement.getAsJsonObject();
            class_2960 texture = class_2960.method_60654((String)class_3518.method_15253((JsonObject)tabObject, (String)"texture", (String)ItemGroupTab.DEFAULT_TEXTURE.toString()));
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)class_3518.method_15265((JsonObject)tabObject, (String)"tag")));
            class_1792 icon = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)class_3518.method_15265((JsonObject)tabObject, (String)"icon")));
            String name = class_3518.method_15265((JsonObject)tabObject, (String)"name");
            tabs.add(new ItemGroupTab(Icon.of((class_1935)icon), OwoItemGroup.ButtonDefinition.tooltipFor(targetGroup, "tab", name), (context, entries) -> class_7923.field_41178.method_10220().filter(item -> item.method_40131().method_40220(tag)).forEach(arg_0 -> ((class_1761.class_7704)entries).method_45421(arg_0)), texture, false));
        });
        JsonArray buttonsArray = class_3518.method_15292((JsonObject)json, (String)"buttons", (JsonArray)new JsonArray());
        ArrayList<ItemGroupButton> buttons = new ArrayList<ItemGroupButton>();
        buttonsArray.forEach(jsonElement -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject buttonObject = jsonElement.getAsJsonObject();
            String link = class_3518.method_15265((JsonObject)buttonObject, (String)"link");
            String name = class_3518.method_15265((JsonObject)buttonObject, (String)"name");
            int u = class_3518.method_15260((JsonObject)buttonObject, (String)"texture_u");
            int v = class_3518.method_15260((JsonObject)buttonObject, (String)"texture_v");
            int textureWidth = class_3518.method_15282((JsonObject)buttonObject, (String)"texture_width", (int)64);
            int textureHeight = class_3518.method_15282((JsonObject)buttonObject, (String)"texture_height", (int)64);
            String textureId = class_3518.method_15253((JsonObject)buttonObject, (String)"texture", null);
            class_2960 texture = textureId == null ? ItemGroupButton.ICONS_TEXTURE : class_2960.method_60654((String)textureId);
            buttons.add(ItemGroupButton.link(targetGroup, Icon.of(texture, u, v, textureWidth, textureHeight), name, link));
        });
        if (targetGroup instanceof WrapperGroup) {
            WrapperGroup wrapper = (WrapperGroup)targetGroup;
            wrapper.addTabs(tabs);
            wrapper.addButtons(buttons);
            if (class_3518.method_15258((JsonObject)json, (String)"extend", (boolean)false)) {
                wrapper.markExtension();
            }
        } else {
            WrapperGroup wrapper = new WrapperGroup(targetGroup, targetGroupId, tabs, buttons);
            wrapper.initialize();
            if (class_3518.method_15258((JsonObject)json, (String)"extend", (boolean)false)) {
                wrapper.markExtension();
            }
            class_7923.field_41178.method_10220().filter(item -> ((OwoItemExtensions)item).owo$group() == targetGroup).forEach(item -> ((OwoItemExtensions)item).owo$setGroup(wrapper));
        }
    }

    @Override
    public String getDataSubdirectory() {
        return "item_group_tabs";
    }

    static {
        RegistryEntryAddedCallback.event((class_2378)class_7923.field_44687).register((rawId, id, group) -> OwoItemGroupLoader.onGroupCreated(group));
    }
}

