/*
 * Decompiled with CFR 0.152.
 */
package net.stehschnitzel.shutter.block;

import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2269;
import net.minecraft.class_2297;
import net.minecraft.class_2298;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2362;
import net.minecraft.class_2399;
import net.minecraft.class_2401;
import net.minecraft.class_2459;
import net.minecraft.class_2484;
import net.minecraft.class_2508;
import net.minecraft.class_2527;
import net.minecraft.class_2537;
import net.minecraft.class_2538;
import net.minecraft.class_2541;
import net.minecraft.class_2560;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3709;
import net.minecraft.class_3749;
import net.minecraft.class_4970;
import net.minecraft.class_5172;
import net.minecraft.class_5542;
import net.minecraft.class_5543;
import net.minecraft.class_5544;
import net.minecraft.class_5554;
import net.minecraft.class_5689;
import net.minecraft.class_5801;
import net.minecraft.class_5802;
import net.minecraft.class_5809;
import net.stehschnitzel.shutter.block.Shutter;
import net.stehschnitzel.shutter.block.properties.ShutterDouble;
import net.stehschnitzel.shutter.block.properties.ShutterPos;
import net.stehschnitzel.shutter.init.SoundInit;

abstract class AbstractShutter
extends class_2248 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<ShutterPos> POS = class_2754.method_11850((String)"half", ShutterPos.class);
    public static final class_2758 OPEN = class_2758.method_11867((String)"open", (int)0, (int)2);
    public static final class_2754<ShutterDouble> DOUBLE_DOOR = class_2754.method_11850((String)"double_door", ShutterDouble.class);
    boolean isMetal = false;

    public AbstractShutter(class_4970.class_2251 settings, boolean isMetal) {
        super(settings);
        this.isMetal = isMetal;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)OPEN, (Comparable)Integer.valueOf(0))).method_11657(POS, (Comparable)((Object)ShutterPos.NORMAL))).method_11657(DOUBLE_DOOR, (Comparable)((Object)ShutterDouble.NONE)));
    }

    void updateRedstone(class_1937 world, class_2338 pos, boolean first) {
        this.updateRedstone(world, pos, first, (ShutterDouble)((Object)world.method_8320(pos).method_11654(DOUBLE_DOOR)), (class_2350)world.method_8320(pos).method_11654((class_2769)FACING));
    }

    void updateRedstone(class_1937 world, class_2338 pos, boolean first, ShutterDouble doorType, class_2350 facing) {
        if (doorType == ShutterDouble.NONE) {
            if (this.stateTwoPossible(world, pos, first, false)) {
                this.updateAll(world, pos, 2, first, false);
            } else {
                this.updateAll(world, pos, 1, first, false);
            }
        } else {
            class_2338 neighborPos = this.getNeighborShutterPos(pos, doorType, facing);
            if (this.stateTwoPossibleDouble(world, pos, first, doorType, facing)) {
                this.updateAll(world, pos, 2, first, true);
                this.updateAll(world, neighborPos, 2, false, true);
            } else {
                this.updateAll(world, pos, 1, first, true);
                this.updateAll(world, neighborPos, 1, false, true);
            }
        }
    }

    public void update(class_1937 world, class_2338 pos, int state, boolean first) {
        ShutterDouble doorType = (ShutterDouble)((Object)world.method_8320(pos).method_11654(DOUBLE_DOOR));
        if (doorType == ShutterDouble.NONE) {
            this.updateSingleDoor(world, pos, state, first);
        } else {
            this.updateDoubleDoor(world, pos, state, first, doorType);
        }
    }

    private void updateSingleDoor(class_1937 world, class_2338 pos, int state, boolean first) {
        if (state < 2) {
            this.updateAll(world, pos, state, first, false);
        } else if (state == 2 && this.stateTwoPossible(world, pos, first, false)) {
            this.updateAll(world, pos, 2, first, false);
        } else {
            this.updateAll(world, pos, 0, first, false);
        }
    }

    private void updateDoubleDoor(class_1937 world, class_2338 pos, int state, boolean first, ShutterDouble doorType) {
        List<class_2680> sideblocks = this.getNeighborBlocks((class_1936)world, pos);
        class_2338 neighborPos = this.getNeighborShutterPos((class_1936)world, pos);
        if (state < 2) {
            this.updateAll(world, pos, state, first, true);
            this.updateAll(world, neighborPos, state, first, true);
        } else if (state == 2 && this.stateTwoPossibleDouble(world, pos, first)) {
            this.updateAll(world, pos, 2, first, true);
            this.updateAll(world, neighborPos, 2, first, true);
        } else {
            this.updateAll(world, pos, 0, first, true);
            this.updateAll(world, neighborPos, 0, first, true);
        }
    }

    boolean stateTwoPossibleDouble(class_1937 world, class_2338 pos, boolean first) {
        return this.stateTwoPossibleDouble(world, pos, first, (ShutterDouble)((Object)world.method_8320(pos).method_11654(DOUBLE_DOOR)), (class_2350)world.method_8320(pos).method_11654((class_2769)FACING));
    }

    boolean stateTwoPossibleDouble(class_1937 world, class_2338 pos, boolean first, ShutterDouble shutterDouble, class_2350 facing) {
        boolean thisCanUpdate = this.stateTwoPossible(world, pos, first, true);
        class_2338 neighborPos = this.getNeighborShutterPos(pos, shutterDouble, facing);
        return thisCanUpdate && this.stateTwoPossible(world, neighborPos, first, true);
    }

    private void updateAll(class_1937 world, class_2338 pos, int state, boolean first, boolean isDouble) {
        boolean[] arr;
        if (!first) {
            this.setOpen(world, pos, state);
        }
        block0: for (boolean up : arr = new boolean[]{true, false}) {
            class_2338 newPos;
            class_2248 block;
            int y = pos.method_10264() + (up ? 1 : -1);
            while (y > -70 && y < 330 && (block = world.method_8320(newPos = new class_2338(pos.method_10263(), y, pos.method_10260())).method_26204()) instanceof Shutter) {
                Shutter shutter = (Shutter)block;
                if (isDouble && world.method_8320(newPos).method_11654(DOUBLE_DOOR) == ShutterDouble.NONE || !isDouble && world.method_8320(newPos).method_11654(DOUBLE_DOOR) != ShutterDouble.NONE) continue block0;
                shutter.setOpen(world, newPos, state);
                y = up ? y + 1 : y - 1;
            }
        }
    }

    boolean stateTwoPossible(class_1937 world, class_2338 pos, boolean first, boolean isDouble) {
        Shutter shutter;
        class_2248 class_22482;
        boolean[] arr = new boolean[]{true, false};
        if (!first && (class_22482 = world.method_8320(pos).method_26204()) instanceof Shutter && !(shutter = (Shutter)class_22482).canUpdate((class_1936)world, pos)) {
            return false;
        }
        block0: for (boolean up : arr) {
            class_2338 newPos;
            class_2248 block;
            int y = pos.method_10264();
            while (y > -70 && y < 330 && (block = world.method_8320(newPos = new class_2338(pos.method_10263(), y, pos.method_10260())).method_26204()) instanceof Shutter) {
                Shutter shutter2 = (Shutter)block;
                if (isDouble && world.method_8320(newPos).method_11654(DOUBLE_DOOR) == ShutterDouble.NONE || !isDouble && world.method_8320(newPos).method_11654(DOUBLE_DOOR) != ShutterDouble.NONE) continue block0;
                if (!shutter2.canUpdate((class_1936)world, newPos)) {
                    return false;
                }
                y = up ? y + 1 : y - 1;
            }
        }
        return true;
    }

    List<class_2680> getNeighborBlocks(class_1936 world, class_2338 pos) {
        return this.getNeighborBlocks(world, pos, (class_2350)world.method_8320(pos).method_11654((class_2769)FACING));
    }

    List<class_2680> getNeighborBlocks(class_1936 world, class_2338 pos, class_2350 facing) {
        switch (facing) {
            case field_11043: {
                return List.of(new class_2680[]{world.method_8320(pos.method_10078()), world.method_8320(pos.method_10067())});
            }
            case field_11035: {
                return List.of(new class_2680[]{world.method_8320(pos.method_10067()), world.method_8320(pos.method_10078())});
            }
            case field_11034: {
                return List.of(new class_2680[]{world.method_8320(pos.method_10072()), world.method_8320(pos.method_10095())});
            }
        }
        return List.of(new class_2680[]{world.method_8320(pos.method_10095()), world.method_8320(pos.method_10072())});
    }

    public void playSound(class_1937 world, class_2338 pos, int state) {
        world.method_8396(null, pos, this.getSound(state), class_3419.field_15245, 1.0f, 1.0f);
    }

    private class_3414 getSound(int state) {
        return state == 0 ? SoundInit.SHUTTER_CLOSE : (state == 2 ? SoundInit.SHUTTER_OPEN_HALF : SoundInit.SHUTTER_OPEN_FULL);
    }

    class_2338 getNeighborShutterPos(class_1936 world, class_2338 pos) {
        return this.getNeighborShutterPos(pos, world.method_8320(pos));
    }

    class_2338 getNeighborShutterPos(class_2338 pos, class_2680 state) {
        return this.getNeighborShutterPos(pos, (ShutterDouble)((Object)state.method_11654(DOUBLE_DOOR)), (class_2350)state.method_11654((class_2769)FACING));
    }

    class_2338 getNeighborShutterPos(class_2338 pos, ShutterDouble shutterDouble, class_2350 facing) {
        switch (facing) {
            case field_11035: {
                return shutterDouble == ShutterDouble.RIGHT ? pos.method_10067() : pos.method_10078();
            }
            case field_11043: {
                return shutterDouble == ShutterDouble.RIGHT ? pos.method_10078() : pos.method_10067();
            }
            case field_11034: {
                return shutterDouble == ShutterDouble.RIGHT ? pos.method_10072() : pos.method_10095();
            }
        }
        return shutterDouble == ShutterDouble.RIGHT ? pos.method_10095() : pos.method_10072();
    }

    public void redstoneUpdate(class_1937 pWorld, class_2338 pFromPos, class_2338 pPos) {
        if (!(pWorld.method_8320(pFromPos).method_26204() instanceof Shutter)) {
            if ((pWorld.method_49803(pPos) || pWorld.method_49803(pPos.method_10084())) && !((Boolean)pWorld.method_8320(pPos).method_11654((class_2769)POWERED)).booleanValue()) {
                this.setPowered(pWorld, pPos, true);
                this.updateRedstone(pWorld, pPos, false);
                this.playSound(pWorld, pPos, (Integer)pWorld.method_8320(pPos).method_11654((class_2769)OPEN));
            } else if (!pWorld.method_49803(pPos) && ((Boolean)pWorld.method_8320(pPos).method_11654((class_2769)POWERED)).booleanValue()) {
                this.setPowered(pWorld, pPos, false);
                this.update(pWorld, pPos, 0, false);
                this.playSound(pWorld, pPos, 0);
            }
        }
    }

    ShutterPos getPosition(class_1936 pWorld, class_2338 pPos) {
        return this.getPosition(pWorld, pPos, (ShutterDouble)((Object)pWorld.method_8320(pPos).method_11654(DOUBLE_DOOR)));
    }

    ShutterPos getPosition(class_1936 pWorld, class_2338 pPos, ShutterDouble shutterDouble) {
        boolean below;
        boolean above = this.getBlockAbove(pPos, pWorld) instanceof Shutter && (shutterDouble == ShutterDouble.NONE && pWorld.method_8320(pPos.method_10084()).method_11654(DOUBLE_DOOR) == ShutterDouble.NONE || shutterDouble != ShutterDouble.NONE && pWorld.method_8320(pPos.method_10084()).method_11654(DOUBLE_DOOR) != ShutterDouble.NONE);
        boolean bl = below = this.getBlockBelow(pPos, pWorld) instanceof Shutter && (shutterDouble == ShutterDouble.NONE && pWorld.method_8320(pPos.method_10074()).method_11654(DOUBLE_DOOR) == ShutterDouble.NONE || shutterDouble != ShutterDouble.NONE && pWorld.method_8320(pPos.method_10074()).method_11654(DOUBLE_DOOR) != ShutterDouble.NONE);
        if (above && below) {
            return ShutterPos.MIDDLE;
        }
        if (above) {
            return ShutterPos.LOWER;
        }
        if (below) {
            return ShutterPos.UPPER;
        }
        return ShutterPos.NORMAL;
    }

    public boolean canUpdate(class_1936 world, class_2338 pos) {
        List<class_2680> sideblocks = this.getNeighborBlocks(world, pos);
        ShutterDouble shutterDouble = (ShutterDouble)((Object)world.method_8320(pos).method_11654(DOUBLE_DOOR));
        if (shutterDouble == ShutterDouble.NONE) {
            return this.canUpdateSingle(sideblocks);
        }
        return this.canUpdateDouble(shutterDouble, sideblocks);
    }

    private boolean canUpdateDouble(ShutterDouble shutterDouble, List<class_2680> sideblocks) {
        if (shutterDouble == ShutterDouble.RIGHT) {
            return this.isValidBlockForUpdate(sideblocks.get(1).method_26204());
        }
        return this.isValidBlockForUpdate(sideblocks.get(0).method_26204());
    }

    boolean canUpdateSingle(List<class_2680> sideblocks) {
        for (class_2680 block1 : sideblocks) {
            if (this.isValidBlockForUpdate(block1.method_26204())) continue;
            return false;
        }
        return true;
    }

    private boolean isValidBlockForUpdate(class_2248 block) {
        return block == class_2246.field_10124 || block instanceof class_2261 || block instanceof class_2354 || block instanceof class_2349 || block == class_2246.field_10382 || block == class_2246.field_10164 || block == class_2246.field_10576 || block instanceof class_3749 || block instanceof class_2362 || block instanceof class_2527 || block instanceof class_5544 || block instanceof class_2269 || block instanceof class_2399 || block instanceof class_2508 || block instanceof class_5172 || block instanceof class_2541 || block instanceof class_2459 || block instanceof class_2401 || block instanceof class_2538 || block instanceof class_2537 || block instanceof class_5554 || block instanceof class_3709 || block instanceof class_5801 || block instanceof class_5802 || block instanceof class_5689 || block instanceof class_5542 || block instanceof class_5543 || block instanceof class_2560 || block instanceof class_2297 || block instanceof class_2298 || block instanceof class_2484 || block instanceof class_5809 || block instanceof class_2211;
    }

    public void setPowered(class_1937 world, class_2338 pos, boolean state) {
        world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(state)), 3);
    }

    public void setOpen(class_1937 world, class_2338 pos, int state) {
        world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)OPEN, (Comparable)Integer.valueOf(state)), 3);
    }

    class_2248 getBlockAbove(class_2338 pos, class_1936 world) {
        return world.method_8320(pos.method_10084()).method_26204();
    }

    class_2248 getBlockBelow(class_2338 pos, class_1936 world) {
        return world.method_8320(pos.method_10074()).method_26204();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POS});
        builder.method_11667(new class_2769[]{FACING});
        builder.method_11667(new class_2769[]{OPEN});
        builder.method_11667(new class_2769[]{POWERED});
        builder.method_11667(new class_2769[]{DOUBLE_DOOR});
    }
}

