/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import glitchcore.event.Event;
import glitchcore.event.EventManager;
import glitchcore.event.TickEvent;
import glitchcore.event.player.PlayerEvent;
import glitchcore.network.CustomPacket;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4284;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import sereneseasons.api.SSGameRules;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonChangedEvent;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModPackets;
import sereneseasons.init.ModTags;
import sereneseasons.network.SyncSeasonCyclePacket;
import sereneseasons.season.SeasonHandlerClient;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public class SeasonHandler
implements SeasonHelper.ISeasonDataProvider {
    public static final HashMap<class_1937, Long> lastDayTimes = new HashMap();
    public static final HashMap<class_1937, Integer> updateTicks = new HashMap();
    public static final HashMap<class_5321<class_1937>, Integer> prevServerSeasonCycleTicks = new HashMap();

    public static void onLevelTick(TickEvent.Level event) {
        MinecraftServer server;
        class_1937 level = event.getLevel();
        if (event.getPhase() != TickEvent.Phase.START || level.method_8608() || !ModConfig.seasons.isDimensionWhitelisted((class_5321<class_1937>)level.method_27983())) {
            return;
        }
        long dayTime = level.method_8532();
        long lastDayTime = lastDayTimes.getOrDefault(level, dayTime);
        lastDayTimes.put(level, dayTime);
        if (!level.method_8450().method_8355(SSGameRules.RULE_DOSEASONCYCLE)) {
            return;
        }
        if (!ModConfig.seasons.progressSeasonWhileOffline && (server = level.method_8503()) != null && server.method_3760().method_14574() == 0) {
            return;
        }
        long difference = dayTime - lastDayTime;
        if (difference == 0L) {
            return;
        }
        if (difference < 0L) {
            difference += 24000L;
        }
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        savedData.seasonCycleTicks = class_3532.method_15387((int)(savedData.seasonCycleTicks + (int)difference), (int)SeasonTime.ZERO.getCycleDuration());
        int ticks = updateTicks.getOrDefault(level, 0);
        if (ticks >= 20) {
            SeasonHandler.sendSeasonUpdate(level);
            ticks %= 20;
        }
        updateTicks.put(level, ticks + 1);
        savedData.method_80();
    }

    public static void onJoinLevel(PlayerEvent.JoinLevel event) {
        class_1657 class_16572 = event.getPlayer();
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        class_1937 level = player.method_37908();
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        ModPackets.HANDLER.sendToPlayer((CustomPacket)new SyncSeasonCyclePacket((class_5321<class_1937>)level.method_27983(), savedData.seasonCycleTicks), player);
    }

    public static void sendSeasonUpdate(class_1937 level) {
        if (level.method_8608()) {
            return;
        }
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        SeasonTime newTime = new SeasonTime(savedData.seasonCycleTicks);
        SeasonTime prevTime = new SeasonTime(prevServerSeasonCycleTicks.computeIfAbsent((class_5321<class_1937>)level.method_27983(), key -> newTime.getSeasonCycleTicks()));
        Season.SubSeason prevSeason = prevTime.getSubSeason();
        Season.TropicalSeason prevTropicalSeason = prevTime.getTropicalSeason();
        Season.SubSeason newSeason = newTime.getSubSeason();
        Season.TropicalSeason newTropicalSeason = newTime.getTropicalSeason();
        prevServerSeasonCycleTicks.put((class_5321<class_1937>)level.method_27983(), newTime.getSeasonCycleTicks());
        if (!prevSeason.equals(newSeason)) {
            EventManager.fire((Event)new SeasonChangedEvent.Standard(level, prevSeason, newSeason));
        }
        if (!prevTropicalSeason.equals(newTropicalSeason)) {
            EventManager.fire((Event)new SeasonChangedEvent.Tropical(level, prevTropicalSeason, newTropicalSeason));
        }
        ModPackets.HANDLER.sendToAll((CustomPacket)new SyncSeasonCyclePacket((class_5321<class_1937>)level.method_27983(), savedData.seasonCycleTicks), ((class_3218)level).method_8503());
    }

    public static SeasonSavedData getSeasonSavedData(class_1937 w) {
        if (w.method_8608() || !(w instanceof class_3218)) {
            return null;
        }
        class_3218 world = (class_3218)w;
        class_26 saveDataManager = world.method_14178().method_17981();
        Supplier<SeasonSavedData> defaultSaveDataSupplier = () -> {
            SeasonSavedData savedData = new SeasonSavedData();
            int startingSeason = ModConfig.seasons.startingSubSeason;
            if (startingSeason == 0) {
                savedData.seasonCycleTicks = world.field_9229.method_43048(12) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            if (startingSeason > 0) {
                savedData.seasonCycleTicks = (startingSeason - 1) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            savedData.method_80();
            return savedData;
        };
        return (SeasonSavedData)saveDataManager.method_17924(new class_18.class_8645(defaultSaveDataSupplier, SeasonSavedData::load, class_4284.field_19212), "seasons");
    }

    @Override
    public ISeasonState getServerSeasonState(class_1937 world) {
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
        return new SeasonTime(savedData.seasonCycleTicks);
    }

    @Override
    public ISeasonState getClientSeasonState(class_1937 level) {
        int time = level != null ? SeasonHandlerClient.clientSeasonCycleTicks.getOrDefault(level.method_27983(), 0) : 0;
        return new SeasonTime(time);
    }

    @Override
    public boolean usesTropicalSeasons(class_6880<class_1959> biome) {
        return biome.method_40220(ModTags.Biomes.TROPICAL_BIOMES);
    }
}

