/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_1163;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModTags;
import sereneseasons.util.SeasonColorUtil;

public class SeasonColorHandlers {
    private static final Multimap<ResolverType, ColorOverride> resolverOverrides = HashMultimap.create();
    private static class_6539 originalGrassColorResolver;
    private static class_6539 originalFoliageColorResolver;

    public static void setup() {
        SeasonColorHandlers.registerGrassAndFoliageColorHandlers();
    }

    public static void registerResolverOverride(ResolverType type, ColorOverride override) {
        resolverOverrides.put((Object)type, (Object)override);
    }

    private static void registerGrassAndFoliageColorHandlers() {
        originalGrassColorResolver = class_1163.field_5665;
        originalFoliageColorResolver = class_1163.field_5664;
        class_1163.field_5665 = (biome, x, z) -> SeasonColorHandlers.resolveColors(ResolverType.GRASS, biome, x, z);
        class_1163.field_5664 = (biome, x, z) -> SeasonColorHandlers.resolveColors(ResolverType.FOLIAGE, biome, x, z);
    }

    private static int resolveColors(ResolverType type, class_1959 biome, double x, double z) {
        int originalColor = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> originalGrassColorResolver.getColor(biome, x, z);
            case 1 -> originalFoliageColorResolver.getColor(biome, x, z);
        };
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level == null) {
            return originalColor;
        }
        class_2378 biomeRegistry = level.method_30349().method_30530(class_7924.field_41236);
        class_6880 biomeHolder = biomeRegistry.method_29113((Object)biome).flatMap(arg_0 -> ((class_2378)biomeRegistry).method_40264(arg_0)).orElse(null);
        if (biomeHolder != null) {
            int seasonalColor;
            ISeasonState calendar = SeasonHelper.getSeasonState((class_1937)level);
            Enum colorProvider = biomeHolder.method_40220(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
            int currentColor = seasonalColor = (switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SeasonColorUtil.applySeasonalGrassColouring(colorProvider, (class_6880<class_1959>)biomeHolder, originalColor);
                case 1 -> SeasonColorUtil.applySeasonalFoliageColouring(colorProvider, (class_6880<class_1959>)biomeHolder, originalColor);
            });
            for (ColorOverride override : resolverOverrides.get((Object)type)) {
                currentColor = override.apply(originalColor, seasonalColor, currentColor, (class_6880<class_1959>)biomeHolder, x, z);
            }
            return currentColor;
        }
        return originalColor;
    }

    public static enum ResolverType {
        GRASS,
        FOLIAGE;

    }

    public static interface ColorOverride {
        public int apply(int var1, int var2, int var3, class_6880<class_1959> var4, double var5, double var7);
    }
}

