/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.biome;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.regions_unexplored.world.level.biome.DefaultBiomes;
import net.regions_unexplored.world.level.biome.VanillaFallbackBiome;

public class RegionSecondaryBiomeBuilder {
    public final class_6544.class_6546[] temperatures = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.45f), class_6544.class_6546.method_38121((float)-0.45f, (float)-0.15f), class_6544.class_6546.method_38121((float)-0.15f, (float)0.2f), class_6544.class_6546.method_38121((float)0.2f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    public final class_6544.class_6546[] humidities = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.35f), class_6544.class_6546.method_38121((float)-0.35f, (float)-0.1f), class_6544.class_6546.method_38121((float)-0.1f, (float)0.1f), class_6544.class_6546.method_38121((float)0.1f, (float)0.3f), class_6544.class_6546.method_38121((float)0.3f, (float)1.0f)};
    public final class_6544.class_6546[] erosions = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.78f), class_6544.class_6546.method_38121((float)-0.78f, (float)-0.375f), class_6544.class_6546.method_38121((float)-0.375f, (float)-0.2225f), class_6544.class_6546.method_38121((float)-0.2225f, (float)0.05f), class_6544.class_6546.method_38121((float)0.05f, (float)0.45f), class_6544.class_6546.method_38121((float)0.45f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    public final class_6544.class_6546 FULL_RANGE = class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f);
    public final class_6544.class_6546 FROZEN_RANGE = this.temperatures[0];
    public final class_6544.class_6546 UNFROZEN_RANGE = class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatures[1], (class_6544.class_6546)this.temperatures[4]);
    public final class_6544.class_6546 mushroomFieldsContinentalness = class_6544.class_6546.method_38121((float)-1.2f, (float)-1.05f);
    public final class_6544.class_6546 deepOceanContinentalness = class_6544.class_6546.method_38121((float)-1.05f, (float)-0.455f);
    public final class_6544.class_6546 oceanContinentalness = class_6544.class_6546.method_38121((float)-0.455f, (float)-0.19f);
    public final class_6544.class_6546 coastContinentalness = class_6544.class_6546.method_38121((float)-0.19f, (float)-0.11f);
    public final class_6544.class_6546 inlandContinentalness = class_6544.class_6546.method_38121((float)-0.11f, (float)0.55f);
    public final class_6544.class_6546 nearInlandContinentalness = class_6544.class_6546.method_38121((float)-0.11f, (float)0.03f);
    public final class_6544.class_6546 midInlandContinentalness = class_6544.class_6546.method_38121((float)0.03f, (float)0.3f);
    public final class_6544.class_6546 farInlandContinentalness = class_6544.class_6546.method_38121((float)0.3f, (float)1.0f);
    public final class_5321<class_1959>[][] MIDDLE_BIOMES = DefaultBiomes.getSecondaryMiddleBiome();
    public final class_5321<class_1959>[][] MIDDLE_BIOMES_VARIANT = DefaultBiomes.getSecondaryMiddleBiomeVariant();
    public final class_5321<class_1959>[][] PLATEAU_BIOMES = DefaultBiomes.getSecondaryPlateauBiome();
    public final class_5321<class_1959>[][] PLATEAU_BIOMES_VARIANT = DefaultBiomes.getSecondaryPlateauBiomeVariant();
    public final class_5321<class_1959>[][] SHATTERED_BIOMES = DefaultBiomes.getSecondaryShatteredBiome();
    public final class_5321<class_1959>[][] RIVER_BIOMES = DefaultBiomes.getSecondaryRiverBiome();
    public final class_5321<class_1959>[][] RIVER_BIOMES_VARIANT = DefaultBiomes.getSecondaryRiverBiomeVariant();
    public final class_5321<class_1959>[][] SWAMP_BIOMES = DefaultBiomes.getSecondarySwampBiome();
    public final class_5321<class_1959>[][] OCEANS = DefaultBiomes.getSecondaryOceanBiome();

    public void addBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder) {
        this.addOffCoastBiomes(builder);
        this.addInlandBiomes(builder);
        this.addUndergroundBiomes(builder);
    }

    public void addOffCoastBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder) {
        this.addSurfaceBiome(builder, this.temperatures[0], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryIslandBiome(0)) ? DefaultBiomes.getSecondaryIslandBiome(0) : class_1972.field_9462);
        this.addSurfaceBiome(builder, this.temperatures[1], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryIslandBiome(1)) ? DefaultBiomes.getSecondaryIslandBiome(1) : class_1972.field_9462);
        this.addSurfaceBiome(builder, this.temperatures[2], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryIslandBiome(2)) ? DefaultBiomes.getSecondaryIslandBiome(2) : class_1972.field_9462);
        this.addSurfaceBiome(builder, this.temperatures[3], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryIslandBiome(3)) ? DefaultBiomes.getSecondaryIslandBiome(3) : class_1972.field_9462);
        this.addSurfaceBiome(builder, this.temperatures[4], this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryIslandBiome(4)) ? DefaultBiomes.getSecondaryIslandBiome(4) : class_1972.field_9462);
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 climate$parameter = this.temperatures[i];
            this.addSurfaceBiome(builder, climate$parameter, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(this.OCEANS[0][i]) ? this.OCEANS[0][i] : VanillaFallbackBiome.VANILLA_OCEANS[0][i]);
            this.addSurfaceBiome(builder, climate$parameter, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(this.OCEANS[1][i]) ? this.OCEANS[1][i] : VanillaFallbackBiome.VANILLA_OCEANS[0][i]);
        }
    }

    public void addInlandBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder) {
        this.addMidSlice(builder, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(builder, class_6544.class_6546.method_38121((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(builder, class_6544.class_6546.method_38121((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(builder, class_6544.class_6546.method_38121((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(builder, class_6544.class_6546.method_38121((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(builder, class_6544.class_6546.method_38121((float)-0.26666668f, (float)-0.05f));
        this.addValleys(builder, class_6544.class_6546.method_38121((float)-0.05f, (float)0.05f));
        this.addLowSlice(builder, class_6544.class_6546.method_38121((float)0.05f, (float)0.26666668f));
        this.addMidSlice(builder, class_6544.class_6546.method_38121((float)0.26666668f, (float)0.4f));
        this.addHighSlice(builder, class_6544.class_6546.method_38121((float)0.4f, (float)0.56666666f));
        this.addPeaks(builder, class_6544.class_6546.method_38121((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(builder, class_6544.class_6546.method_38121((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(builder, class_6544.class_6546.method_38121((float)0.93333334f, (float)1.0f));
    }

    public void addPeaks(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                class_5321<class_1959> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                class_5321<class_1959> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                class_5321<class_1959> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                class_5321<class_1959> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, shatteredBiome);
                class_5321<class_1959> peakBiomes = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomes);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, peakBiomes);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    public void addHighSlice(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                class_5321<class_1959> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                class_5321<class_1959> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                class_5321<class_1959> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                class_5321<class_1959> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                class_5321<class_1959> slopeBiome = this.pickSlopeBiome(i, j, weirdness);
                class_5321<class_1959> peakBiome = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    public void addMidSlice(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder, class_6544.class_6546 weirdness) {
        class_5321<class_1959> stoneBeachCold = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryStoneShoreBiome(true)) ? DefaultBiomes.getSecondaryStoneShoreBiome(true) : class_1972.field_9419;
        class_5321<class_1959> stoneBeachHot = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryStoneShoreBiome(false)) ? DefaultBiomes.getSecondaryStoneShoreBiome(false) : class_1972.field_9419;
        this.addSurfaceBiome(builder, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatures[0], (class_6544.class_6546)this.temperatures[2]), this.FULL_RANGE, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[2]), weirdness, 0.0f, stoneBeachCold);
        this.addSurfaceBiome(builder, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatures[3], (class_6544.class_6546)this.temperatures[4]), this.FULL_RANGE, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[2]), weirdness, 0.0f, stoneBeachHot);
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                class_5321<class_1959> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                class_5321<class_1959> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                class_5321<class_1959> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                class_5321<class_1959> swampBiome = this.pickSwampBiome(i, j);
                class_5321<class_1959> beachBiome = this.pickBeachBiome(i);
                class_5321<class_1959> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                class_5321<class_1959> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                class_5321<class_1959> slopeBiome = this.pickSlopeBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? slopeBiome : plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiome);
                if (weirdness.comp_104() < 0L) {
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, beachBiome);
                    this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                } else {
                    this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                }
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiome);
                if (weirdness.comp_104() < 0L) {
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                    continue;
                }
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    public void addLowSlice(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder, class_6544.class_6546 weirdness) {
        class_5321<class_1959> stoneBeachCold = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryStoneShoreBiome(true)) ? DefaultBiomes.getSecondaryStoneShoreBiome(true) : class_1972.field_9419;
        class_5321<class_1959> stoneBeachHot = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryStoneShoreBiome(false)) ? DefaultBiomes.getSecondaryStoneShoreBiome(false) : class_1972.field_9419;
        this.addSurfaceBiome(builder, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatures[0], (class_6544.class_6546)this.temperatures[2]), this.FULL_RANGE, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[2]), weirdness, 0.0f, stoneBeachCold);
        this.addSurfaceBiome(builder, class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatures[3], (class_6544.class_6546)this.temperatures[4]), this.FULL_RANGE, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[2]), weirdness, 0.0f, stoneBeachHot);
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                class_5321<class_1959> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                class_5321<class_1959> swampBiome = this.pickSwampBiome(i, j);
                class_5321<class_1959> beachBiome = this.pickBeachBiome(i);
                class_5321<class_1959> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                class_5321<class_1959> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[3], (class_6544.class_6546)this.erosions[4]), weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
            }
        }
    }

    public void addValleys(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder, class_6544.class_6546 weirdness) {
        class_5321<class_1959> stoneBeachCold = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryStoneShoreBiome(true)) ? DefaultBiomes.getSecondaryStoneShoreBiome(true) : class_1972.field_9419;
        class_5321<class_1959> stoneBeachHot = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryStoneShoreBiome(false)) ? DefaultBiomes.getSecondaryStoneShoreBiome(false) : class_1972.field_9419;
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                class_5321<class_1959> swampBiome = this.pickSwampBiome(i, j);
                class_5321<class_1959> riverBiome = this.pickRiverBiome(i, j, weirdness);
                class_5321<class_1959> cliffBiome = (float)this.temperatures[i].comp_104() <= -0.45f ? stoneBeachCold : stoneBeachHot;
                class_5321<class_1959> maybePickCliff = weirdness.comp_104() < 0L ? cliffBiome : riverBiome;
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, maybePickCliff);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, riverBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[5]), weirdness, 0.0f, riverBiome);
                this.addSurfaceBiome(builder, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.inlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, riverBiome);
            }
        }
    }

    public void addUndergroundBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder) {
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.9f), this.FULL_RANGE, class_6544.class_6546.method_38121((float)-1.0f, (float)0.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(2)) ? DefaultBiomes.getSecondaryCaveBiome(2) : class_1972.field_29218);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.9f), this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.0f, (float)1.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(7)) ? DefaultBiomes.getSecondaryCaveBiome(7) : class_1972.field_28107);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.94f, (float)1.0f), this.FULL_RANGE, class_6544.class_6546.method_38121((float)-1.0f, (float)0.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(6)) ? DefaultBiomes.getSecondaryCaveBiome(6) : class_1972.field_28107);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.9f, (float)1.0f), this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.0f, (float)1.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(7)) ? DefaultBiomes.getSecondaryCaveBiome(7) : class_1972.field_28107);
        this.addUndergroundBiome(builder, this.FULL_RANGE, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.8f), this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38121((float)-1.0f, (float)0.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(1)) ? DefaultBiomes.getSecondaryCaveBiome(1) : class_1972.field_29218);
        this.addUndergroundBiome(builder, this.FULL_RANGE, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.8f), this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.0f, (float)1.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(5)) ? DefaultBiomes.getSecondaryCaveBiome(5) : class_1972.field_29218);
        this.addUndergroundBiome(builder, this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38121((float)-1.0f, (float)0.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(4)) ? DefaultBiomes.getSecondaryCaveBiome(4) : class_1972.field_29218);
        this.addUndergroundBiome(builder, this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.0f, (float)1.0f), 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(5)) ? DefaultBiomes.getSecondaryCaveBiome(5) : class_1972.field_29218);
        this.addBottomBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(3)) ? DefaultBiomes.getSecondaryCaveBiome(3) : class_1972.field_37543);
        this.addBottomBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[3]), this.FULL_RANGE, 0.0f, DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryCaveBiome(8)) ? DefaultBiomes.getSecondaryCaveBiome(8) : class_1972.field_37543);
    }

    public class_5321<class_1959> pickMiddleBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (weirdness.comp_104() < 0L) {
            if (DefaultBiomes.isBiomeEnabled(this.MIDDLE_BIOMES[temperature][humidity])) {
                return this.MIDDLE_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_MIDDLE_BIOMES[temperature][humidity];
        }
        if (this.MIDDLE_BIOMES_VARIANT[temperature][humidity] == null) {
            if (DefaultBiomes.isBiomeEnabled(this.MIDDLE_BIOMES[temperature][humidity])) {
                return this.MIDDLE_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_MIDDLE_BIOMES[temperature][humidity];
        }
        if (DefaultBiomes.isBiomeEnabled(this.MIDDLE_BIOMES_VARIANT[temperature][humidity])) {
            return this.MIDDLE_BIOMES_VARIANT[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_MIDDLE_BIOMES_VARIANT[temperature][humidity];
    }

    public class_5321<class_1959> pickMiddleBiomeOrSlopeIfCold(int temperature, int humidity, class_6544.class_6546 weirdness) {
        return temperature == 0 ? this.pickSlopeBiome(temperature, humidity, weirdness) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    public class_5321<class_1959> maybePickToweringCliffsBiome(int temperature, int humidity, class_6544.class_6546 weirdness, class_5321<class_1959> fallbackBiome) {
        class_5321 resourceKey = DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryShatteredCliffBiome()) ? DefaultBiomes.getSecondaryShatteredCliffBiome() : class_1972.field_35114;
        return temperature > 1 && humidity < 4 && weirdness.comp_104() >= 0L ? resourceKey : fallbackBiome;
    }

    public class_5321<class_1959> pickShatteredCoastBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        class_5321<class_1959> resourceKey = weirdness.comp_104() >= 0L ? this.pickMiddleBiome(temperature, humidity, weirdness) : this.pickBeachBiome(temperature);
        return this.maybePickToweringCliffsBiome(temperature, humidity, weirdness, resourceKey);
    }

    public class_5321<class_1959> pickBeachBiome(int temperature) {
        if (temperature == 0) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryBeachBiome(temperature)) ? DefaultBiomes.getSecondaryBeachBiome(temperature) : class_1972.field_9478;
        }
        if (temperature == 1) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryBeachBiome(temperature)) ? DefaultBiomes.getSecondaryBeachBiome(temperature) : class_1972.field_9434;
        }
        if (temperature == 2) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryBeachBiome(temperature)) ? DefaultBiomes.getSecondaryBeachBiome(temperature) : class_1972.field_9434;
        }
        if (temperature == 3) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryBeachBiome(temperature)) ? DefaultBiomes.getSecondaryBeachBiome(temperature) : class_1972.field_9434;
        }
        return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryBeachBiome(temperature)) ? DefaultBiomes.getSecondaryBeachBiome(temperature) : class_1972.field_9434;
    }

    public class_5321<class_1959> pickPlateauBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (weirdness.comp_104() < 0L) {
            if (DefaultBiomes.isBiomeEnabled(this.PLATEAU_BIOMES[temperature][humidity])) {
                return this.PLATEAU_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_PLATEAU_BIOMES[temperature][humidity];
        }
        if (this.PLATEAU_BIOMES_VARIANT[temperature][humidity] == null) {
            if (DefaultBiomes.isBiomeEnabled(this.PLATEAU_BIOMES[temperature][humidity])) {
                return this.PLATEAU_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_PLATEAU_BIOMES[temperature][humidity];
        }
        if (DefaultBiomes.isBiomeEnabled(this.PLATEAU_BIOMES_VARIANT[temperature][humidity])) {
            return this.PLATEAU_BIOMES_VARIANT[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_PLATEAU_BIOMES_VARIANT[temperature][humidity];
    }

    public class_5321<class_1959> pickPeakBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (temperature == 0) {
            if (weirdness.comp_104() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiome(temperature)) ? DefaultBiomes.getSecondaryPeakBiome(temperature) : class_1972.field_34474;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getSecondaryPeakBiomeVariant(temperature) : class_1972.field_35115;
        }
        if (temperature == 1) {
            if (weirdness.comp_104() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiome(temperature)) ? DefaultBiomes.getSecondaryPeakBiome(temperature) : class_1972.field_34474;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getSecondaryPeakBiomeVariant(temperature) : class_1972.field_35115;
        }
        if (temperature == 2) {
            if (weirdness.comp_104() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiome(temperature)) ? DefaultBiomes.getSecondaryPeakBiome(temperature) : class_1972.field_34474;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getSecondaryPeakBiomeVariant(temperature) : class_1972.field_35115;
        }
        if (temperature == 3) {
            if (weirdness.comp_104() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiome(temperature)) ? DefaultBiomes.getSecondaryPeakBiome(temperature) : class_1972.field_34475;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getSecondaryPeakBiomeVariant(temperature) : class_1972.field_34475;
        }
        if (weirdness.comp_104() < 0L) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiome(temperature)) ? DefaultBiomes.getSecondaryPeakBiome(temperature) : class_1972.field_9415;
        }
        return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondaryPeakBiomeVariant(temperature)) ? DefaultBiomes.getSecondaryPeakBiomeVariant(temperature) : class_1972.field_35110;
    }

    public class_5321<class_1959> pickSlopeBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (temperature == 0) {
            if (weirdness.comp_104() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiome(temperature)) ? DefaultBiomes.getSecondarySlopeBiome(temperature) : class_1972.field_34472;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getSecondarySlopeBiomeVariant(temperature) : class_1972.field_34471;
        }
        if (temperature == 1) {
            if (weirdness.comp_104() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiome(temperature)) ? DefaultBiomes.getSecondarySlopeBiome(temperature) : class_1972.field_34471;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getSecondarySlopeBiomeVariant(temperature) : class_1972.field_34472;
        }
        if (temperature == 2) {
            if (weirdness.comp_104() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiome(temperature)) ? DefaultBiomes.getSecondarySlopeBiome(temperature) : class_1972.field_34471;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getSecondarySlopeBiomeVariant(temperature) : class_1972.field_34472;
        }
        if (temperature == 3) {
            if (weirdness.comp_104() < 0L) {
                return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiome(temperature)) ? DefaultBiomes.getSecondarySlopeBiome(temperature) : class_1972.field_34475;
            }
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getSecondarySlopeBiomeVariant(temperature) : class_1972.field_34475;
        }
        if (weirdness.comp_104() < 0L) {
            return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiome(temperature)) ? DefaultBiomes.getSecondarySlopeBiome(temperature) : class_1972.field_9449;
        }
        return DefaultBiomes.isBiomeEnabled(DefaultBiomes.getSecondarySlopeBiomeVariant(temperature)) ? DefaultBiomes.getSecondarySlopeBiomeVariant(temperature) : class_1972.field_9449;
    }

    public class_5321<class_1959> pickShatteredBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        class_5321<class_1959> resourceKey = DefaultBiomes.isBiomeEnabled(this.SHATTERED_BIOMES[temperature][humidity]) ? this.SHATTERED_BIOMES[temperature][humidity] : VanillaFallbackBiome.VANILLA_SHATTERED_BIOMES[temperature][humidity];
        return resourceKey == null ? this.pickMiddleBiome(temperature, humidity, weirdness) : resourceKey;
    }

    public class_5321<class_1959> pickRiverBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (weirdness.comp_104() < 0L) {
            if (DefaultBiomes.isBiomeEnabled(this.RIVER_BIOMES[temperature][humidity])) {
                return this.RIVER_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_RIVER_BIOMES[temperature][humidity];
        }
        if (this.RIVER_BIOMES_VARIANT[temperature][humidity] == null) {
            if (DefaultBiomes.isBiomeEnabled(this.RIVER_BIOMES[temperature][humidity])) {
                return this.RIVER_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_RIVER_BIOMES[temperature][humidity];
        }
        if (DefaultBiomes.isBiomeEnabled(this.RIVER_BIOMES_VARIANT[temperature][humidity])) {
            return this.RIVER_BIOMES_VARIANT[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_RIVER_BIOMES_VARIANT[temperature][humidity];
    }

    public class_5321<class_1959> pickSwampBiome(int temperature, int humidity) {
        if (DefaultBiomes.isBiomeEnabled(this.SWAMP_BIOMES[temperature][humidity])) {
            return this.SWAMP_BIOMES[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_SWAMP_BIOMES[temperature][humidity];
    }

    public void addSurfaceBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
        builder.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
        builder.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
    }

    public void addUndergroundBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
        builder.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.24f, (float)0.9f), (class_6544.class_6546)weirdness, (float)offset), biome));
    }

    public void addBottomBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> builder, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
        builder.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.1f), (class_6544.class_6546)weirdness, (float)offset), biome));
    }
}

