/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.corgitaco.dataanchor.data.TickableTrackedData;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.level.SyncedLevelTrackedData;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEventProbabilities;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import dev.corgitaco.enhancedcelestials.lunarevent.LunarEventInstance;
import dev.corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class EnhancedCelestialsLunarForecastWorldData
extends SyncedLevelTrackedData
implements TickableTrackedData {
    protected final List<LunarEventInstance> forecast = new ArrayList<LunarEventInstance>();
    protected final List<LunarEventInstance> pastEvents = new ArrayList<LunarEventInstance>();
    private long lastCheckedDay = -1L;
    private boolean shouldSync = false;
    protected final transient class_6880<LunarDimensionSettings> dimensionSettingsHolder;
    protected final transient Map<class_6880<LunarEvent>, LunarEvent.SpawnRequirements> lunarEventSpawnRequirements;
    private transient class_6880<LunarEvent> lastTickEvent;
    private transient class_6880<LunarEvent> lastStoredEvent;
    protected transient float blend = 1.0f;

    public EnhancedCelestialsLunarForecastWorldData(TrackedDataKey<EnhancedCelestialsLunarForecastWorldData> key, class_1937 level, class_6880<LunarDimensionSettings> lunarDimensionSettingsHolder, Map<class_6880<LunarEvent>, LunarEvent.SpawnRequirements> lunarEventSpawnRequirementsMap) {
        super(key, level);
        this.dimensionSettingsHolder = lunarDimensionSettingsHolder;
        this.lunarEventSpawnRequirements = lunarEventSpawnRequirementsMap;
        this.lastTickEvent = this.currentLunarEventHolder();
        this.lastStoredEvent = this.currentLunarEventHolder();
        String lunarEventNames = Arrays.toString(this.lunarEventSpawnRequirements.keySet().stream().map(class_6880::method_40230).map(Optional::orElseThrow).map(class_5321::method_29177).map(class_2960::toString).toArray());
        String dimension = level.method_27983().method_29177().toString();
        EnhancedCelestials.LOGGER.info("Possible lunar events for dimension \"%s\" are %s.".formatted(dimension, lunarEventNames));
    }

    @Nullable
    public class_2487 save() {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10566("forecast", (class_2520)LunarEventInstance.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.forecast).getOrThrow());
        compoundTag.method_10566("pastEvents", (class_2520)LunarEventInstance.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.pastEvents).getOrThrow());
        compoundTag.method_10544("lastCheckedDay", this.lastCheckedDay);
        return compoundTag;
    }

    public void load(class_2487 tag) {
        this.forecast.clear();
        this.forecast.addAll((Collection)((Pair)LunarEventInstance.LIST_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("forecast")).getOrThrow()).getFirst());
        this.pastEvents.clear();
        this.pastEvents.addAll((Collection)((Pair)LunarEventInstance.LIST_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("pastEvents")).getOrThrow()).getFirst());
        this.lastCheckedDay = tag.method_10537("lastCheckedDay");
    }

    public void readFromNetwork(class_2487 tag) {
        super.readFromNetwork(tag);
        if (this.lastTickEvent != this.currentLunarEventHolder()) {
            this.eventSwitched(this.lastLunarEventHolder(), this.currentLunarEventHolder());
        }
    }

    public void tick() {
        if (!this.level.field_9236) {
            this.serverTick();
        } else {
            this.baseTick();
        }
    }

    private void serverTick() {
        this.removeFromForecastIf(lunarEventInstance -> {
            if (lunarEventInstance.passed(this.getCurrentDay())) {
                this.pastEvents.add(0, (LunarEventInstance)lunarEventInstance);
                return true;
            }
            return lunarEventInstance.scheduledDay() > this.getCurrentDay() + ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).yearLengthInDays();
        });
        this.removeFromPastEventsIf(lunarEventInstance -> lunarEventInstance.scheduledDay() > this.getCurrentDay() || lunarEventInstance.scheduledDay() < this.getCurrentDay() - ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).yearLengthInDays());
        this.baseTick();
        this.createOrUpdateForecast(this.lastCheckedDay);
        this.checkEmptyForecastOrThrow();
        if (this.shouldSync) {
            super.sync();
            this.shouldSync = false;
        }
    }

    private void checkEmptyForecastOrThrow() {
        if (this.forecast.isEmpty() && ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).yearLengthInDays() > ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).maxDaysBetweenEvents()) {
            throw new IllegalStateException("Forecast cannot be empty.... this should be impossible.... crashing game..... Report this to the Enhanced Celestials Github immediately, please provide your current world instance + other mods.");
        }
    }

    private void baseTick() {
        if (this.blend < 1.0f) {
            this.blend += 0.01f;
        }
        if (this.currentLunarEventHolder() != this.lastTickEvent) {
            this.eventSwitched(this.lastTickEvent, this.currentLunarEventHolder());
        }
        this.lastTickEvent = this.level.method_23886() ? (this.level.method_8419() && ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).requiresClearSkies() ? this.defaultLunarEvent() : this.currentLunarEventHolder()) : this.defaultLunarEvent();
    }

    public void recomputeForecast() {
        this.checkServer();
        this.clearForecast();
        this.createOrUpdateForecast(this.getCurrentDay());
    }

    private void clearForecast() {
        this.forecast.clear();
        this.markChanged();
    }

    public boolean switchingEvents() {
        return this.blend < 1.0f;
    }

    public void eventSwitched(class_6880<LunarEvent> lastEvent, class_6880<LunarEvent> nextEvent) {
        this.blend = 0.0f;
        this.lastStoredEvent = lastEvent;
        if (!this.level.field_9236) {
            this.serverEventSwitched(lastEvent, nextEvent);
        }
    }

    public void setLunarEvent(class_5321<LunarEvent> lunarEvent) {
        LunarEventInstance first;
        this.checkServer();
        if (!this.level.method_23886()) {
            ((class_3218)this.level).method_29199(this.getCurrentDay() * ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).dayLength() + 13000L);
        }
        if ((first = this.forecast.get(0)).active(this.getCurrentDay())) {
            this.removeEventInForecast(0);
        }
        if (lunarEvent != ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).defaultEvent()) {
            this.addEventToForecast(0, new LunarEventInstance(lunarEvent, this.getCurrentDay(), true));
        }
    }

    private void serverEventSwitched(class_6880<LunarEvent> lastEvent, class_6880<LunarEvent> nextEvent) {
        this.checkServer();
        for (class_1657 player : this.level.method_18456()) {
            ((LunarEvent)lastEvent.comp_349()).getTextComponents().setNotification().ifPresent(notification -> {
                if (notification.notificationType() != LunarTextComponents.NotificationType.NONE) {
                    player.method_7353(notification.customTranslationTextComponent().getComponent(), notification.notificationType() == LunarTextComponents.NotificationType.HOT_BAR);
                }
            });
            ((LunarEvent)nextEvent.comp_349()).getTextComponents().riseNotification().ifPresent(notification -> {
                if (notification.notificationType() != LunarTextComponents.NotificationType.NONE) {
                    player.method_7353(notification.customTranslationTextComponent().getComponent(), notification.notificationType() == LunarTextComponents.NotificationType.HOT_BAR);
                }
            });
        }
    }

    public LunarEvent lastLunarEvent() {
        return (LunarEvent)this.lastLunarEventHolder().comp_349();
    }

    public class_6880<LunarEvent> lastLunarEventHolder() {
        return this.lastStoredEvent;
    }

    public LunarEvent currentLunarEvent() {
        return (LunarEvent)this.currentLunarEventHolder().comp_349();
    }

    public class_6880<LunarEvent> currentLunarEventHolder() {
        if (this.level.method_8530()) {
            return this.defaultLunarEvent();
        }
        if (((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).requiresClearSkies() && this.level.method_8419()) {
            return this.defaultLunarEvent();
        }
        class_6880.class_6883<LunarEvent> defaultEvent = this.defaultLunarEvent();
        if (this.forecast.isEmpty()) {
            return defaultEvent;
        }
        LunarEventInstance first = this.forecast.get(0);
        if (first.active(this.getCurrentDay())) {
            return this.lunarEventHolder(first.getLunarEventKey());
        }
        return defaultEvent;
    }

    public class_6880<LunarEvent> nextScheduledLunarEvent() {
        if (this.forecast.isEmpty()) {
            return this.defaultLunarEvent();
        }
        LunarEventInstance first = this.forecast.get(0);
        if (first.active(this.getCurrentDay())) {
            LunarEventInstance second = this.forecast.get(1);
            return this.lunarEventHolder(second.getLunarEventKey());
        }
        return this.lunarEventHolder(first.getLunarEventKey());
    }

    public class_6880<LunarEvent> lastScheduledLunarEvent() {
        class_6880.class_6883<LunarEvent> defaultEvent = this.defaultLunarEvent();
        if (this.pastEvents.isEmpty()) {
            return defaultEvent;
        }
        LunarEventInstance first = this.pastEvents.get(0);
        if (first.active(this.getCurrentDay())) {
            return this.lunarEventHolder(first.getLunarEventKey());
        }
        return defaultEvent;
    }

    public class_6880<LunarEvent> getLunarEventForDay(long day) {
        for (LunarEventInstance lunarEventInstance : this.forecast) {
            if (!lunarEventInstance.active(day)) continue;
            return this.lunarEventHolder(lunarEventInstance.getLunarEventKey());
        }
        for (LunarEventInstance lunarEventInstance : this.pastEvents) {
            if (!lunarEventInstance.active(day)) continue;
            return this.lunarEventHolder(lunarEventInstance.getLunarEventKey());
        }
        return this.defaultLunarEvent();
    }

    public class_2561 getForecastComponent() {
        class_5250 textComponent = null;
        for (int i = Math.min(100, this.forecast.size() - 1); i >= 0; --i) {
            LunarEventInstance lunarEventInstance = this.forecast.get(i);
            class_6880.class_6883<LunarEvent> event = this.lunarEventHolder(lunarEventInstance.getLunarEventKey());
            CustomTranslationTextComponent name = ((LunarEvent)event.comp_349()).getTextComponents().name();
            class_5251 color = name.getStyle().method_10973();
            if (textComponent == null) {
                textComponent = class_2561.method_43471((String)name.getKey()).method_27696(class_2583.field_24360.method_27703(color));
            } else {
                textComponent.method_10852((class_2561)class_2561.method_43470((String)", ").method_27696(class_2583.field_24360.method_10977(class_124.field_1068))).method_10852((class_2561)class_2561.method_43471((String)name.getKey()).method_27696(class_2583.field_24360.method_27703(color)));
            }
            textComponent.method_10852((class_2561)class_2561.method_43469((String)"enhancedcelestials.lunarforecast.days_left", (Object[])new Object[]{lunarEventInstance.getDaysUntil(this.getCurrentDay())}).method_27696(class_2583.field_24360.method_27703(color)));
        }
        if (textComponent != null) {
            return class_2561.method_43469((String)"enhancedcelestials.lunarforecast.header", (Object[])new Object[]{textComponent.method_10852((class_2561)class_2561.method_43470((String)".").method_27696(class_2583.field_24360.method_10977(class_124.field_1068)))});
        }
        return class_2561.method_43469((String)"enhancedcelestials.lunarforecast.empty", (Object[])new Object[]{textComponent}).method_27692(class_124.field_1054);
    }

    private class_6880.class_6883<LunarEvent> defaultLunarEvent() {
        return this.lunarEventHolder(((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).defaultEvent());
    }

    private class_6880.class_6883<LunarEvent> lunarEventHolder(class_5321<LunarEvent> lunarEventKey) {
        return ((class_2378)this.level.method_30349().method_33310(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow()).method_40290(lunarEventKey);
    }

    public Object2LongArrayMap<class_5321<LunarEvent>> eventsByDay() {
        Object2LongArrayMap eventByLastTime = new Object2LongArrayMap();
        for (LunarEventInstance lunarEventInstance : this.pastEvents) {
            eventByLastTime.put(lunarEventInstance.getLunarEventKey(), lunarEventInstance.scheduledDay());
        }
        for (LunarEventInstance lunarEventInstance : this.forecast) {
            eventByLastTime.put(lunarEventInstance.getLunarEventKey(), lunarEventInstance.scheduledDay());
        }
        return eventByLastTime;
    }

    public long lastScheduledEventDay() {
        long lastScheduledEventDay = -1L;
        for (LunarEventInstance lunarEventInstance : this.forecast) {
            lastScheduledEventDay = Math.max(lunarEventInstance.scheduledDay(), lastScheduledEventDay);
        }
        for (LunarEventInstance lunarEventInstance : this.pastEvents) {
            lastScheduledEventDay = Math.max(lunarEventInstance.scheduledDay(), lastScheduledEventDay);
        }
        return lastScheduledEventDay;
    }

    public long getCurrentDay() {
        return this.getDayFromDayTime(this.level.method_8532());
    }

    public long getDayFromDayTime(long dayTime) {
        return dayTime / ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).dayLength();
    }

    public long getDayTimeFromDay(long day) {
        return day * ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).dayLength();
    }

    public float getBlend() {
        return this.blend;
    }

    private void createOrUpdateForecast(long lastCheckedDay) {
        long dayDifference;
        long yearLengthInDays = ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).yearLengthInDays();
        if (this.getCurrentDay() < lastCheckedDay - yearLengthInDays) {
            lastCheckedDay = this.getCurrentDay();
            this.setLastCheckedDay(lastCheckedDay);
        }
        if ((dayDifference = EnhancedCelestialsLunarForecastWorldData.clamp(lastCheckedDay - this.getCurrentDay(), 0L, yearLengthInDays)) < yearLengthInDays) {
            Object2LongArrayMap<class_5321<LunarEvent>> eventsByDay = this.eventsByDay();
            long lastScheduledEventDay = this.lastScheduledEventDay();
            long yearDayDifference = yearLengthInDays - dayDifference;
            int dayOffset = 0;
            while ((long)dayOffset <= yearDayDifference) {
                long day = this.getCurrentDay() + dayDifference + (long)dayOffset;
                long seed = day + ((class_3218)this.level).method_8412() + (long)this.level.method_27983().hashCode();
                Random random = new Random(seed);
                ArrayList<class_6880<LunarEvent>> scrambledLunarEvents = new ArrayList<class_6880<LunarEvent>>(this.lunarEventSpawnRequirements.keySet());
                Collections.shuffle(scrambledLunarEvents, random);
                for (class_6880 class_68802 : scrambledLunarEvents) {
                    boolean override;
                    LunarEvent.SpawnRequirements spawnRequirements = this.lunarEventSpawnRequirements.get(class_68802);
                    boolean pastMinNumberOfNightsBetweenThisTypeOfEvent = day - eventsByDay.getOrDefault(class_68802.method_40230().orElseThrow(), this.getCurrentDay()) > (long)spawnRequirements.minNumberOfNights();
                    boolean pastMinNumberOfNightsBetweenAllEvents = day - lastScheduledEventDay > ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).minDaysBetweenEvents();
                    boolean isValidMoonPhase = spawnRequirements.validMoonPhases().contains(this.level.method_8597().method_28531(this.getDayTimeFromDay(day)));
                    boolean chance = spawnRequirements.chance() >= random.nextDouble();
                    boolean checksPass = pastMinNumberOfNightsBetweenThisTypeOfEvent && pastMinNumberOfNightsBetweenAllEvents && isValidMoonPhase && chance;
                    boolean bl = override = !checksPass && lastScheduledEventDay != -1L && day - lastScheduledEventDay >= ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).maxDaysBetweenEvents();
                    if (!checksPass && !override) continue;
                    lastScheduledEventDay = day;
                    LunarEventInstance newLunarEventInstance = new LunarEventInstance((class_5321<LunarEvent>)((class_5321)class_68802.method_40230().orElseThrow()), day);
                    eventsByDay.put(newLunarEventInstance.getLunarEventKey(), day);
                    this.forecast.add(newLunarEventInstance);
                }
                ++dayOffset;
            }
            this.setLastCheckedDay(this.getCurrentDay() + yearLengthInDays);
        }
    }

    public void setLastCheckedDay(long lastCheckedDay) {
        this.lastCheckedDay = lastCheckedDay;
        this.markChanged();
    }

    public void addEventToForecast(LunarEventInstance event) {
        this.forecast.add(event);
        this.markChanged();
    }

    public void addEventToForecast(int idx, LunarEventInstance event) {
        this.forecast.add(idx, event);
        this.markChanged();
    }

    public void removeEventInForecast(LunarEventInstance event) {
        this.forecast.remove(event);
        this.markChanged();
    }

    public void removeEventInForecast(int index) {
        this.forecast.remove(index);
        this.markChanged();
    }

    public void removeFromForecastIf(Predicate<LunarEventInstance> filter) {
        this.forecast.removeIf(lunarEventInstance -> {
            if (filter.test((LunarEventInstance)lunarEventInstance)) {
                this.markChanged();
                return true;
            }
            return false;
        });
    }

    public void removeFromPastEventsIf(Predicate<LunarEventInstance> filter) {
        this.pastEvents.removeIf(lunarEventInstance -> {
            if (filter.test((LunarEventInstance)lunarEventInstance)) {
                this.markChanged();
                return true;
            }
            return false;
        });
    }

    private void markChanged() {
        this.sync();
        this.markDirty();
    }

    public void sync() {
        if (!this.level.field_9236) {
            this.shouldSync = true;
        }
    }

    private void checkServer() {
        if (this.level.field_9236) {
            throw new IllegalStateException("MUST BE CALLED FROM SERVER SIDE ONLY!");
        }
    }

    public List<LunarEventInstance> getForecast() {
        return this.forecast;
    }

    public LunarDimensionSettings getDimensionSettings() {
        return (LunarDimensionSettings)this.dimensionSettingsHolder.comp_349();
    }

    public class_6880<LunarDimensionSettings> getDimensionSettingsHolder() {
        return this.dimensionSettingsHolder;
    }

    public static long clamp(long value, long min, long max) {
        return value < min ? min : Math.min(value, max);
    }

    @Nullable
    public static EnhancedCelestialsLunarForecastWorldData factory(TrackedDataKey<EnhancedCelestialsLunarForecastWorldData> key, class_1937 level) {
        class_5321 dimension = level.method_27983();
        class_2960 location = dimension.method_29177();
        class_2378 lunarDimensionSettingsRegistry = level.method_30349().method_30530(EnhancedCelestialsRegistry.LUNAR_DIMENSION_SETTINGS_KEY);
        Optional possibleLunarDimensionSettings = lunarDimensionSettingsRegistry.method_40264(class_5321.method_29179(EnhancedCelestialsRegistry.LUNAR_DIMENSION_SETTINGS_KEY, (class_2960)location));
        if (possibleLunarDimensionSettings.isEmpty()) {
            return null;
        }
        class_6880.class_6883 dimensionSettingsHolder = (class_6880.class_6883)possibleLunarDimensionSettings.orElseThrow();
        class_2378 lunarEvents = (class_2378)level.method_30349().method_33310(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow();
        Object2ObjectOpenHashMap<class_6880<LunarEvent>, LunarEvent.SpawnRequirements> lunarEventSpawnRequirements = EnhancedCelestialsLunarForecastWorldData.createLunarEventSpawnRequirements((class_5321<class_1937>)dimension, (class_2378<LunarEventProbabilities>)level.method_30349().method_30530(EnhancedCelestialsRegistry.LUNAR_EVENT_PROBABILITIES_KEY), (class_2378<LunarEvent>)lunarEvents, (class_6880.class_6883<LunarDimensionSettings>)dimensionSettingsHolder);
        return lunarEventSpawnRequirements.isEmpty() ? null : new EnhancedCelestialsLunarForecastWorldData(key, level, (class_6880<LunarDimensionSettings>)dimensionSettingsHolder, (Map<class_6880<LunarEvent>, LunarEvent.SpawnRequirements>)lunarEventSpawnRequirements);
    }

    private static Object2ObjectOpenHashMap<class_6880<LunarEvent>, LunarEvent.SpawnRequirements> createLunarEventSpawnRequirements(class_5321<class_1937> dimension, class_2378<LunarEventProbabilities> lunarEventProbabilitiesRegistry, class_2378<LunarEvent> lunarEvents, class_6880.class_6883<LunarDimensionSettings> dimensionSettingsHolder) {
        Object2ObjectOpenHashMap lunarEventSpawnRequirements = new Object2ObjectOpenHashMap();
        for (Map.Entry resourceKeyLunarEventEntry : lunarEvents.method_29722()) {
            LunarEvent.SpawnRequirements spawnRequirements;
            class_6880.class_6883 lunarEventHolder = lunarEvents.method_40290((class_5321)resourceKeyLunarEventEntry.getKey());
            class_5321 levelResourceKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)((class_5321)dimensionSettingsHolder.method_40230().orElseThrow()).method_29177());
            Map<class_5321<class_1937>, LunarEvent.SpawnRequirements> eventChancesByDimension = ((LunarEvent)lunarEventHolder.comp_349()).getEventChancesByDimension();
            if (!eventChancesByDimension.containsKey(levelResourceKey) || !((spawnRequirements = eventChancesByDimension.get(levelResourceKey)).chance() > 0.0) || spawnRequirements.validMoonPhases().isEmpty() || spawnRequirements.minNumberOfNights() < 0) continue;
            lunarEventSpawnRequirements.put((Object)lunarEventHolder, (Object)spawnRequirements);
        }
        EnhancedCelestialsLunarForecastWorldData.insertOverrides(lunarEventProbabilitiesRegistry, dimension, (Object2ObjectOpenHashMap<class_6880<LunarEvent>, LunarEvent.SpawnRequirements>)lunarEventSpawnRequirements, lunarEvents);
        return lunarEventSpawnRequirements;
    }

    private static void insertOverrides(class_2378<LunarEventProbabilities> lunarEventProbabilitiesRegistry, class_5321<class_1937> dimension, Object2ObjectOpenHashMap<class_6880<LunarEvent>, LunarEvent.SpawnRequirements> lunarEventSpawnRequirements, class_2378<LunarEvent> lunarEvents) {
        Object2ObjectRBTreeMap loggerData = new Object2ObjectRBTreeMap(Comparator.comparing(class_5321::method_29177));
        lunarEventProbabilitiesRegistry.method_29722().stream().sorted(Comparator.comparingInt(value -> ((LunarEventProbabilities)value.getValue()).priority())).forEachOrdered(lunarEventProbabilitiesEntry -> {
            class_5321 lunarEventProbabilitiesKey = (class_5321)lunarEventProbabilitiesEntry.getKey();
            LunarEventProbabilities lunarEventProbabilitiesEntryValue = (LunarEventProbabilities)lunarEventProbabilitiesEntry.getValue();
            Map<class_5321<LunarEvent>, Map<class_5321<class_1937>, LunarEvent.SpawnRequirements>> lunarEventProbabilitiesByDimension = lunarEventProbabilitiesEntryValue.probabilitiesByEvent();
            lunarEventProbabilitiesByDimension.forEach((lunarEventResourceKey, value) -> {
                LunarEvent.SpawnRequirements spawnRequirementsOverride = (LunarEvent.SpawnRequirements)value.get(dimension);
                if (spawnRequirementsOverride != null) {
                    if (!loggerData.containsKey(lunarEventResourceKey)) {
                        String s = "set";
                        if (lunarEventSpawnRequirements.containsKey((Object)lunarEvents.method_40290(lunarEventResourceKey))) {
                            s = "replaced";
                        }
                        loggerData.put(lunarEventResourceKey, (Object)new StringBuilder("[%s]: Lunar Event probability for \"%s\" was %s by highest priority lunar event probability \"%s\" with priority %d.".formatted(dimension.method_29177().toString(), lunarEventResourceKey.method_29177().toString(), s, lunarEventProbabilitiesKey.method_29177().toString(), lunarEventProbabilitiesEntryValue.priority())));
                        lunarEventSpawnRequirements.put((Object)lunarEvents.method_40290(lunarEventResourceKey), (Object)spawnRequirementsOverride);
                    } else {
                        StringBuilder builder = (StringBuilder)loggerData.get(lunarEventResourceKey);
                        if (!builder.toString().contains("Ignored")) {
                            builder.append(" | Ignored the following lunar event probabilities to due having a lower priority: ");
                        }
                        if (builder.toString().contains("[Probability")) {
                            builder.append(", ");
                        }
                        builder.append("[Probability=%s,Priority%d]".formatted(lunarEventProbabilitiesKey.method_29177().toString(), lunarEventProbabilitiesEntryValue.priority()));
                    }
                }
            });
        });
        loggerData.values().forEach(stringBuilder -> EnhancedCelestials.LOGGER.info(stringBuilder.toString()));
    }
}

