/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.api.annotations.ConfigOption;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.Option;
import com.teamresourceful.resourcefulconfig.client.UIConstants;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable.DraggableList;
import com.teamresourceful.resourcefulconfig.client.components.options.types.DropdownWidget;
import com.teamresourceful.resourcefulconfig.client.screens.base.ModalOverlay;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class DraggableListOptionWidget
extends BaseWidget {
    private static final int WIDTH = 80;
    private static final int SIZE = 12;
    private static final int SPACING = 4;
    private static final int PADDING = 2;
    private final class_2561 title;
    private final Enum<?>[] options;
    private final Set<Enum<?>> duplicatables;
    private final Supplier<List<Enum<?>>> getter;
    private final Consumer<List<Enum<?>>> setter;
    private final ConfigOption.Range range;

    public DraggableListOptionWidget(class_2561 title, Enum<?>[] options, Set<Enum<?>> duplicatables, Supplier<List<Enum<?>>> getter, Consumer<List<Enum<?>>> setter, ConfigOption.Range range) {
        super(80, 16);
        this.title = title;
        this.options = options;
        this.duplicatables = duplicatables;
        this.getter = getter;
        this.setter = setter;
        this.range = range;
    }

    public static DraggableListOptionWidget of(ResourcefulConfigValueEntry entry, EntryData data) {
        return new DraggableListOptionWidget((class_2561)entry.options().title().toComponent(), (Enum[])entry.objectType().getEnumConstants(), Set.of(data.getOrDefaultOption(Option.DRAGGABLE, new Enum[0])), () -> Arrays.asList((Enum[])entry.getArray()), value -> {
            Object[] array = (Enum[])Array.newInstance(entry.objectType(), value.size());
            for (int i = 0; i < value.size(); ++i) {
                array[i] = (Enum)value.get(i);
            }
            entry.setArray(array);
        }, data.getOption(Option.RANGE));
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_52706(ModSprites.ofButton(this.method_49606()), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        int contentWidth = this.font.method_27525((class_5348)UIConstants.EDIT) + 4 + 12;
        graphics.method_52706(ModSprites.EDIT, this.method_46426() + (this.method_25368() - contentWidth) / 2, this.method_46427() + 2, 12, 12);
        int n = this.method_46426() + (this.method_25368() - contentWidth) / 2 + 12 + 4;
        int n2 = this.method_46427();
        int n3 = this.method_25364();
        Objects.requireNonNull(this.font);
        graphics.method_27535(this.font, UIConstants.EDIT, n, n2 + (n3 - 9) / 2 + 1, -329226);
    }

    public void method_25348(double mouseX, double mouseY) {
        new DraggableListOverlay(this).open();
    }

    private static class DraggableListOverlay
    extends ModalOverlay {
        private final DraggableListOptionWidget widget;

        protected DraggableListOverlay(DraggableListOptionWidget widget) {
            this.widget = widget;
            this.title = UIConstants.EDIT_LIST;
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            class_8667 layout = class_8667.method_52742();
            class_7842 title = (class_7842)layout.method_52736((class_8021)new class_7842(this.contentWidth - 84, 16, (class_2561)class_2561.method_43473(), this.field_22793).method_48596());
            Runnable updateTitle = () -> {
                if (this.widget.range != null) {
                    String count = "%d/%d".formatted(this.widget.getter.get().size(), (int)this.widget.range.max());
                    title.method_25355((class_2561)class_2561.method_43473().method_10852(this.widget.title).method_27693(" ").method_27693(count));
                } else {
                    title.method_25355(this.widget.title);
                }
            };
            updateTitle.run();
            LinkedHashSet options = new LinkedHashSet(Arrays.asList(this.widget.options));
            this.widget.getter.get().forEach(item -> {
                if (this.widget.duplicatables.contains(item)) {
                    return;
                }
                options.remove(item);
            });
            DropdownWidget dropdown = (DropdownWidget)layout.method_52736((class_8021)new DropdownWidget(options.toArray(new Enum[0]), () -> null, value -> {
                ArrayList<Enum> list = new ArrayList<Enum>((Collection)this.widget.getter.get());
                list.addFirst((Enum)value);
                this.widget.setter.accept(list);
            }).setTitle(UIConstants.ADD_ITEM));
            dropdown.field_22763 = this.widget.range == null || (double)this.widget.getter.get().size() < this.widget.range.max();
            layout.method_48229(this.left + 4, this.top + 1);
            layout.method_48222();
            layout.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            int heading = layout.method_25364() + 4;
            DraggableList list = (DraggableList)this.method_37063((class_364)new DraggableList(this.left + 1, this.top + heading, this.contentWidth - 2, this.contentHeight - heading));
            list.addAll(this.widget.getter.get());
            list.setOnUpdate(value -> {
                this.widget.setter.accept((List<Enum<?>>)value);
                list.setCanDelete(this.widget.range == null || (double)this.widget.getter.get().size() > this.widget.range.min());
                dropdown.field_22763 = this.widget.range == null || (double)this.widget.getter.get().size() < this.widget.range.max();
                updateTitle.run();
            });
            list.setCanDelete(this.widget.range == null || (double)this.widget.getter.get().size() > this.widget.range.min());
        }

        @Override
        public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super.method_25420(graphics, mouseX, mouseY, partialTicks);
            graphics.method_52706(ModSprites.BUTTON, this.left, this.top + 20, this.contentWidth, this.contentHeight - 20);
        }
    }
}

