/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.data.server;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure_catalog.data.ExposureInfo;
import io.github.mortuusars.exposure_catalog.data.server.CatalogCache;
import io.github.mortuusars.exposure_catalog.network.Packets;
import io.github.mortuusars.exposure_catalog.network.packet.Packet;
import io.github.mortuusars.exposure_catalog.network.packet.clientbound.SendExposureInfosS2CP;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_3222;
import org.slf4j.Logger;

public class Catalog {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CLEAR_TIME_ACTIVE_MINUTES = 30;
    private static final int CLEAR_TIME_INACTIVE_MINUTES = 0;
    private static final CatalogCache CACHE = new CatalogCache();
    private static final Set<class_3222> watchingPlayers = new HashSet<class_3222>();
    private static long clearTimestamp = Long.MAX_VALUE;

    public static CatalogCache getCache() {
        return CACHE;
    }

    public static void queryExposures(class_3222 player, boolean forceRebuild) {
        Runnable onFinished = () -> Catalog.sendToPlayer(player);
        if (forceRebuild) {
            CACHE.rebuild(onFinished);
        } else {
            CACHE.buildIfNeeded(onFinished);
        }
        Catalog.addWatchingPlayer(player);
    }

    public static void sendToPlayer(class_3222 player) {
        Catalog.send(packet -> Packets.sendToClient(packet, player));
    }

    public static void send(Consumer<Packet> sender) {
        List<ExposureInfo> exposures = CACHE.getExposures().values().stream().toList();
        sender.accept(new SendExposureInfosS2CP(exposures));
    }

    public static void onExposureSaved(String id, ExposureData data) {
        CACHE.addExposure(id, data);
    }

    public static boolean deleteExposure(String exposureId) {
        try {
            if (ExposureServer.exposureRepository().delete(exposureId)) {
                LOGGER.info("{} deleted.", (Object)exposureId);
                CACHE.removeExposure(exposureId);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Deleting exposure failed: ", (Throwable)e);
            return false;
        }
    }

    public static void addWatchingPlayer(class_3222 player) {
        watchingPlayers.add(player);
        Catalog.updateClearTime();
    }

    public static void removeWatchingPlayer(class_3222 player) {
        watchingPlayers.remove(player);
        Catalog.updateClearTime();
    }

    public static boolean shouldClear() {
        return clearTimestamp <= class_156.method_658();
    }

    public static void clear() {
        Catalog.getCache().clear();
        clearTimestamp = Long.MAX_VALUE;
        Catalog.send(Packets::sendToAllClients);
    }

    private static void updateClearTime() {
        clearTimestamp = class_156.method_658() + Duration.ofMinutes(watchingPlayers.isEmpty() ? 0L : 30L).toMillis();
    }
}

