/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.ohmymeteors.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_5134;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class SphereExplosion
extends class_1927 {
    protected static final class_5362 DEFAULT_BEHAVIOR = new class_5362();
    protected final boolean createFire;
    protected final class_1927.class_4179 destructionType;
    protected final class_5819 random = class_5819.method_43047();
    protected final class_1937 world;
    protected final double x;
    protected final double y;
    protected final double z;
    @Nullable
    protected final class_1297 entity;
    protected final float power;
    protected final class_1282 damageSource;
    protected final class_5362 behavior;
    protected final class_2394 particle;
    protected final class_2394 emitterParticle;
    protected final class_6880<class_3414> soundEvent;
    protected final ObjectArrayList<class_2338> affectedBlocks = new ObjectArrayList();
    protected final Map<class_1657, class_243> affectedPlayers = Maps.newHashMap();
    protected double thetaRef;
    protected double phiRef;
    private static final int MAX_POWER = 255;

    public SphereExplosion(class_1937 world, @Nullable class_1297 entity, double x, double y, double z, float power, List<class_2338> affectedBlocks, class_1927.class_4179 destructionType, class_2394 particle, class_2394 emitterParticle, class_6880<class_3414> soundEvent) {
        this(world, entity, SphereExplosion.method_55108((class_1937)world, (class_1297)entity), null, x, y, z, power, false, destructionType, particle, emitterParticle, soundEvent);
        this.affectedBlocks.addAll(affectedBlocks);
    }

    public SphereExplosion(class_1937 world, @Nullable class_1297 entity, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType, List<class_2338> affectedBlocks) {
        this(world, entity, x, y, z, power, createFire, destructionType);
        this.affectedBlocks.addAll(affectedBlocks);
    }

    public SphereExplosion(class_1937 world, @Nullable class_1297 entity, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType) {
        this(world, entity, SphereExplosion.method_55108((class_1937)world, (class_1297)entity), null, x, y, z, power, createFire, destructionType, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880<class_3414>)class_3417.field_15152);
    }

    public SphereExplosion(class_1937 world, @Nullable class_1297 entity, @Nullable class_1282 damageSource, @Nullable class_5362 behavior, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType, class_2394 particle, class_2394 emitterParticle, class_6880<class_3414> soundEvent) {
        super(world, entity, damageSource, behavior, x, y, z, power, createFire, destructionType, particle, emitterParticle, soundEvent);
        this.world = world;
        this.entity = entity;
        this.power = power;
        this.x = x;
        this.y = y;
        this.z = z;
        this.createFire = createFire;
        this.destructionType = destructionType;
        this.damageSource = damageSource == null ? world.method_48963().method_48807((class_1927)this) : damageSource;
        this.behavior = behavior == null ? this.chooseBehavior(entity) : behavior;
        this.particle = particle;
        this.emitterParticle = emitterParticle;
        this.soundEvent = soundEvent;
    }

    private class_5362 chooseBehavior(@Nullable class_1297 entity) {
        return entity == null ? DEFAULT_BEHAVIOR : new class_5361(entity);
    }

    public double calcDakaXdirection(int l) {
        double theta;
        double phi = Math.acos(1.0 - 2.0 * (double)l / (double)((int)Math.max(this.power * this.power, 255.0f)));
        this.thetaRef = theta = Math.PI * (1.0 + Math.sqrt(5.0)) * (double)l;
        this.phiRef = phi;
        return Math.sin(phi) * Math.cos(theta);
    }

    public void method_8348() {
        int k;
        this.world.method_43275(this.entity, (class_6880)class_5712.field_28178, new class_243(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 15; j < 16; ++j) {
            for (k = 15; k < 16; ++k) {
                block2: for (int l = 0; l < (int)Math.max(this.power * this.power, 255.0f); ++l) {
                    double d = this.calcDakaXdirection(l);
                    double e = Math.sin(this.phiRef) * Math.sin(this.thetaRef);
                    double f = Math.cos(this.phiRef);
                    double g = 1.0;
                    d /= g;
                    e /= g;
                    f /= g;
                    double m = this.x;
                    double n = this.y;
                    double o = this.z;
                    float p = 0.3f;
                    for (float h = this.power * (0.7f + this.world.field_9229.method_43057() * 0.6f); h > 0.0f; h -= 0.22500001f) {
                        class_2338 blockPos = class_2338.method_49637((double)m, (double)n, (double)o);
                        class_2680 blockState = this.world.method_8320(blockPos);
                        class_3610 fluidState = this.world.method_8316(blockPos);
                        if (!this.world.method_24794(blockPos)) continue block2;
                        Optional optional = this.behavior.method_29555((class_1927)this, (class_1922)this.world, blockPos, blockState, fluidState);
                        if (optional.isPresent()) {
                            h -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (h > 0.0f && this.behavior.method_29554((class_1927)this, (class_1922)this.world, blockPos, blockState, h)) {
                            set.add(blockPos);
                        }
                        m += d * (double)0.3f;
                        n += e * (double)0.3f;
                        o += f * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlocks.addAll((Collection)set);
        float q = this.power * 2.0f;
        k = class_3532.method_15357((double)(this.x - (double)q - 1.0));
        int lx = class_3532.method_15357((double)(this.x + (double)q + 1.0));
        int r = class_3532.method_15357((double)(this.y - (double)q - 1.0));
        int s = class_3532.method_15357((double)(this.y + (double)q + 1.0));
        int t = class_3532.method_15357((double)(this.z - (double)q - 1.0));
        int u = class_3532.method_15357((double)(this.z + (double)q + 1.0));
        List list = this.world.method_8335(this.entity, new class_238((double)k, (double)r, (double)t, (double)lx, (double)s, (double)u));
        class_243 vec3d = new class_243(this.x, this.y, this.z);
        for (class_1297 entity : list) {
            class_1657 playerEntity;
            double ab;
            double y;
            double x;
            double w;
            double z;
            double v;
            if (entity.method_5659((class_1927)this) || !((v = Math.sqrt(entity.method_5707(vec3d)) / (double)q) <= 1.0) || (z = Math.sqrt((w = entity.method_23317() - this.x) * w + (x = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.y) * x + (y = entity.method_23321() - this.z) * y)) == 0.0) continue;
            w /= z;
            x /= z;
            y /= z;
            if (this.behavior.method_55504((class_1927)this, entity)) {
                entity.method_5643(this.damageSource, this.behavior.method_55115((class_1927)this, entity));
            }
            double aa = (1.0 - v) * (double)SphereExplosion.method_17752((class_243)vec3d, (class_1297)entity) * (double)this.behavior.method_57007(entity);
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                ab = aa * (1.0 - livingEntity.method_45325(class_5134.field_51580));
            } else {
                ab = aa;
            }
            class_243 vec3d2 = new class_243(w *= ab, x *= ab, y *= ab);
            entity.method_18799(entity.method_18798().method_1019(vec3d2));
            if (!(!(entity instanceof class_1657) || (playerEntity = (class_1657)entity).method_7325() || playerEntity.method_7337() && playerEntity.method_31549().field_7479)) {
                this.affectedPlayers.put(playerEntity, vec3d2);
            }
            entity.method_56918(this.entity);
        }
    }

    public static void tryMergeStack(List<Pair<class_1799, class_2338>> stacks, class_1799 stack, class_2338 pos) {
        for (int i = 0; i < stacks.size(); ++i) {
            Pair<class_1799, class_2338> pair = stacks.get(i);
            class_1799 itemStack = (class_1799)pair.getFirst();
            if (!class_1542.method_24017((class_1799)itemStack, (class_1799)stack)) continue;
            stacks.set(i, (Pair<class_1799, class_2338>)Pair.of((Object)class_1542.method_24018((class_1799)itemStack, (class_1799)stack, (int)16), (Object)((class_2338)pair.getSecond())));
            if (!stack.method_7960()) continue;
            return;
        }
        stacks.add((Pair<class_1799, class_2338>)Pair.of((Object)stack, (Object)pos));
    }

    public void method_8350(boolean particles) {
        if (this.world.field_9236) {
            this.world.method_8486(this.x, this.y, this.z, (class_3414)this.soundEvent.comp_349(), class_3419.field_15245, 4.0f, (1.0f + (this.world.field_9229.method_43057() - this.world.field_9229.method_43057()) * 0.2f) * 0.7f, false);
        } else {
            this.world.method_8396(null, class_2338.method_49637((double)this.x, (double)this.y, (double)this.z), (class_3414)this.soundEvent.comp_349(), class_3419.field_15245, 4.0f, (1.0f + (this.world.field_9229.method_43057() - this.world.field_9229.method_43057()) * 0.2f) * 0.7f);
        }
        boolean bl = this.method_46667();
        if (particles) {
            class_2394 particleEffect = !(this.power < 2.0f) && bl ? this.emitterParticle : this.particle;
            this.world.method_8406(particleEffect, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        if (bl) {
            this.world.method_16107().method_15396("explosion_blocks");
            ArrayList list = new ArrayList();
            class_156.method_43028(this.affectedBlocks, (class_5819)this.world.field_9229);
            for (class_2338 blockPos : this.affectedBlocks) {
                this.world.method_8320(blockPos).method_55225(this.world, blockPos, (class_1927)this, (stack, pos) -> SphereExplosion.tryMergeStack(list, stack, pos));
            }
            for (Pair pair : list) {
                class_2248.method_9577((class_1937)this.world, (class_2338)((class_2338)pair.getSecond()), (class_1799)((class_1799)pair.getFirst()));
            }
            this.world.method_16107().method_15407();
        }
        if (this.createFire) {
            for (class_2338 blockPos2 : this.affectedBlocks) {
                if (this.random.method_43048(3) != 0 || !this.world.method_8320(blockPos2).method_26215() || !this.world.method_8320(blockPos2.method_10074()).method_26216((class_1922)this.world, blockPos2.method_10074())) continue;
                this.world.method_8501(blockPos2, class_4770.method_24416((class_1922)this.world, (class_2338)blockPos2));
            }
        }
    }
}

