/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.ohmymeteors.entities;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import me.emafire003.dev.ohmymeteors.OhMyMeteors;
import me.emafire003.dev.ohmymeteors.blocks.OMMBlocks;
import me.emafire003.dev.ohmymeteors.compat.flan.FlanCompat;
import me.emafire003.dev.ohmymeteors.compat.yawp.YawpCompat;
import me.emafire003.dev.ohmymeteors.config.Config;
import me.emafire003.dev.ohmymeteors.entities.OMMEntities;
import me.emafire003.dev.ohmymeteors.events.MeteorSpawnEvent;
import me.emafire003.dev.ohmymeteors.util.ExplosionUtils;
import me.emafire003.dev.structureplacerapi.StructurePlacerAPI;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1675;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5281;
import net.minecraft.class_5362;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class MeteorProjectileEntity
extends class_1668 {
    private static final class_2940<Integer> SIZE = class_2945.method_12791(MeteorProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_3230<class_2382> METEOR_CHUCK_TICKET = class_3230.method_20628((String)"meteor", class_2382::method_10265, (int)100);
    protected boolean isScatterMeteor = false;
    private int loadingChuckTicks = 0;
    private class_1923 currentlyLoadedChunk;
    private int chunksLoaded = 0;
    private boolean exploded = false;
    private int travelledBlocks = 0;
    private class_243 explosionPos = null;

    public MeteorProjectileEntity(class_1299<? extends class_1668> entityType, class_1937 world) {
        super(OMMEntities.METEOR_PROJECTILE_ENTITY, world);
        this.initialize();
    }

    public MeteorProjectileEntity(class_1937 world) {
        super(OMMEntities.METEOR_PROJECTILE_ENTITY, world);
        this.initialize();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SIZE, (Object)1);
    }

    @VisibleForTesting
    public void setSize(int size) {
        int i = class_3532.method_15340((int)size, (int)1, (int)50);
        this.field_6011.method_12778(SIZE, (Object)i);
        this.method_23311();
        this.method_18382();
    }

    public int getSize() {
        return (Integer)this.field_6011.method_12789(SIZE);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Size", this.getSize() - 1);
    }

    public void method_5749(class_2487 nbt) {
        this.setSize(nbt.method_10550("Size") + 1);
        super.method_5749(nbt);
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    public void method_5674(class_2940<?> data) {
        if (SIZE.equals(data)) {
            this.method_18382();
            this.method_36456(this.method_36454());
            if (this.method_5799() && this.field_5974.method_43048(20) == 0) {
                this.method_5746();
            }
        }
        super.method_5674(data);
    }

    public void initialize() {
        class_5819 random = this.method_59922();
        int i = random.method_43048(3);
        if (i < 2 && random.method_43057() < 0.5f) {
            ++i;
        }
        int j = 1 << i;
        this.setSize(j);
        ((MeteorSpawnEvent)MeteorSpawnEvent.EVENT.invoker()).meteorSpawned(this);
    }

    public final class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_18383((float)this.getSize());
    }

    public void loadChunk() {
        class_1937 class_19372;
        if (this.method_23318() > (double)(Config.METEOR_SPAWN_HEIGHT + 50)) {
            this.method_31472();
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (this.loadingChuckTicks > 0) {
                if (this.currentlyLoadedChunk == null || !this.currentlyLoadedChunk.equals((Object)this.method_31476())) {
                    world.method_14178().method_17297(METEOR_CHUCK_TICKET, this.method_31476(), 3, (Object)this.method_24515());
                    this.currentlyLoadedChunk = this.method_31476();
                    this.loadingChuckTicks = 200;
                    ++this.chunksLoaded;
                }
                if (this.chunksLoaded > 100) {
                    OhMyMeteors.LOGGER.warn("Discarded meteor projectile at " + String.valueOf(this.method_19538()) + " after having loaded too many chunks (" + this.chunksLoaded + ")");
                    this.method_31472();
                }
                ++this.loadingChuckTicks;
                return;
            }
            world.method_14178().method_17297(METEOR_CHUCK_TICKET, this.method_31476(), 2, (Object)this.method_24515());
            this.currentlyLoadedChunk = this.method_31476();
            this.loadingChuckTicks = 100;
        }
    }

    public void method_5773() {
        this.loadChunk();
        class_1297 entity = this.method_24921();
        if (this.method_37908().field_9236 || (entity == null || !entity.method_31481()) && this.method_37908().method_22340(this.method_24515())) {
            float h;
            class_239 hitResult;
            super.method_5773();
            if (this.method_7468()) {
                this.method_5639(1.0f);
            }
            if ((hitResult = class_1675.method_55054((class_1297)this, x$0 -> this.method_26958((class_1297)x$0), (class_3959.class_3960)this.method_55053())).method_17783() != class_239.class_240.field_1333) {
                this.method_59860(hitResult);
            }
            this.method_5852();
            class_243 vec3d = this.method_18798();
            double d = this.method_23317() + vec3d.field_1352;
            double e = this.method_23318() + vec3d.field_1351;
            double f = this.method_23321() + vec3d.field_1350;
            class_1675.method_7484((class_1297)this, (float)0.2f);
            if (this.method_5799()) {
                for (int i = 0; i < 4; ++i) {
                    float g = 0.25f;
                    this.method_37908().method_8406((class_2394)class_2398.field_11247, d - vec3d.field_1352 * 0.25, e - vec3d.field_1351 * 0.25, f - vec3d.field_1350 * 0.25, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                }
                h = this.method_55583();
            } else {
                h = this.method_7466();
            }
            this.method_18799(vec3d.method_1019(vec3d.method_1029().method_1021(this.field_51893)).method_1021((double)h));
            this.particleAnimation(d, e, f);
            this.method_5814(d, e, f);
        } else {
            this.method_31472();
        }
    }

    public void particleAnimation(double d, double e, double f) {
        this.method_37908().method_8466((class_2394)class_2398.field_17909, Config.USE_FORCED_PARTICLES, d, e + 0.5, f, 0.0, 0.0, 0.0);
        this.method_37908().method_8466((class_2394)class_2398.field_11236, Config.USE_FORCED_PARTICLES, d, e + 0.5, f, 0.0, 0.0, 0.0);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            world.method_18456().forEach(p -> {
                world.method_14166(p, (class_2394)class_2398.field_11240, Config.USE_FORCED_PARTICLES, d, e, f, 30 + this.getSize() * 5, 0.02 + (double)this.getSize() / 100.0, 0.02 + (double)this.getSize() / 100.0, 0.02 + (double)this.getSize() / 100.0, 0.1);
                world.method_14166(p, (class_2394)class_2398.field_11251, Config.USE_FORCED_PARTICLES, d, e, f, 30 + this.getSize() * 5, 0.02 + (double)this.getSize() / 100.0, 0.02 + (double)this.getSize() / 100.0, 0.02 + (double)this.getSize() / 100.0, 0.1);
                world.method_14166(p, (class_2394)class_2398.field_17430, Config.USE_FORCED_PARTICLES, d, e, f, 10 + this.getSize() * 2, 0.02 + (double)this.getSize() / 100.0, 0.02 + (double)this.getSize() / 100.0, 0.02 + (double)this.getSize() / 100.0, 0.1);
            });
        }
    }

    private int sphereExplosionAdjuster() {
        int adjust = 0;
        if (this.getSize() > 3) {
            adjust = 2;
        }
        if (this.getSize() > 10) {
            adjust = 3;
        }
        return adjust;
    }

    public void detonateSimple() {
        class_5362 explosionBehavior = new class_5362();
        class_5362 safeExplosion = new class_5362(this){

            public Optional<Float> method_29555(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
                return Optional.of(Float.valueOf(class_2246.field_9987.method_9520()));
            }
        };
        if (this.isScatterMeteor()) {
            if (Config.SCATTER_METEOR_GRIEFING) {
                if (Config.USE_BETTER_EXPLOSIONS) {
                    ExplosionUtils.createExplosion(this.method_37908(), (class_1297)this, this.method_48923().method_48819((class_1297)this, (class_1297)this), explosionBehavior, this.method_19538(), (float)(this.getSize() + Config.EXPLOSION_POWER_MODIFIER + this.sphereExplosionAdjuster()), true, class_1937.class_7867.field_40891);
                } else {
                    this.method_37908().method_46407((class_1297)this, this.method_48923().method_48819((class_1297)this, (class_1297)this), explosionBehavior, this.method_19538(), (float)(this.getSize() + Config.EXPLOSION_POWER_MODIFIER), true, class_1937.class_7867.field_40891);
                }
            } else if (Config.USE_BETTER_EXPLOSIONS) {
                ExplosionUtils.createExplosion(this.method_37908(), (class_1297)this, this.method_48923().method_48819((class_1297)this, (class_1297)this), safeExplosion, this.method_19538(), (float)(this.getSize() + Config.EXPLOSION_POWER_MODIFIER + this.sphereExplosionAdjuster()), false, class_1937.class_7867.field_40891);
            } else {
                this.method_37908().method_46407((class_1297)this, this.method_48923().method_48819((class_1297)this, (class_1297)this), safeExplosion, this.method_19538(), (float)(this.getSize() + Config.EXPLOSION_POWER_MODIFIER), false, class_1937.class_7867.field_40891);
            }
            this.method_31472();
            return;
        }
        if (Config.METEOR_GRIEFING) {
            if (Config.USE_BETTER_EXPLOSIONS) {
                ExplosionUtils.createExplosion(this.method_37908(), (class_1297)this, this.method_48923().method_48819((class_1297)this, (class_1297)this), explosionBehavior, this.method_19538(), (float)(this.getSize() + Config.EXPLOSION_POWER_MODIFIER + this.sphereExplosionAdjuster()), true, class_1937.class_7867.field_40891);
            } else {
                this.method_37908().method_46407((class_1297)this, this.method_48923().method_48819((class_1297)this, (class_1297)this), explosionBehavior, this.method_19538(), (float)(this.getSize() + Config.EXPLOSION_POWER_MODIFIER), true, class_1937.class_7867.field_40891);
            }
        } else {
            this.method_37908().method_46407((class_1297)this, this.method_48923().method_48819((class_1297)this, (class_1297)this), safeExplosion, this.method_19538(), (float)(this.getSize() + Config.EXPLOSION_POWER_MODIFIER), false, class_1937.class_7867.field_40891);
        }
        if (!this.method_37908().method_8608()) {
            ((class_3218)this.method_37908()).method_18456().forEach(serverPlayerEntity -> {
                double dist;
                if (Config.GLOBAL_EXPLOSION_SOUND && serverPlayerEntity.method_19538().method_1022(this.method_19538()) > 60.0) {
                    serverPlayerEntity.method_17356((class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245, 0.5f, 0.8f);
                } else if (Config.AREA_EXPLOSION_SOUND && (dist = serverPlayerEntity.method_19538().method_1022(this.method_19538())) < (double)Config.AREA_EXPLOSION_SOUND_RADIUS && dist > 60.0) {
                    serverPlayerEntity.method_17356((class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245, 0.5f, 0.8f);
                }
                ((class_3218)this.method_37908()).method_14166(serverPlayerEntity, (class_2394)class_2398.field_11221, true, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.1, 0.1, 0.1, 0.1);
            });
        }
        this.method_31472();
    }

    public void detonateWithStructure() {
        this.detonateSimple();
        if (!this.method_37908().method_8608()) {
            if (this.getSize() < 2) {
                int r = this.method_59922().method_39332(1, 3);
                if (r == 1) {
                    this.method_37908().method_8501(class_2338.method_49638((class_2374)this.method_19538()), OMMBlocks.METEORIC_ROCK.method_9564());
                } else if (r == 2) {
                    this.method_37908().method_8501(class_2338.method_49638((class_2374)this.method_19538()), class_2246.field_29032.method_9564());
                } else {
                    this.method_37908().method_8501(class_2338.method_49638((class_2374)this.method_19538()), class_2246.field_23869.method_9564());
                }
                return;
            }
            class_2338 m_pos_offset = class_2338.method_49638((class_2374)this.method_18798()).method_10069(-1, 0, -1);
            StructurePlacerAPI placer = new StructurePlacerAPI((class_5281)this.method_37908(), OhMyMeteors.getIdentifier("small/small_meteor_0"), this.method_24515(), class_2415.field_11302, class_2470.field_11467, false, 1.0f, m_pos_offset);
            if (this.getSize() <= Config.MAX_SMALL_METEOR_SIZE) {
                class_2960 tobeplaced = this.getStructureToPlace("small");
                m_pos_offset = this.getOffset(new class_2338(-1, -1, -1), tobeplaced);
                placer = new StructurePlacerAPI((class_5281)this.method_37908(), tobeplaced, this.method_24515(), class_2415.field_11302, class_2470.field_11467, false, 1.0f, m_pos_offset);
                placer.loadStructure();
                return;
            }
            if (this.getSize() <= Config.MAX_MEDIUM_METEOR_SIZE) {
                class_2960 tobeplaced = this.getStructureToPlace("medium");
                m_pos_offset = this.getOffset(new class_2338(-2, 1, -2), tobeplaced);
                placer = new StructurePlacerAPI((class_5281)this.method_37908(), tobeplaced, this.method_24515(), class_2415.field_11302, class_2470.field_11467, false, 1.0f, m_pos_offset);
                placer.loadStructure();
                return;
            }
            if (this.getSize() <= Config.MAX_BIG_METEOR_SIZE) {
                class_2960 tobeplaced = this.getStructureToPlace("big");
                m_pos_offset = this.getOffset(new class_2338(-3, 0, -3), tobeplaced);
                placer = new StructurePlacerAPI((class_5281)this.method_37908(), tobeplaced, this.method_24515(), class_2415.field_11302, class_2470.field_11467, false, 1.0f, m_pos_offset);
                placer.loadStructure();
                return;
            }
            class_2960 tobeplaced = this.getStructureToPlace("huge");
            m_pos_offset = this.getOffset(new class_2338(-4, 0, -4), tobeplaced);
            placer = new StructurePlacerAPI((class_5281)this.method_37908(), tobeplaced, this.method_24515(), class_2415.field_11302, class_2470.field_11467, false, 1.0f, m_pos_offset);
            placer.loadStructure();
        }
    }

    private class_2338 getOffset(class_2338 m_pos_offset, class_2960 tobeplaced) {
        if (tobeplaced.method_12832().startsWith("error")) {
            return m_pos_offset.method_10069(0, 5, 0);
        }
        class_243 size_factors = class_243.method_24954((class_2382)((class_3499)StructurePlacerAPI.getTemplatePreview((class_3218)((class_3218)this.method_37908()), (class_2960)tobeplaced).get()).method_15160());
        m_pos_offset = class_2338.method_49638((class_2374)this.method_18798()).method_10081((class_2382)m_pos_offset);
        class_2338 nonair_pos = class_2338.method_49638((class_2374)this.method_19538()).method_10069(0, -((int)size_factors.method_10214()) / 3, 0);
        if (tobeplaced.method_12832().startsWith("big")) {
            nonair_pos = class_2338.method_49638((class_2374)this.method_19538()).method_10069(0, -((int)size_factors.method_10214()) / 10, 0);
            if (this.method_36455() < 27.0f) {
                nonair_pos.method_10069((int)(this.method_18798().method_10216() * 5.0), 0, (int)(this.method_18798().method_10215() * 5.0));
            }
        }
        if (tobeplaced.method_12832().startsWith("medium") && this.method_36455() < 27.0f) {
            nonair_pos.method_10069((int)(this.method_18798().method_10216() * 2.0), 0, (int)(this.method_18798().method_10215() * 2.0));
        }
        if (tobeplaced.method_12832().startsWith("huge")) {
            nonair_pos = class_2338.method_49638((class_2374)this.method_19538()).method_10069(0, -((int)size_factors.method_10214()) / 37, 0);
        }
        class_2680 state = this.method_37908().method_8320(nonair_pos);
        int dist_to_floor = 0;
        while (state.method_26215() || state.method_27852(class_2246.field_10036)) {
            nonair_pos = nonair_pos.method_10074();
            state = this.method_37908().method_8320(nonair_pos);
            ++dist_to_floor;
        }
        m_pos_offset = m_pos_offset.method_10069(0, -dist_to_floor, 0);
        return m_pos_offset;
    }

    public class_2960 getStructureToPlace(String sizeClass) {
        int i;
        AtomicBoolean hasSpecial = new AtomicBoolean(false);
        if (OhMyMeteors.METEOR_STRUCTURES.isEmpty() && !this.method_37908().method_8608()) {
            OhMyMeteors.reInitStructures((class_3218)this.method_37908());
        }
        if (OhMyMeteors.METEOR_STRUCTURES.size() == 1 && OhMyMeteors.METEOR_STRUCTURES.getFirst().method_12832().equals("error")) {
            return OhMyMeteors.METEOR_STRUCTURES.getFirst();
        }
        List<class_2960> structs = OhMyMeteors.METEOR_STRUCTURES.stream().filter(identifier -> {
            if (!identifier.method_12832().startsWith(sizeClass)) {
                return false;
            }
            if (!hasSpecial.get() && identifier.method_12832().startsWith(sizeClass + "/special")) {
                hasSpecial.set(true);
                return true;
            }
            return true;
        }).toList();
        class_2960 structure_id = structs.get(this.method_59922().method_39332(0, structs.size() - 1));
        while (structure_id.method_12832().startsWith(sizeClass + "/special")) {
            structure_id = structs.get(this.method_59922().method_39332(0, structs.size() - 1));
        }
        if (hasSpecial.get() && (i = this.field_5974.method_39332(0, Config.SPECIAL_METEORS_CHANCE)) == 1) {
            List<class_2960> specials = structs.stream().filter(id -> id.method_12832().startsWith(sizeClass + "/special")).toList();
            structure_id = specials.get(this.method_59922().method_39332(0, specials.size() - 1));
        }
        return structure_id;
    }

    public void detonateScatter() {
        if (this.method_37908().method_8608() || this.getSize() <= 1) {
            return;
        }
        int scatter_into = this.method_59922().method_39332(1, Math.max(this.getSize() / 2, 1));
        int remainingSize = this.getSize() / 2 + 1;
        ArrayList<MeteorProjectileEntity> newMeteors = new ArrayList<MeteorProjectileEntity>();
        for (int i = 0; i < scatter_into; ++i) {
            int size = this.method_59922().method_39332(1, Math.max(remainingSize - (scatter_into - i), 1));
            MeteorProjectileEntity m = MeteorProjectileEntity.getDownwardsMeteor(this.method_19538(), (class_3218)this.method_37908(), 1, 10 + this.getSize() / 2, this.method_19538().method_10214(), size, size, false);
            m.setScatterMeteor(true);
            newMeteors.add(m);
        }
        this.detonateSimple();
        newMeteors.forEach(meteorProjectileEntity -> this.method_37908().method_8649((class_1297)meteorProjectileEntity));
    }

    protected void method_24920(class_3965 blockHitResult) {
        if (this.exploded) {
            return;
        }
        super.method_24920(blockHitResult);
        class_2680 state = this.method_37908().method_8320(blockHitResult.method_17777());
        if (!state.method_26215()) {
            if (FabricLoader.getInstance().isModLoaded("flan") && !this.method_37908().method_8608() && !FlanCompat.canSpawnHere(null, blockHitResult.method_17777())) {
                this.method_31472();
                OhMyMeteors.LOGGER.warn("A meteor had entered a space protected by a Flan claim, it has been discarded!");
                return;
            }
            if (FabricLoader.getInstance().isModLoaded("yawp") && !this.method_37908().method_8608() && !YawpCompat.canSpawnHere((class_3218)this.method_37908(), blockHitResult.method_17777())) {
                this.method_31472();
                OhMyMeteors.LOGGER.warn("A meteor had entered a space protected by YetAnotherWorldProtector 'EXPLOSION_ENTITY' flag, it has been discarded!");
                return;
            }
            if (state.method_26164(OhMyMeteors.METEOR_BYPASSES)) {
                if (state.method_26164(OhMyMeteors.METEOR_BYPASSES_AND_DESTROY)) {
                    class_238 box = this.method_5829();
                    class_2338.method_29715((class_238)box).forEach(blockPos -> {
                        if (this.method_37908().method_8320(blockPos).method_26164(OhMyMeteors.METEOR_BYPASSES_AND_DESTROY)) {
                            this.method_37908().method_8501(blockPos, class_2246.field_10124.method_9564());
                            this.method_37908().method_8406((class_2394)class_2398.field_11236, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 0.0, 0.0, 0.0);
                        }
                    });
                }
                return;
            }
            if (this.explosionPos == null) {
                this.explosionPos = this.method_19538();
            }
            ++this.travelledBlocks;
            if (this.getSize() / 2 > this.travelledBlocks) {
                return;
            }
            this.method_23327(this.explosionPos.field_1352, this.explosionPos.field_1351, this.explosionPos.field_1350);
            this.method_31472();
            this.exploded = true;
            if (!this.method_37908().method_8608()) {
                if (this.isScatterMeteor()) {
                    if (Config.SCATTER_METEOR_STRUCTURE) {
                        this.detonateWithStructure();
                        return;
                    }
                    this.detonateSimple();
                    return;
                }
                if (Config.METEOR_STRUCTURE) {
                    this.detonateWithStructure();
                } else {
                    this.detonateSimple();
                }
            }
        }
    }

    public boolean isHuge() {
        return this.getSize() > Config.MAX_BIG_METEOR_SIZE;
    }

    public static MeteorProjectileEntity getDownwardsMeteor(class_243 originPos, class_3218 world, int min_spawn_d, int max_spawn_d, double spawn_height, int min_size, int max_size, boolean homing) {
        MeteorProjectileEntity meteor = new MeteorProjectileEntity((class_1937)world);
        int invert_x = 1;
        if (world.method_8409().method_43056()) {
            invert_x = -1;
        }
        int invert_y = 1;
        if (world.method_8409().method_43056()) {
            invert_y = -1;
        }
        meteor.method_23327(originPos.method_10216() + (double)(world.method_8409().method_39332(min_spawn_d, max_spawn_d) * invert_x), spawn_height, originPos.method_10215() + (double)(world.method_8409().method_39332(min_spawn_d, max_spawn_d) * invert_y));
        invert_x = 1;
        if (world.method_8409().method_43056()) {
            invert_x = -1;
        }
        invert_y = 1;
        if (world.method_8409().method_43056()) {
            invert_y = -1;
        }
        meteor.setSize(world.method_8409().method_39332(Math.max(0, min_size), Math.min(50, max_size)));
        meteor.method_18800(world.method_8409().method_43057() / 2.0f * (float)invert_x, -1.0 * ((double)world.method_8409().method_43057() + Config.DOWNWARDS_SPEED_MODIFIER), world.method_8409().method_43057() / 2.0f * (float)invert_y);
        if (homing) {
            meteor.method_18799(originPos.method_1020(meteor.method_19538()).method_1029().method_18805(meteor.method_18798().method_10216(), meteor.method_18798().method_10214() * -1.0, meteor.method_18798().method_10215()));
        }
        return meteor;
    }

    public static void spawnMeteor(class_3218 world, class_1657 p) {
        String message;
        if (p == null) {
            return;
        }
        MeteorProjectileEntity meteor = MeteorProjectileEntity.getDownwardsMeteor(p.method_19538(), world.method_8410(), Config.MIN_METEOR_SPAWN_DISTANCE, Config.MAX_METEOR_SPAWN_DISTANCE, Config.METEOR_SPAWN_HEIGHT, Config.NATURAL_METEOR_MIN_SIZE, Config.NATURAL_METEOR_MAX_SIZE, Config.HOMING_METEORS);
        if (Config.SPAWN_HUGE_METEORS) {
            if (world.method_8409().method_39332(0, Config.HUGE_METEOR_CHANCE) == 0) {
                meteor = MeteorProjectileEntity.getDownwardsMeteor(p.method_19538(), world.method_8410(), Config.MIN_METEOR_SPAWN_DISTANCE, Config.MAX_METEOR_SPAWN_DISTANCE, Config.METEOR_SPAWN_HEIGHT, Config.MAX_BIG_METEOR_SIZE, Config.HUGE_METEOR_SIZE_LIMIT, Config.HOMING_METEORS);
                message = "message.ohmymeteors.meteor_spawned.huge";
            } else {
                message = "message.ohmymeteors.meteor_spawned";
            }
        } else {
            message = "message.ohmymeteors.meteor_spawned";
        }
        if (Config.ANNOUNCE_METEOR_SPAWN) {
            world.method_18456().forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)OhMyMeteors.PREFIX).method_10852((class_2561)class_2561.method_43471((String)message).method_27692(class_124.field_1061)), Config.ACTIONBAR_ANNOUNCEMENTS));
        }
        world.method_8649((class_1297)meteor);
    }

    public static boolean canSpawnInDimension(class_6880<class_2874> current_dim) {
        AtomicBoolean dimension_ok = new AtomicBoolean(false);
        Config.SPAWN_DIMENSIONS.forEach(dim -> {
            if (dimension_ok.get()) {
                return;
            }
            if (dim.equals(current_dim.method_55840())) {
                dimension_ok.set(true);
            }
        });
        return dimension_ok.get();
    }

    public static boolean canSpawnInBiome(class_6880<class_1959> current_biome) {
        if (Config.BIOME_LIST_MODE) {
            return Config.BIOME_SPAWN_LIST.contains(current_biome.method_55840());
        }
        return !Config.BIOME_SPAWN_LIST.contains(current_biome.method_55840());
    }

    public boolean isScatterMeteor() {
        return this.isScatterMeteor;
    }

    public void setScatterMeteor(boolean scatterMeteor) {
        this.isScatterMeteor = scatterMeteor;
    }

    public boolean method_5640(double distance) {
        return true;
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }
}

