/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.ohmymeteors.config;

import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import me.emafire003.dev.ohmymeteors.OhMyMeteors;
import org.apache.commons.io.FileDeleteStrategy;
import org.jetbrains.annotations.NotNull;

public class SimpleConfig {
    private final HashMap<String, String> config = new HashMap();
    private final ConfigRequest request;
    private boolean broken = false;
    private String config_new;

    public static ConfigRequest of(String filename) {
        Path path = OhMyMeteors.PATH;
        return new ConfigRequest(path.resolve(filename + ".yml").toFile(), filename);
    }

    private void createConfig() throws IOException {
        OhMyMeteors.LOGGER.info("Creating config " + this.request.filename);
        this.request.file.getParentFile().mkdirs();
        Files.createFile(this.request.file.toPath(), new FileAttribute[0]);
        PrintWriter writer = new PrintWriter(this.request.file, StandardCharsets.UTF_8);
        writer.write(this.request.getConfig());
        writer.close();
    }

    private void loadConfig() throws IOException {
        Scanner reader = new Scanner(this.request.file);
        int line = 1;
        while (reader.hasNextLine()) {
            this.parseConfigEntry(reader.nextLine(), line);
            ++line;
        }
        reader.close();
    }

    public void updateValues(HashMap<Pair<String, ?>, Pair<String, ?>> sub_map) throws IOException {
        this.config_new = this.request.getConfig();
        sub_map.forEach((oldone, newone) -> {
            String new_string = (String)newone.getFirst() + ":" + String.valueOf(newone.getSecond());
            String old_string = (String)oldone.getFirst() + ":" + String.valueOf(oldone.getSecond());
            if (!((String)newone.getFirst()).equalsIgnoreCase("version") && newone.getSecond() != null && oldone.getSecond() != null) {
                this.config_new = this.config_new.replaceAll(old_string, new_string);
            }
        });
        this.request.file.delete();
        this.request.file.getParentFile().mkdirs();
        Files.createFile(this.request.file.toPath(), new FileAttribute[0]);
        PrintWriter writer = new PrintWriter(this.request.file, StandardCharsets.UTF_8);
        writer.write(this.config_new);
        writer.close();
    }

    public void update() throws IOException {
        this.request.file.delete();
        this.request.file.getParentFile().mkdirs();
        Files.createFile(this.request.file.toPath(), new FileAttribute[0]);
        PrintWriter writer = new PrintWriter(this.request.file, StandardCharsets.UTF_8);
        writer.write(this.config_new);
        writer.close();
    }

    public void parseConfigEntry(String entry, int line) {
        if (!entry.isEmpty() && !entry.startsWith("#")) {
            String[] parts = entry.split(":", 2);
            if (parts.length == 2) {
                String temp = parts[1].split(" #")[0];
                this.config.put(parts[0], temp);
            } else {
                throw new RuntimeException("Syntax error in config file on line " + line + "!");
            }
        }
    }

    private SimpleConfig(ConfigRequest request) {
        this.request = request;
        String identifier = "Config '" + request.filename + "'";
        if (!request.file.exists()) {
            OhMyMeteors.LOGGER.info(identifier + " is missing, generating default one...");
            try {
                this.createConfig();
            }
            catch (IOException e) {
                OhMyMeteors.LOGGER.error(identifier + " failed to generate!");
                e.printStackTrace();
                this.broken = true;
            }
        }
        if (!this.broken) {
            try {
                this.loadConfig();
            }
            catch (Exception e) {
                OhMyMeteors.LOGGER.error(identifier + " failed to load!");
                e.printStackTrace();
                this.broken = true;
            }
        }
    }

    @Deprecated
    public String get(String key) {
        return this.config.get(key);
    }

    public List<String> getOrDefault(String key, List<String> def) {
        String val = this.get(key);
        if (val == null) {
            return def;
        }
        val = val.substring(1, val.length() - 1);
        return Arrays.asList(val.split(", ", -1));
    }

    public Map<String, Integer> getOrDefault(String key, Map<String, Integer> def) {
        String val = this.get(key);
        if (val == null) {
            return def;
        }
        val = val.substring(1, val.length() - 1);
        @NotNull String[] vals = val.split(", ", -1);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String entry : vals) {
            @NotNull String[] the_entry = entry.split("=");
            map.put(the_entry[0], Integer.parseInt(the_entry[1]));
        }
        return map;
    }

    public String getOrDefault(String key, String def) {
        String val = this.get(key);
        if (val == null) {
            OhMyMeteors.LOGGER.info("Returing the default value!!!!!!");
            return def;
        }
        return val;
    }

    public HashMap<String, String> getConfigCopy() {
        return this.config;
    }

    public int getOrDefault(String key, int def) {
        return Integer.parseInt(this.get(key));
    }

    public boolean getOrDefault(String key, boolean def) {
        String val = this.get(key);
        if (val != null) {
            return val.equalsIgnoreCase("true");
        }
        return def;
    }

    public double getOrDefault(String key, double def) {
        try {
            return Double.parseDouble(this.get(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public float getOrDefault(String key, float def) {
        try {
            return Float.parseFloat(this.get(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public double getOrDefaultOrMin(String key, double def, double min) {
        try {
            double d = Double.parseDouble(this.get(key));
            return Math.max(d, min);
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean isBroken() {
        return this.broken;
    }

    public boolean delete() throws IOException {
        if (this.request.file.delete()) {
            return true;
        }
        OhMyMeteors.LOGGER.warn("Normal deletion not possibile, force deleting the config file!");
        FileDeleteStrategy.FORCE.delete(this.request.file);
        OhMyMeteors.LOGGER.warn("Config '" + this.request.filename + "' was removed from existence!");
        return true;
    }

    public void set(String key, boolean def) {
        if (this.config_new == null || this.config_new.isEmpty()) {
            this.config_new = this.request.getConfig();
        }
        String new_string = key + ":" + def;
        String old_string = key + ":" + this.get(key);
        this.config_new = this.config_new.replaceAll(old_string, new_string);
    }

    public void set(String key, String def) {
        if (this.config_new == null || this.config_new.isEmpty()) {
            this.config_new = this.request.getConfig();
        }
        String new_string = key + ":" + def;
        String old_string = key + ":" + this.get(key);
        this.config_new = this.config_new.replaceAll(old_string, new_string);
    }

    public void set(String key, int def) {
        if (this.config_new == null || this.config_new.isEmpty()) {
            this.config_new = this.request.getConfig();
        }
        String new_string = key + ":" + def;
        String old_string = key + ":" + this.get(key);
        this.config_new = this.config_new.replaceAll(old_string, new_string);
    }

    public void set(String key, double def) {
        if (this.config_new == null || this.config_new.isEmpty()) {
            this.config_new = this.request.getConfig();
        }
        String new_string = key + ":" + def;
        String old_string = key + ":" + this.get(key);
        this.config_new = this.config_new.replaceAll(old_string, new_string);
    }

    public static class ConfigRequest {
        private final File file;
        private final String filename;
        private DefaultConfig provider;

        private ConfigRequest(File file, String filename) {
            this.file = file;
            this.filename = filename;
            this.provider = DefaultConfig::empty;
        }

        public ConfigRequest provider(DefaultConfig provider) {
            this.provider = provider;
            return this;
        }

        public SimpleConfig request() {
            return new SimpleConfig(this);
        }

        public String getConfig() {
            return this.provider.get(this.filename) + "\n";
        }
    }

    public static interface DefaultConfig {
        public String get(String var1);

        public static String empty(String namespace) {
            return "";
        }
    }
}

