/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.ohmymeteors.blocks.basic_laser;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import me.emafire003.dev.ohmymeteors.OhMyMeteors;
import me.emafire003.dev.ohmymeteors.blocks.OMMBlocks;
import me.emafire003.dev.ohmymeteors.blocks.OMMProperties;
import me.emafire003.dev.ohmymeteors.blocks.basic_laser.BasicMeteorLaserBlockEntity;
import me.emafire003.dev.ohmymeteors.config.Config;
import me.emafire003.dev.ohmymeteors.entities.MeteorProjectileEntity;
import me.emafire003.dev.ohmymeteors.items.OMMItems;
import me.emafire003.dev.ohmymeteors.particles.OMMParticles;
import me.emafire003.dev.ohmymeteors.sounds.OMMSounds;
import me.emafire003.dev.particleanimationlib.effects.CuboidEffect;
import me.emafire003.dev.particleanimationlib.effects.LineEffect;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class BasicMeteorLaserBlock
extends class_2237
implements class_2343 {
    public static final class_2746 SHOW_AREA = OMMProperties.SHOW_AREA;
    public static final class_2746 FIRING = OMMProperties.FIRING;
    public static final class_2746 IN_COOLDOWN = OMMProperties.IN_COOLDOWN;
    private static boolean AWAKE = false;
    private static int tickCounterAwakening = -1;
    private static final int AWAKE_TIME_LIMIT = 500;
    private static final ConcurrentHashMap<class_2586, Integer> BLOCKS_IN_COOLDOWN = new ConcurrentHashMap();

    public BasicMeteorLaserBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)SHOW_AREA, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)IN_COOLDOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FIRING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return BasicMeteorLaserBlock.method_54094(BasicMeteorLaserBlock::new);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BasicMeteorLaserBlockEntity(pos, state);
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return !world.field_9236 && world.method_8597().comp_642() ? BasicMeteorLaserBlock.method_31618(type, OMMBlocks.BASIC_METEOR_LASER_BLOCK_ENTITY, BasicMeteorLaserBlock::tick) : null;
    }

    public static void awakeLasers() {
        AWAKE = true;
        tickCounterAwakening = 0;
    }

    public static boolean areLasersAwake() {
        return AWAKE;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (stack.method_31574(OMMItems.FOCUSING_LENSES)) {
            class_2680 blockState = (class_2680)state.method_28493((class_2769)SHOW_AREA);
            if (((Boolean)blockState.method_11654((class_2769)SHOW_AREA)).booleanValue()) {
                world.method_8396(null, pos, OMMSounds.LASER_AREA_ON, class_3419.field_15245, 0.7f, 1.0f);
            } else {
                world.method_8396(null, pos, OMMSounds.LASER_AREA_OFF, class_3419.field_15245, 0.7f, 1.0f);
            }
            world.method_8652(pos, blockState, 2);
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    public static void putInCooldown(class_2586 entity) {
        BLOCKS_IN_COOLDOWN.put(entity, 0);
    }

    public static void removeCooldown(class_2586 entity, class_2680 state, class_1937 world, class_2338 pos) {
        BLOCKS_IN_COOLDOWN.remove(entity);
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)IN_COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected static void tick(class_1937 world, class_2338 pos, class_2680 state, BasicMeteorLaserBlockEntity blockEntity) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (world.method_8311(pos.method_10084())) {
                if (Config.SHOULD_BASIC_LASER_COOLDOWN && BLOCKS_IN_COOLDOWN.containsKey((Object)blockEntity)) {
                    if (BLOCKS_IN_COOLDOWN.get((Object)blockEntity) > Config.BASIC_LASER_COOLDOWN * 20) {
                        BasicMeteorLaserBlock.removeCooldown(blockEntity, state, world, pos);
                    } else {
                        BLOCKS_IN_COOLDOWN.put(blockEntity, BLOCKS_IN_COOLDOWN.getOrDefault((Object)blockEntity, 0) + 1);
                        return;
                    }
                }
                if (!((Boolean)state.method_11654((class_2769)SHOW_AREA)).booleanValue() && !AWAKE) {
                    return;
                }
                class_238 box = new class_238(new class_2338(pos.method_10263(), Math.min(pos.method_10264() + BasicMeteorLaserBlock.getYLevelAreaCoverage(), Config.METEOR_SPAWN_HEIGHT), pos.method_10260())).method_1009((double)BasicMeteorLaserBlock.getRadiusAreaCoverage(), 1.0, (double)BasicMeteorLaserBlock.getRadiusAreaCoverage());
                if (((Boolean)state.method_11654((class_2769)SHOW_AREA)).booleanValue()) {
                    CuboidEffect cuboidEffect = CuboidEffect.builder((class_3218)serverWorld, (class_2394)class_2398.field_11241, (class_243)box.method_61125()).particles(30).targetPos(box.method_61126()).iterations(1).build();
                    cuboidEffect.run();
                    class_243 lowerPos = new class_243(box.method_61126().method_10216(), (double)pos.method_10264(), box.method_61126().method_10215());
                    LineEffect line = LineEffect.builder((class_3218)serverWorld, (class_2394)class_2398.field_11241, (class_243)box.method_61126()).targetPos(lowerPos).particles((int)lowerPos.method_1022(box.method_61126())).iterations(1).build();
                    line.run();
                    lowerPos = new class_243(box.method_61125().method_10216(), (double)pos.method_10264(), box.method_61125().method_10215());
                    line.setTargetPos(lowerPos);
                    line.setOriginPos(box.method_61125());
                    line.setParticles((int)lowerPos.method_1022(box.method_61125()));
                    line.run();
                    lowerPos = new class_243(box.method_1005().method_10216(), (double)pos.method_10264(), box.method_1005().method_10215());
                    line.setTargetPos(lowerPos);
                    line.setOriginPos(box.method_1005());
                    line.setParticles((int)lowerPos.method_1022(box.method_1005()));
                    line.setForced(Config.USE_FORCED_PARTICLES);
                    line.run();
                    lowerPos = box.method_61126();
                    line.setTargetPos(lowerPos);
                    line.setOriginPos(box.method_1005());
                    line.setForced(false);
                    line.setParticles((int)lowerPos.method_1022(box.method_1005()));
                    line.run();
                    lowerPos = box.method_61125();
                    line.setTargetPos(lowerPos);
                    line.setOriginPos(box.method_1005());
                    line.setParticles((int)lowerPos.method_1022(box.method_1005()));
                    line.run();
                }
                if (!AWAKE) {
                    return;
                }
                if (tickCounterAwakening > 500) {
                    tickCounterAwakening = 0;
                    AWAKE = false;
                    return;
                }
                List meteors = world.method_8390(MeteorProjectileEntity.class, box, meteorProjectileEntity -> true);
                if (meteors == null || meteors.isEmpty()) {
                    return;
                }
                class_2680 blockState = (class_2680)state.method_11657((class_2769)FIRING, (Comparable)Boolean.valueOf(true));
                world.method_8652(pos, blockState, 2);
                meteors.forEach(meteorProjectileEntity -> {
                    if ((double)meteorProjectileEntity.getSize() > (double)Config.NATURAL_METEOR_MAX_SIZE / 1.5) {
                        meteorProjectileEntity.detonateScatter();
                    } else {
                        meteorProjectileEntity.detonateSimple();
                    }
                    serverWorld.method_14199((class_2394)OMMParticles.LASER_FLASH_PARTICLE, (double)pos.method_10084().method_10084().method_10263(), (double)pos.method_10084().method_10084().method_10264(), (double)pos.method_10084().method_10084().method_10260(), 2, 0.01, 0.01, 0.01, 0.1);
                    LineEffect lineEffect = LineEffect.builder((class_3218)serverWorld, (class_2394)OMMParticles.LASER_PARTICLE, (class_243)pos.method_46558().method_1031(0.0, 0.5, 0.0)).targetPos(meteorProjectileEntity.method_19538()).forced(Config.USE_FORCED_PARTICLES).particles((int)(pos.method_46558().method_1022(meteorProjectileEntity.method_19538()) * 3.0)).build();
                    BasicMeteorLaserBlock.putInCooldown(blockEntity);
                    lineEffect.runFor(1.0, (effect, t) -> {
                        if (t >= 19) {
                            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)FIRING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)IN_COOLDOWN, (Comparable)Boolean.valueOf(true)), 2);
                        }
                    });
                    world.method_8396(null, pos, OMMSounds.LASER_FIRE, class_3419.field_15245, 1.0f, 1.25f);
                    if (Config.ANNOUNCE_METEOR_DESTROYED) {
                        if (meteorProjectileEntity.isHuge()) {
                            serverWorld.method_18456().forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)OhMyMeteors.PREFIX).method_10852((class_2561)class_2561.method_43471((String)"message.ohmymeteors.meteor_destroyed.huge").method_27692(class_124.field_1060)), Config.ACTIONBAR_ANNOUNCEMENTS));
                        } else {
                            serverWorld.method_18456().forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)OhMyMeteors.PREFIX).method_10852((class_2561)class_2561.method_43471((String)"message.ohmymeteors.meteor_destroyed").method_27692(class_124.field_1060)), Config.ACTIONBAR_ANNOUNCEMENTS));
                        }
                    }
                });
                ++tickCounterAwakening;
            }
        }
    }

    protected static int getYLevelAreaCoverage() {
        return Config.BASIC_LASER_AREA_RADIUS;
    }

    protected static int getRadiusAreaCoverage() {
        return Config.BASIC_LASER_HEIGHT;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SHOW_AREA, FIRING, IN_COOLDOWN});
    }

    public class_265 makeShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.625, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.4375, (double)0.625, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)0.875, (double)0.4375), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.625, (double)0.0, (double)0.0625, (double)0.8125, (double)0.0625), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.9375, (double)0.625, (double)0.0, (double)1.0, (double)0.8125, (double)0.0625), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.625, (double)0.9375, (double)0.0625, (double)0.8125, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.9375, (double)0.625, (double)0.9375, (double)1.0, (double)0.8125, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.4375, (double)0.4375, (double)0.875, (double)0.5625), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.5625, (double)1.0, (double)0.875, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.5625, (double)0.8125, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (class_247)class_247.field_1366);
        return shape;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.makeShape();
    }
}

