/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.ohmymeteors.blocks.advanced_laser;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import me.emafire003.dev.ohmymeteors.OhMyMeteors;
import me.emafire003.dev.ohmymeteors.blocks.OMMBlocks;
import me.emafire003.dev.ohmymeteors.blocks.advanced_laser.AdvancedMeteorLaserBlockEntity;
import me.emafire003.dev.ohmymeteors.blocks.basic_laser.BasicMeteorLaserBlock;
import me.emafire003.dev.ohmymeteors.config.Config;
import me.emafire003.dev.ohmymeteors.entities.MeteorProjectileEntity;
import me.emafire003.dev.ohmymeteors.particles.OMMParticles;
import me.emafire003.dev.ohmymeteors.sounds.OMMSounds;
import me.emafire003.dev.particleanimationlib.effects.CuboidEffect;
import me.emafire003.dev.particleanimationlib.effects.LineEffect;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class AdvancedMeteorLaserBlock
extends BasicMeteorLaserBlock {
    private static boolean AWAKE = false;
    private static int tickCounterAwakening = -1;
    private static final int AWAKE_TIME_LIMIT = 500;
    private static final ConcurrentHashMap<class_2586, Integer> BLOCKS_IN_COOLDOWN = new ConcurrentHashMap();

    public AdvancedMeteorLaserBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)SHOW_AREA, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)IN_COOLDOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FIRING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return AdvancedMeteorLaserBlock.method_54094(AdvancedMeteorLaserBlock::new);
    }

    @Override
    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new AdvancedMeteorLaserBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return !world.field_9236 && world.method_8597().comp_642() ? AdvancedMeteorLaserBlock.method_31618(type, OMMBlocks.ADVANCED_METEOR_LASER_BLOCK_ENTITY, AdvancedMeteorLaserBlock::tick) : null;
    }

    public static void awakeLasers() {
        AWAKE = true;
        tickCounterAwakening = 0;
    }

    public static boolean areLasersAwake() {
        return AWAKE;
    }

    protected static int getYLevelAreaCoverage() {
        return Config.ADVANCED_LASER_HEIGHT;
    }

    protected static int getRadiusAreaCoverage() {
        return Config.ADVANCED_LASER_AREA_RADIUS;
    }

    public static void putInCooldown(class_2586 entity) {
        BLOCKS_IN_COOLDOWN.put(entity, 0);
    }

    public static void removeCooldown(class_2586 entity, class_2680 state, class_1937 world, class_2338 pos) {
        BLOCKS_IN_COOLDOWN.remove(entity);
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)IN_COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    private static void tick(class_1937 world, class_2338 pos, class_2680 state, AdvancedMeteorLaserBlockEntity blockEntity) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (world.method_8311(pos.method_10084())) {
                if (Config.SHOULD_ADVANCED_LASER_COOLDOWN && BLOCKS_IN_COOLDOWN.containsKey((Object)blockEntity)) {
                    if (BLOCKS_IN_COOLDOWN.get((Object)blockEntity) > Config.ADVANCED_LASER_COOLDOWN * 20) {
                        AdvancedMeteorLaserBlock.removeCooldown(blockEntity, state, world, pos);
                    } else {
                        BLOCKS_IN_COOLDOWN.put(blockEntity, BLOCKS_IN_COOLDOWN.getOrDefault((Object)blockEntity, 0) + 1);
                        return;
                    }
                }
                if (!((Boolean)state.method_11654((class_2769)SHOW_AREA)).booleanValue() && !AWAKE) {
                    return;
                }
                class_238 box = new class_238(new class_2338(pos.method_10263(), Math.min(pos.method_10264() + AdvancedMeteorLaserBlock.getYLevelAreaCoverage(), Config.METEOR_SPAWN_HEIGHT), pos.method_10260())).method_1009((double)AdvancedMeteorLaserBlock.getRadiusAreaCoverage(), 1.0, (double)AdvancedMeteorLaserBlock.getRadiusAreaCoverage());
                if (((Boolean)state.method_11654((class_2769)SHOW_AREA)).booleanValue()) {
                    CuboidEffect cuboidEffect = CuboidEffect.builder((class_3218)serverWorld, (class_2394)class_2398.field_11241, (class_243)box.method_61125()).particles(30).targetPos(box.method_61126()).iterations(1).build();
                    cuboidEffect.run();
                    class_243 lowerPos = new class_243(box.method_61126().method_10216(), (double)pos.method_10264(), box.method_61126().method_10215());
                    LineEffect line = LineEffect.builder((class_3218)serverWorld, (class_2394)class_2398.field_11241, (class_243)box.method_61126()).targetPos(lowerPos).particles((int)lowerPos.method_1022(box.method_61126())).iterations(1).build();
                    line.run();
                    lowerPos = new class_243(box.method_61125().method_10216(), (double)pos.method_10264(), box.method_61125().method_10215());
                    line.setTargetPos(lowerPos);
                    line.setOriginPos(box.method_61125());
                    line.setParticles((int)lowerPos.method_1022(box.method_61125()));
                    line.run();
                    lowerPos = new class_243(box.method_1005().method_10216(), (double)pos.method_10264(), box.method_1005().method_10215());
                    line.setTargetPos(lowerPos);
                    line.setOriginPos(box.method_1005());
                    line.setParticles((int)lowerPos.method_1022(box.method_1005()));
                    line.setForced(Config.USE_FORCED_PARTICLES);
                    line.run();
                    lowerPos = box.method_61126();
                    line.setForced(false);
                    line.setTargetPos(lowerPos);
                    line.setOriginPos(box.method_1005());
                    line.setParticles((int)lowerPos.method_1022(box.method_1005()));
                    line.run();
                    lowerPos = box.method_61125();
                    line.setTargetPos(lowerPos);
                    line.setOriginPos(box.method_1005());
                    line.setParticles((int)lowerPos.method_1022(box.method_1005()));
                    line.run();
                }
                if (!AWAKE) {
                    return;
                }
                if (tickCounterAwakening > 500) {
                    tickCounterAwakening = 0;
                    AWAKE = false;
                    return;
                }
                List meteors = world.method_8390(MeteorProjectileEntity.class, box, meteorProjectileEntity -> true);
                if (meteors == null || meteors.isEmpty()) {
                    return;
                }
                class_2680 blockState = (class_2680)state.method_11657((class_2769)FIRING, (Comparable)Boolean.valueOf(true));
                world.method_8652(pos, blockState, 2);
                meteors.forEach(meteorProjectileEntity -> {
                    meteorProjectileEntity.detonateSimple();
                    serverWorld.method_14199((class_2394)OMMParticles.LASER_FLASH_PARTICLE, (double)pos.method_10084().method_10084().method_10263(), (double)pos.method_10084().method_10084().method_10264(), (double)pos.method_10084().method_10084().method_10260(), 2, 0.01, 0.01, 0.01, 0.1);
                    LineEffect lineEffect = LineEffect.builder((class_3218)serverWorld, (class_2394)OMMParticles.LASER_PARTICLE, (class_243)pos.method_10084().method_46558()).targetPos(meteorProjectileEntity.method_19538()).particles((int)(pos.method_46558().method_1022(meteorProjectileEntity.method_19538()) * 2.0)).forced(Config.USE_FORCED_PARTICLES).build();
                    lineEffect.setParticle((class_2394)OMMParticles.LASER_PARTICLE_SMALL);
                    lineEffect.setOriginPos(pos.method_10084().method_46558().method_1031(0.5, -0.5, 0.0));
                    lineEffect.setParticles((int)(pos.method_10084().method_46558().method_1031(0.5, -0.5, 0.0).method_1022(meteorProjectileEntity.method_19538()) * 2.0));
                    lineEffect.runFor(1.0);
                    lineEffect.setOriginPos(pos.method_10084().method_46558().method_1031(-0.5, -0.5, 0.0));
                    lineEffect.setParticles((int)(pos.method_10084().method_46558().method_1031(-0.5, -0.5, 0.0).method_1022(meteorProjectileEntity.method_19538()) * 2.0));
                    lineEffect.runFor(1.0);
                    lineEffect.setOriginPos(pos.method_10084().method_46558().method_1031(0.0, -0.5, 0.5));
                    lineEffect.setParticles((int)(pos.method_10084().method_46558().method_1031(0.0, -0.5, 0.5).method_1022(meteorProjectileEntity.method_19538()) * 2.0));
                    lineEffect.runFor(1.0);
                    lineEffect.setOriginPos(pos.method_10084().method_46558().method_1031(0.0, -0.5, -0.5));
                    lineEffect.setParticles((int)(pos.method_10084().method_46558().method_1031(0.0, -0.5, -0.5).method_1022(meteorProjectileEntity.method_19538()) * 2.0));
                    lineEffect.runFor(1.0);
                    lineEffect.setParticle((class_2394)OMMParticles.LASER_PARTICLE);
                    lineEffect.setOriginPos(pos.method_10084().method_46558());
                    lineEffect.setTargetPos(meteorProjectileEntity.method_19538());
                    lineEffect.setParticles((int)(pos.method_46558().method_1022(meteorProjectileEntity.method_19538()) * 2.0));
                    AdvancedMeteorLaserBlock.putInCooldown(blockEntity);
                    lineEffect.runFor(1.0, (effect, t) -> {
                        if (t >= 19) {
                            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)FIRING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)IN_COOLDOWN, (Comparable)Boolean.valueOf(true)), 2);
                        }
                    });
                    world.method_8396(null, pos, OMMSounds.LASER_FIRE, class_3419.field_15245, 1.0f, 1.4f);
                    if (Config.ANNOUNCE_METEOR_DESTROYED) {
                        if (meteorProjectileEntity.isHuge()) {
                            serverWorld.method_18456().forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)OhMyMeteors.PREFIX).method_10852((class_2561)class_2561.method_43471((String)"message.ohmymeteors.meteor_destroyed.huge").method_27692(class_124.field_1060)), Config.ACTIONBAR_ANNOUNCEMENTS));
                        } else {
                            serverWorld.method_18456().forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)OhMyMeteors.PREFIX).method_10852((class_2561)class_2561.method_43471((String)"message.ohmymeteors.meteor_destroyed").method_27692(class_124.field_1060)), Config.ACTIONBAR_ANNOUNCEMENTS));
                        }
                    }
                });
                ++tickCounterAwakening;
            }
        }
    }
}

