/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.data.type.level;

import dev.corgitaco.dataanchor.data.InternalDirtyMarker;
import dev.corgitaco.dataanchor.data.ServerTrackedData;
import dev.corgitaco.dataanchor.data.TickableTrackedData;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import dev.corgitaco.dataanchor.data.type.level.LevelTrackedData;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;

public class TrackedLevelSavedData
extends class_18
implements TrackedDataContainer<class_1937, LevelTrackedData> {
    public static final String DATA_NAME = "dataanchor_saved_tracked_data";
    private final Map<TrackedDataKey<LevelTrackedData>, LevelTrackedData> trackedDataMap = new Reference2ReferenceOpenHashMap();
    private final List<TickableTrackedData> tickableData = new ArrayList<TickableTrackedData>();
    private final class_3218 serverLevel;

    public void method_78(boolean dirty) {
        class_3218 class_32182;
        super.method_78(dirty);
        if (!dirty && (class_32182 = this.serverLevel) instanceof InternalDirtyMarker) {
            InternalDirtyMarker dirtyMarker = (InternalDirtyMarker)class_32182;
            dirtyMarker.dataAnchor$clearDirty();
        }
    }

    private TrackedLevelSavedData(class_3218 serverLevel, class_2487 tag) {
        this.serverLevel = serverLevel;
        this.dataAnchor$createTrackedData();
        for (Map.Entry<TrackedDataKey<LevelTrackedData>, LevelTrackedData> entry : this.trackedDataMap.entrySet()) {
            String idString = entry.getKey().getId().toString();
            if (!tag.method_10573(idString, 10)) continue;
            entry.getValue().load(tag.method_10562(idString));
        }
    }

    private TrackedLevelSavedData(class_3218 serverLevel) {
        this(serverLevel, new class_2487());
    }

    public static TrackedLevelSavedData get(class_3218 world) {
        class_26 data = world.method_17983();
        return (TrackedLevelSavedData)data.method_17924(new class_18.class_8645(() -> new TrackedLevelSavedData(world), (compoundTag, provider) -> new TrackedLevelSavedData(world, (class_2487)compoundTag), class_4284.field_45079), DATA_NAME);
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 registries) {
        for (Map.Entry<TrackedDataKey<LevelTrackedData>, LevelTrackedData> entry : this.trackedDataMap.entrySet()) {
            class_2487 save = entry.getValue().save();
            if (save == null) continue;
            compoundTag.method_10566(entry.getKey().getId().toString(), (class_2520)save);
        }
        return compoundTag;
    }

    @Override
    public <E extends LevelTrackedData> Optional<E> dataAnchor$getTrackedData(TrackedDataKey<E> key) {
        LevelTrackedData levelTrackedData = this.trackedDataMap.get(key);
        if (levelTrackedData == null) {
            return Optional.empty();
        }
        return Optional.of(levelTrackedData);
    }

    @Override
    public void dataAnchor$createTrackedData() {
        TrackedDataRegistries.LEVEL.factories().forEach((key, factory) -> {
            LevelTrackedData trackedData = (LevelTrackedData)factory.create(key, this.serverLevel);
            if (trackedData instanceof ServerTrackedData) {
                if (trackedData instanceof TickableTrackedData) {
                    TickableTrackedData tickableData = (TickableTrackedData)((Object)trackedData);
                    this.tickableData.add(tickableData);
                }
                this.trackedDataMap.put((TrackedDataKey<LevelTrackedData>)key, trackedData);
            }
        });
    }

    @Override
    public Collection<TrackedDataKey<LevelTrackedData>> dataAnchor$getTrackedDataKeys() {
        return this.trackedDataMap.keySet();
    }
}

