/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.event;

import dev.ripio.cobbleloots.config.CobblelootsConfig;
import dev.ripio.cobbleloots.event.custom.CobblelootsLootBallEvents;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class CobblelootsEventManager {
    private static long lootBallSpawnTick = 0L;
    private static final class_5819 randomSource = class_5819.method_43047();

    public static void onChunkGenerate(class_3218 level, class_2818 levelChunk) {
        if (CobblelootsConfig.getBooleanConfig("loot_ball.generation.enabled")) {
            int count = 0;
            for (int i = 0; i < CobblelootsConfig.getIntConfig("loot_ball.generation.attempts") && count < CobblelootsConfig.getIntConfig("loot_ball.generation.chunk_cap"); ++i) {
                if (!CobblelootsLootBallEvents.generateLootBallOnChunk(level, levelChunk, randomSource)) continue;
                ++count;
            }
        }
    }

    public static void onServerTick(MinecraftServer server) {
        if (lootBallSpawnTick == 0L) {
            lootBallSpawnTick = (long)server.method_3780() + CobblelootsEventManager.getLootBallCooldown();
        }
        if ((long)server.method_3780() > lootBallSpawnTick && CobblelootsConfig.getBooleanConfig("loot_ball.spawning.enabled")) {
            CobblelootsLootBallEvents.spawnLootBallNearRandomPlayer(server, randomSource);
            lootBallSpawnTick = (long)server.method_3780() + CobblelootsEventManager.getLootBallCooldown();
        }
    }

    private static long getLootBallCooldown() {
        return randomSource.method_39332(CobblelootsConfig.getIntConfig("loot_ball.spawning.cooldown.min"), CobblelootsConfig.getIntConfig("loot_ball.spawning.cooldown.max"));
    }
}

