/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.ripio.cobbleloots.Cobbleloots;
import dev.ripio.cobbleloots.config.CobblelootsConfig;
import dev.ripio.cobbleloots.data.CobblelootsCodecs;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallData;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallSources;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsBlockFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsLightFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsPositionFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsSourceFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsTimeFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsWeatherFilter;
import dev.ripio.cobbleloots.util.CobblelootsDefinitions;
import dev.ripio.cobbleloots.util.enums.CobblelootsSourceType;
import dev.ripio.cobbleloots.util.math.CobblelootsMath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3449;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CobblelootsDataProvider {
    private static final Map<class_2960, CobblelootsLootBallData> lootBallsData = new HashMap<class_2960, CobblelootsLootBallData>();

    public static void addLootBallData(class_2960 id, JsonElement json) {
        DataResult result = CobblelootsCodecs.LOOT_BALL_DATA_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        CobblelootsLootBallData data = (CobblelootsLootBallData)result.resultOrPartial(arg_0 -> ((Logger)Cobbleloots.LOGGER).error(arg_0)).orElseThrow();
        lootBallsData.put(id, data);
    }

    public static void removeLootBallData(List<class_2960> ids) {
        ids.forEach(lootBallsData::remove);
    }

    public static List<class_2960> getExistingLootBallIds() {
        return new ArrayList<class_2960>(lootBallsData.keySet());
    }

    @Nullable
    public static CobblelootsLootBallData getLootBallData(class_2960 id) {
        return lootBallsData.get(id);
    }

    public static Map.Entry<class_2960, CobblelootsLootBallData> getRandomLootBallData(class_3218 level, class_2818 levelChunk, class_2338 pos, CobblelootsSourceType sourceType) {
        Map.Entry weightEntry;
        HashMap<class_2960, Integer> filtered = new HashMap<class_2960, Integer>();
        for (class_2960 id : CobblelootsDataProvider.getExistingLootBallIds()) {
            CobblelootsLootBallData data = CobblelootsDataProvider.getLootBallData(id);
            if (data == null) {
                Cobbleloots.LOGGER.error("Data not found for id: {}", (Object)id);
                continue;
            }
            CobblelootsLootBallSources sourcesData = data.getSources();
            if (sourcesData == null) continue;
            for (CobblelootsSourceFilter filter : switch (sourceType) {
                case CobblelootsSourceType.GENERATION -> sourcesData.getGeneration();
                case CobblelootsSourceType.SPAWNING -> sourcesData.getSpawning();
                case CobblelootsSourceType.FISHING -> sourcesData.getFishing();
                case CobblelootsSourceType.ARCHAEOLOGY -> sourcesData.getArchaeology();
                default -> throw new IllegalStateException("Unexpected sourceType value: " + String.valueOf((Object)sourceType));
            }) {
                if (!CobblelootsDataProvider.processSourceFilter(level, levelChunk, pos, filter, sourceType)) continue;
                filtered.put(id, filter.getWeight());
            }
        }
        if (!filtered.isEmpty() && (weightEntry = CobblelootsMath.weightedRandomEntry(filtered)) != null) {
            class_2960 key = (class_2960)weightEntry.getKey();
            CobblelootsLootBallData value = CobblelootsDataProvider.getLootBallData(key);
            return new AbstractMap.SimpleEntry<class_2960, CobblelootsLootBallData>(key, value);
        }
        return null;
    }

    public static boolean processSourceFilter(class_3218 level, class_2818 chunk, class_2338 pos, CobblelootsSourceFilter source, CobblelootsSourceType sourceType) {
        if (level == null || pos == null || source == null) {
            return false;
        }
        if (CobblelootsDataProvider.isDimensionDisabled(level, sourceType)) {
            return false;
        }
        if (!CobblelootsDataProvider.checkStructureFilter(level, pos, source.getStructure())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkBiomeFilter(level, pos, source.getBiome())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkDimensionFilter(level, source.getDimension())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkBlockFilter(level, chunk, pos, source.getBlock())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkFluidFilter(level, chunk, pos, source.getFluid())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkPositionFilter(pos, source.getPosition())) {
            return false;
        }
        if (sourceType == CobblelootsSourceType.SPAWNING && !CobblelootsDataProvider.checkLightFilter(level, pos, source.getLight())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkTimeFilter(level, source.getTime())) {
            return false;
        }
        return CobblelootsDataProvider.checkWeatherFilter(level, source.getWeather());
    }

    private static boolean checkStructureFilter(class_3218 level, class_2338 pos, class_6862<class_3195> structureTag) {
        if (structureTag == null || structureTag.equals(CobblelootsDefinitions.EMPTY_STRUCTURE_TAG)) {
            return true;
        }
        class_3449 structureStart = level.method_27056().method_41413(pos, holder -> holder.method_40220(structureTag));
        return structureStart != null && structureStart.method_16657();
    }

    private static boolean checkBiomeFilter(class_3218 level, class_2338 pos, class_6862<class_1959> biomeTag) {
        if (biomeTag == null || biomeTag.equals(CobblelootsDefinitions.EMPTY_BIOME_TAG)) {
            return true;
        }
        return level.method_23753(pos).method_40220(biomeTag);
    }

    private static boolean checkDimensionFilter(class_3218 level, List<class_2960> dimensionIds) {
        if (dimensionIds == null || dimensionIds.isEmpty()) {
            return true;
        }
        return dimensionIds.contains(level.method_27983().method_29177());
    }

    private static boolean checkBlockFilter(class_3218 level, class_2818 chunk, class_2338 spawnPos, CobblelootsBlockFilter blockFilter) {
        if (blockFilter == null) {
            return true;
        }
        class_2826[] sections = chunk.method_12006();
        class_2338 basePos = spawnPos.method_10074();
        int baseSectionIndex = chunk.method_31602(basePos.method_10264());
        if (baseSectionIndex < 0 || baseSectionIndex >= sections.length) {
            return false;
        }
        class_2826 baseSection = sections[baseSectionIndex];
        class_2680 baseBlockState = baseSection.method_12254(basePos.method_10263() & 0xF, basePos.method_10264() & 0xF, basePos.method_10260() & 0xF);
        int spawnSectionIndex = chunk.method_31602(spawnPos.method_10264());
        class_2826 spawnSection = sections[spawnSectionIndex];
        class_2680 spawnBlockState = spawnSection.method_12254(spawnPos.method_10263() & 0xF, spawnPos.method_10264() & 0xF, spawnPos.method_10260() & 0xF);
        return blockFilter.isSpawnable(spawnBlockState) && blockFilter.isBase(baseBlockState);
    }

    private static boolean checkFluidFilter(class_3218 level, class_2818 chunk, class_2338 pos, class_6862<class_3611> fluidTag) {
        if (fluidTag == null || fluidTag.equals(CobblelootsDefinitions.EMPTY_FLUID_TAG)) {
            return true;
        }
        class_2826[] sections = chunk.method_12006();
        int sectionIndex = chunk.method_31602(pos.method_10264());
        class_2826 section = sections[sectionIndex];
        class_3610 fluidState = section.method_12255(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF);
        return fluidState.method_15767(fluidTag);
    }

    private static boolean checkPositionFilter(class_2338 pos, CobblelootsPositionFilter positionFilter) {
        if (positionFilter == null) {
            return true;
        }
        return positionFilter.isInRange(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    private static boolean checkLightFilter(class_3218 level, class_2338 pos, CobblelootsLightFilter lightFilter) {
        if (lightFilter == null) {
            return true;
        }
        int blockLight = level.method_8314(class_1944.field_9282, pos);
        int skyLight = level.method_8314(class_1944.field_9284, pos);
        return lightFilter.isInRange(blockLight, skyLight);
    }

    private static boolean checkTimeFilter(class_3218 level, CobblelootsTimeFilter timeFilter) {
        if (timeFilter == null) {
            return true;
        }
        long currentTime = level.method_8532();
        currentTime = timeFilter.getPeriod() > 0 ? level.method_8532() % (long)timeFilter.getPeriod() : level.method_8532();
        return timeFilter.getValue().isInRange((int)currentTime);
    }

    private static boolean checkWeatherFilter(class_3218 level, CobblelootsWeatherFilter weatherFilter) {
        if (weatherFilter == null) {
            return true;
        }
        return weatherFilter.isValid(level.method_8419(), level.method_8546());
    }

    public static void onReload(class_3300 resourceManager) {
        List<class_2960> cachedLootBalls = CobblelootsDataProvider.getExistingLootBallIds();
        for (class_2960 id : resourceManager.method_14488("loot_ball", path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                InputStream stream = resourceManager.getResourceOrThrow(id).method_14482();
                try {
                    JsonObject jsonObject = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject();
                    id = class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().replace(".json", ""));
                    CobblelootsDataProvider.addLootBallData(id, (JsonElement)jsonObject);
                    cachedLootBalls.remove(id);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (JsonSyntaxException | IOException | NullPointerException | NoSuchElementException e) {
                Cobbleloots.LOGGER.error("Error loading loot ball data: {}", (Object)id, (Object)e);
            }
        }
        CobblelootsDataProvider.removeLootBallData(cachedLootBalls);
        Cobbleloots.LOGGER.info("Loaded {} Loot Ball data definitions.", (Object)lootBallsData.size());
    }

    private static boolean isDimensionDisabled(class_3218 level, CobblelootsSourceType sourceType) {
        List<class_2960> disabledDimensions;
        class_2960 dimensionId = level.method_27983().method_29177();
        switch (sourceType) {
            case GENERATION: {
                disabledDimensions = CobblelootsConfig.getResourceLocationList("loot_ball.disabled.dimensions.generation");
                break;
            }
            case SPAWNING: {
                disabledDimensions = CobblelootsConfig.getResourceLocationList("loot_ball.disabled.dimensions.spawning");
                break;
            }
            case FISHING: {
                disabledDimensions = CobblelootsConfig.getResourceLocationList("loot_ball.disabled.dimensions.fishing");
                break;
            }
            case ARCHAEOLOGY: {
                disabledDimensions = CobblelootsConfig.getResourceLocationList("loot_ball.disabled.dimensions.archaeology");
                break;
            }
            default: {
                return false;
            }
        }
        return disabledDimensions != null && disabledDimensions.contains(dimensionId);
    }
}

