/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_polaroid.client.gui.screen.camera.button;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure_polaroid.Config;
import io.github.mortuusars.exposure_polaroid.world.item.InstantCameraItem;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8666;

public class SlideCounterWidget
extends class_339 {
    protected final class_8666 sprites;
    protected final Camera camera;
    protected final int secondaryFontColor;
    protected final int mainFontColor;

    public SlideCounterWidget(int x, int y, int width, int height, class_8666 sprites, Camera camera) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.sprites = sprites;
        this.camera = camera;
        this.mainFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_MAIN_COLOR);
        this.secondaryFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_SECONDARY_COLOR);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_5250 tooltipComponent = class_2561.method_43471((String)"gui.exposure_polaroid.camera_controls.slide_counter.tooltip");
        if (!this.cameraHasSlides()) {
            tooltipComponent.method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_polaroid.camera_controls.slide_counter.tooltip.no_slides").method_27696(class_2583.field_24360.method_36139(14508887)));
        }
        this.method_47400(class_7919.method_47407((class_2561)tooltipComponent));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_2960 sliderSprite = this.sprites.method_52729(this.method_37303(), this.method_25367());
        guiGraphics.method_52706(sliderSprite, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        String text = this.createText();
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727(text);
        int xPos = 15 + (27 - textWidth) / 2;
        guiGraphics.method_51433(font, text, this.method_46426() + xPos, this.method_46427() + 8, this.secondaryFontColor, false);
        guiGraphics.method_51433(font, text, this.method_46426() + xPos, this.method_46427() + 7, this.mainFontColor, false);
    }

    protected String createText() {
        return this.camera.map((i, s) -> {
            InstantCameraItem instantCamera;
            if (!(i instanceof InstantCameraItem) || (instantCamera = (InstantCameraItem)((Object)i)).getRemainingSlides((class_1799)s) == 0) {
                return "-";
            }
            int remainingSlides = instantCamera.getRemainingSlides((class_1799)s);
            int maxSlides = instantCamera.getMaxSlideCount();
            return remainingSlides + "/" + maxSlides;
        }).orElse("-");
    }

    protected boolean cameraHasSlides() {
        return this.camera.map((i, s) -> {
            InstantCameraItem instantCamera;
            return i instanceof InstantCameraItem && (instantCamera = (InstantCameraItem)((Object)i)).getRemainingSlides((class_1799)s) > 0;
        }).orElse(false);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

