/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_polaroid.client.gui.screen.camera.button;

import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure_polaroid.ExposurePolaroid;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_8666;

public class ExposureSliderButton
extends class_4185 {
    public static final class_2960 BASE = ExposurePolaroid.resource("camera_controls/exposure_slider_base");
    public static final class_8666 SLIDER = new class_8666(ExposurePolaroid.resource("camera_controls/exposure_slider"), ExposurePolaroid.resource("camera_controls/exposure_slider_disabled"), ExposurePolaroid.resource("camera_controls/exposure_slider_highlighted"));
    protected static final int SLIDER_WIDTH = 122;
    protected static final int SLIDER_HEIGHT = 15;
    protected static final int SLIDER_MOVEMENT_RANGE = 58;
    protected final Camera camera;

    public ExposureSliderButton(int x, int y, Camera camera) {
        super(x, y, 79, 15, (class_2561)class_2561.method_43473(), b -> {}, n -> class_2561.method_43473());
        this.camera = camera;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        ShutterSpeed shutterSpeed;
        int indexOf;
        guiGraphics.method_52706(BASE, this.method_46426(), this.method_46427() + 1, this.field_22758, this.field_22759 - 1);
        List<ShutterSpeed> shutterSpeeds = this.camera.map((i, s) -> i.getAvailableShutterSpeeds()).orElse(List.of(ShutterSpeed.DEFAULT));
        if (shutterSpeeds.isEmpty()) {
            shutterSpeeds = List.of(ShutterSpeed.DEFAULT);
        }
        int index = (indexOf = shutterSpeeds.indexOf(shutterSpeed = (ShutterSpeed)CameraSettings.SHUTTER_SPEED.getOrDefault(this.camera))) == -1 ? shutterSpeeds.size() / 2 : indexOf;
        float position = 1.0f - (float)index / (float)(shutterSpeeds.size() - 1);
        int offset = Math.round(58.0f * position);
        class_2960 sliderSprite = SLIDER.method_52729(this.method_37303(), this.method_25367());
        guiGraphics.method_52708(sliderSprite, 122, 15, offset, 0, this.method_46426() + 8, this.method_46427(), 64, 15);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0) {
            this.moveSlider(class_3532.method_17822((double)scrollY));
            return true;
        }
        return false;
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        this.setSliderToMousePosition(mouseX);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25361(mouseX, mouseY)) {
            if (this.method_25351(button)) {
                this.setSliderToMousePosition(mouseX);
                return true;
            }
            if (button == 1) {
                ShutterSpeed newShutterSpeed;
                List<ShutterSpeed> shutterSpeeds = this.camera.map((i, s) -> i.getAvailableShutterSpeeds()).orElse(List.of(ShutterSpeed.DEFAULT));
                if (shutterSpeeds.isEmpty()) {
                    return true;
                }
                int defaultIndex = shutterSpeeds.indexOf(ShutterSpeed.DEFAULT);
                int index = defaultIndex != -1 ? defaultIndex : shutterSpeeds.size() / 2;
                ShutterSpeed shutterSpeed = (ShutterSpeed)CameraSettings.SHUTTER_SPEED.getOrDefault(this.camera);
                if (!shutterSpeed.equals((Object)(newShutterSpeed = shutterSpeeds.get(index)))) {
                    CameraSettings.SHUTTER_SPEED.setAndSync(this.camera, (Object)newShutterSpeed);
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.moveSlider(-1);
            return true;
        }
        if (keyCode == 262) {
            this.moveSlider(1);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void setSliderToMousePosition(double mouseX) {
        ShutterSpeed newShutterSpeed;
        List<ShutterSpeed> shutterSpeeds = this.camera.map((i, s) -> i.getAvailableShutterSpeeds()).orElse(List.of(ShutterSpeed.DEFAULT));
        if (shutterSpeeds.isEmpty()) {
            return;
        }
        int start = this.method_46426() + 8;
        int end = this.method_46426() + 8 + 64;
        int range = end - start;
        int distancePerNotch = range / shutterSpeeds.size();
        int index = (int)class_3532.method_15350((double)((mouseX - (double)start) / (double)distancePerNotch), (double)0.0, (double)(shutterSpeeds.size() - 1));
        ShutterSpeed shutterSpeed = (ShutterSpeed)CameraSettings.SHUTTER_SPEED.getOrDefault(this.camera);
        if (!shutterSpeed.equals((Object)(newShutterSpeed = shutterSpeeds.get(index)))) {
            CameraSettings.SHUTTER_SPEED.setAndSync(this.camera, (Object)newShutterSpeed);
        }
    }

    protected boolean moveSlider(int direction) {
        ShutterSpeed currentShutterSpeed;
        direction = class_3532.method_17822((double)direction);
        List<ShutterSpeed> shutterSpeeds = this.camera.map((i, s) -> i.getAvailableShutterSpeeds()).orElse(List.of(ShutterSpeed.DEFAULT));
        int indexOf = shutterSpeeds.indexOf(currentShutterSpeed = (ShutterSpeed)CameraSettings.SHUTTER_SPEED.getOrDefault(this.camera));
        int index = indexOf == -1 ? shutterSpeeds.size() / 2 : indexOf;
        ShutterSpeed newShutterSpeed = shutterSpeeds.get(index = class_3532.method_15340((int)(index + direction), (int)0, (int)(shutterSpeeds.size() - 1)));
        if (!currentShutterSpeed.equals((Object)newShutterSpeed)) {
            CameraSettings.SHUTTER_SPEED.setAndSync(this.camera, (Object)newShutterSpeed);
            return true;
        }
        return false;
    }
}

