/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_polaroid;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.film.properties.ColorBalance;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmStyle;
import io.github.mortuusars.exposure.world.camera.film.properties.HSB;
import io.github.mortuusars.exposure.world.camera.film.properties.Levels;
import io.github.mortuusars.exposure_polaroid.Register;
import io.github.mortuusars.exposure_polaroid.world.item.InstantCameraItem;
import io.github.mortuusars.exposure_polaroid.world.item.InstantSlideItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class ExposurePolaroid {
    public static final String ID = "exposure_polaroid";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        Blocks.init();
        BlockEntityTypes.init();
        EntityTypes.init();
        Items.init();
        DataComponents.init();
        CriteriaTriggers.init();
        ItemSubPredicates.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
    }

    public static class_2960 resource(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }

    public static class Blocks {
        static void init() {
        }
    }

    public static class BlockEntityTypes {
        static void init() {
        }
    }

    public static class EntityTypes {
        static void init() {
        }
    }

    public static class Items {
        public static final Supplier<InstantCameraItem> INSTANT_CAMERA = Register.item("instant_camera", () -> new InstantCameraItem(new class_1792.class_1793().method_7889(1).method_57349(Exposure.DataComponents.CAMERA_ACTIVE, (Object)false)));
        public static final Supplier<InstantSlideItem> INSTANT_COLOR_SLIDE = Register.item("instant_color_slide", () -> new InstantSlideItem(ExposureType.COLOR, new class_1792.class_1793().method_57349(Exposure.DataComponents.FILM_STYLE, (Object)FilmStyle.create().withContrast(Float.valueOf(0.2f)).withLevels(new Levels(0, 135, 255, 25, 255)).withHSB(new HSB(0.0f, 0.05f, 0.05f)).withColorBalance(new ColorBalance(0.03f, 0.01f, -0.01f)))));
        public static final Supplier<InstantSlideItem> INSTANT_BLACK_AND_WHITE_SLIDE = Register.item("instant_black_and_white_slide", () -> new InstantSlideItem(ExposureType.BLACK_AND_WHITE, new class_1792.class_1793().method_57349(Exposure.DataComponents.FILM_STYLE, (Object)FilmStyle.create().withContrast(Float.valueOf(0.2f)).withLevels(new Levels(0, 135, 255, 25, 255)).withHSB(new HSB(0.0f, 0.05f, 0.05f)).withColorBalance(new ColorBalance(0.03f, 0.01f, -0.01f)))));
        public static final Supplier<InstantSlideItem> HIGH_SENSITIVITY_INSTANT_COLOR_SLIDE = Register.item("high_sensitivity_instant_color_slide", () -> new InstantSlideItem(ExposureType.COLOR, new class_1792.class_1793().method_57349(Exposure.DataComponents.FILM_STYLE, (Object)FilmStyle.create().withSensitivity(Float.valueOf(2.0f)).withContrast(Float.valueOf(0.2f)).withLevels(new Levels(0, 135, 255, 25, 255)).withHSB(new HSB(0.0f, 0.05f, 0.05f)).withColorBalance(new ColorBalance(0.03f, 0.01f, -0.01f)).withNoise(Float.valueOf(0.05f)))));
        public static final Supplier<InstantSlideItem> HIGH_SENSITIVITY_INSTANT_BLACK_AND_WHITE_SLIDE = Register.item("high_sensitivity_instant_black_and_white_slide", () -> new InstantSlideItem(ExposureType.BLACK_AND_WHITE, new class_1792.class_1793().method_57349(Exposure.DataComponents.FILM_STYLE, (Object)FilmStyle.create().withSensitivity(Float.valueOf(2.0f)).withContrast(Float.valueOf(0.2f)).withLevels(new Levels(0, 135, 255, 25, 255)).withHSB(new HSB(0.0f, 0.05f, 0.05f)).withColorBalance(new ColorBalance(0.03f, 0.01f, -0.01f)).withNoise(Float.valueOf(0.05f)))));

        static void init() {
        }
    }

    public static class DataComponents {
        static void init() {
        }
    }

    public static class CriteriaTriggers {
        public static void init() {
        }
    }

    public static class ItemSubPredicates {
        public static void init() {
        }
    }

    public static class MenuTypes {
        static void init() {
        }
    }

    public static class RecipeSerializers {
        static void init() {
        }
    }

    public static class SoundEvents {
        public static final Supplier<class_3414> INSTANT_CAMERA_VIEWFINDER_OPEN = SoundEvents.register("item", "instant_camera.viewfinder_open");
        public static final Supplier<class_3414> INSTANT_CAMERA_VIEWFINDER_CLOSE = SoundEvents.register("item", "instant_camera.viewfinder_close");
        public static final Supplier<class_3414> INSTANT_CAMERA_RELEASE = SoundEvents.register("item", "instant_camera.release");
        public static final Supplier<class_3414> INSTANT_CAMERA_SLIDE_INSERT = SoundEvents.register("item", "instant_camera.slide_insert");
        public static final Supplier<class_3414> INSTANT_CAMERA_SLIDE_REMOVE = SoundEvents.register("item", "instant_camera.slide_remove");

        private static Supplier<class_3414> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> class_3414.method_47908((class_2960)ExposurePolaroid.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static void init() {
        }
    }

    public static class Registries {
    }

    public static class Tags {

        public static class Blocks {
        }

        public static class Items {
        }
    }

    public static class LootTables {
    }

    public static class Stats {
        public static final Map<class_2960, class_3446> STATS = new HashMap<class_2960, class_3446>();

        private static class_2960 register(class_2960 location, class_3446 formatter) {
            STATS.put(location, formatter);
            return location;
        }

        public static void register() {
            STATS.forEach((location, formatter) -> {
                class_2378.method_10230((class_2378)class_7923.field_41183, (class_2960)location, (Object)location);
                class_3468.field_15419.method_14955(location, formatter);
            });
        }
    }
}

