/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.network;

import io.github.kosmx.emotes.arch.mixin.ServerCommonPacketListenerAccessor;
import io.github.kosmx.emotes.arch.network.CommonServerNetworkHandler;
import io.github.kosmx.emotes.arch.network.ConfigTask;
import io.github.kosmx.emotes.arch.network.EmotesMixinConnection;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.arch.network.client.ClientNetwork;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.EmoteStreamHelper;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.fabric.network.PayloadTypeRegistator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_8605;
import net.minecraft.class_8610;

public final class ServerNetworkStuff {
    public static void init() {
        PayloadTypeRegistator.init();
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, NetworkPlatformTools.EMOTE_CHANNEL_ID) && ServerConfigurationNetworking.canSend((class_8610)handler, NetworkPlatformTools.STREAM_CHANNEL_ID)) {
                handler.addTask((class_8605)new ConfigTask());
            } else {
                EmoteInstance.instance.getLogger().log(Level.FINE, "Client doesn't support emotes, ignoring");
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(NetworkPlatformTools.EMOTE_CHANNEL_ID, (buf, context) -> {
            try {
                NetData message = new EmotePacket.Builder().build().read(buf.bytes());
                if (message == null || message.purpose != PacketTask.CONFIG) {
                    throw new IOException("Wrong packet type for config task");
                }
                ((EmotesMixinConnection)((ServerCommonPacketListenerAccessor)context.networkHandler()).getConnection()).emotecraft$setVersions(message.versions);
                CommonServerNetworkHandler.instance.getServerEmotes(message.versions).forEach(buffer -> new EmoteStreamHelper(){

                    @Override
                    protected int getMaxPacketSize() {
                        return 32751;
                    }

                    @Override
                    protected void sendPlayPacket(ByteBuffer buffer) {
                        context.responseSender().sendPacket(ClientNetwork.playPacket(buffer));
                    }

                    @Override
                    protected void sendStreamChunk(ByteBuffer buffer) {
                        context.responseSender().sendPacket(ClientNetwork.streamPacket(buffer));
                    }
                });
                context.networkHandler().completeTask(ConfigTask.TYPE);
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
                context.networkHandler().method_52396((class_2561)class_2561.method_43470((String)("emotecraft: " + e.getMessage())));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(NetworkPlatformTools.EMOTE_CHANNEL_ID, (buf, context) -> CommonServerNetworkHandler.instance.receiveMessage(buf.unwrapBytes(), (class_1657)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(NetworkPlatformTools.STREAM_CHANNEL_ID, (buf, context) -> CommonServerNetworkHandler.instance.receiveStreamMessage(buf.unwrapBytes(), (class_1657)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(NetworkPlatformTools.GEYSER_CHANNEL_ID, (buf, context) -> CommonServerNetworkHandler.instance.receiveGeyserMessage(context.player(), buf.unwrapBytes()));
    }
}

