/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script;

import com.blamejared.crafttweaker.CraftTweakerCommon;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IngredientCacheBuster;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.util.sequence.SequenceManager;
import com.blamejared.crafttweaker.api.villager.CTVillagerTrades;
import com.blamejared.crafttweaker.api.zencode.scriptrun.IScriptRun;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptDiscoveryConfiguration;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.blamejared.crafttweaker.mixin.common.access.tag.AccessTagManager;
import com.blamejared.crafttweaker.platform.helper.IAccessibleServerElementsProvider;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2561;
import net.minecraft.class_3300;
import net.minecraft.class_3505;
import net.minecraft.class_3695;
import net.minecraft.class_3956;
import net.minecraft.class_4080;
import net.minecraft.class_5250;
import net.minecraft.class_5350;
import net.minecraft.class_8786;

public final class ScriptReloadListener
extends class_4080<Void> {
    private static final class_5250 MSG_RELOAD_STARTING = class_2561.method_43471((String)"crafttweaker.reload.start");
    private static final class_5250 MSG_RELOAD_COMPLETE = class_2561.method_43471((String)"crafttweaker.reload.complete");
    private static final Random RANDOM = ThreadLocalRandom.current();
    private final class_5350 resources;
    private final Consumer<class_5250> feedbackConsumer;

    public ScriptReloadListener(class_5350 managerSupplier, Consumer<class_5250> feedbackConsumer) {
        this.resources = managerSupplier;
        this.feedbackConsumer = feedbackConsumer;
    }

    protected Void prepare(class_3300 resourceManager, class_3695 profiler) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(Void object, class_3300 resourceManager, class_3695 profiler) {
        IngredientCacheBuster.claim();
        SequenceManager.clearSequences();
        CTVillagerTrades.clear();
        IAccessibleServerElementsProvider asep = CraftTweakerAPI.getAccessibleElementsProvider().server();
        asep.resources(this.resources);
        class_3505 tagmanager = asep.accessibleResources().crafttweaker$getTagManager();
        asep.registryAccess(((AccessTagManager)tagmanager).crafttweaker$getRegistryAccess());
        CraftTweakerTagRegistry.INSTANCE.bind(tagmanager);
        class_1863 manager = this.resources.method_29471();
        this.feedbackConsumer.accept(MSG_RELOAD_STARTING);
        this.fixRecipeManager(manager);
        RunPreparation runPreparation = this.prepareRun();
        try {
            runPreparation.run().execute();
        }
        catch (Throwable e) {
            CraftTweakerCommon.logger().error("Unable to execute script run", e);
            return;
        }
        finally {
            IngredientCacheBuster.release();
        }
        this.storeScriptsInRecipes(manager, runPreparation.root(), runPreparation.scripts());
        this.feedbackConsumer.accept(MSG_RELOAD_COMPLETE);
        if (!runPreparation.scripts().isEmpty() && runPreparation.run().specificRunInfo().displayBranding()) {
            this.displayPatreonBranding();
        }
    }

    private void fixRecipeManager(class_1863 manager) {
        AccessRecipeManager accessRecipeManager = (AccessRecipeManager)manager;
        accessRecipeManager.crafttweaker$setByType((Multimap<class_3956<?>, class_8786<?>>)HashMultimap.create(accessRecipeManager.crafttweaker$getByType()));
        accessRecipeManager.crafttweaker$setByName(new HashMap(accessRecipeManager.crafttweaker$getByName()));
        CraftTweakerAPI.getAccessibleElementsProvider().recipeManager(manager);
    }

    private RunPreparation prepareRun() {
        class Retainer
        implements ScriptDiscoveryConfiguration.DiscoveryRetainer {
            Path root;
            List<Path> scripts;

            Retainer(ScriptReloadListener this$0) {
            }

            @Override
            public void retain(Path root, List<Path> discoveryResults) {
                this.root = root;
                this.scripts = discoveryResults;
            }
        }
        Retainer retainer = new Retainer(this);
        ScriptDiscoveryConfiguration discoveryConfiguration = new ScriptDiscoveryConfiguration(ScriptDiscoveryConfiguration.SuspiciousNamesBehavior.WARN, retainer);
        ScriptRunConfiguration runConfiguration = new ScriptRunConfiguration("crafttweaker", CraftTweakerConstants.RELOAD_LISTENER_SOURCE_ID, ScriptRunConfiguration.RunKind.EXECUTE);
        IScriptRun run = CraftTweakerAPI.getScriptRunManager().createScriptRun(CraftTweakerAPI.getScriptsDirectory(), discoveryConfiguration, runConfiguration);
        return new RunPreparation(run, retainer.root, retainer.scripts);
    }

    private void storeScriptsInRecipes(class_1863 manager, Path root, List<Path> scripts) {
        Multimap<class_3956<?>, class_8786<?>> recipes = ((AccessRecipeManager)manager).crafttweaker$getByType();
        scripts.stream().map(it -> this.buildScriptRecipe((Path)it, root)).forEach(it -> recipes.put(it.method_17716(), (Object)new class_8786(it.getId(), (class_1860)it)));
    }

    private ScriptRecipe buildScriptRecipe(Path file, Path root) {
        String fileName = root.relativize(file).toString().replace('\\', '/');
        return new ScriptRecipe(fileName, this.readContents(file));
    }

    private String readContents(Path file) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(file));
        }
        catch (IOException e) {
            CraftTweakerCommon.logger().info("Unable to read script file " + String.valueOf(file), (Throwable)e);
            return "";
        }
    }

    private void displayPatreonBranding() {
        Set<String> patronList = CraftTweakerCommon.getPatronList();
        if (patronList.isEmpty()) {
            return;
        }
        patronList.stream().skip(RANDOM.nextInt(patronList.size())).findFirst().ifPresent(name -> CraftTweakerCommon.logger().info("This reload was made possible by {} and more! Become a patron at https://patreon.com/jaredlll08?s=crtmod", name));
    }

    private record RunPreparation(IScriptRun run, Path root, List<Path> scripts) {
    }
}

