/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.handler.helper;

import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2371;

public final class CraftingTableRecipeConflictChecker {
    public static boolean checkConflicts(IRecipeManager<?> manager, class_1860<?> first, class_1860<?> second) {
        if (first.method_8118() || second.method_8118()) {
            return false;
        }
        if (!(first instanceof class_1869) && second instanceof class_1869) {
            return CraftingTableRecipeConflictChecker.redirect(manager, second, first);
        }
        return CraftingTableRecipeConflictChecker.checkConflictsMaybeDifferent(first, second);
    }

    private static <T extends class_1860<?>> boolean redirect(IRecipeManager<?> manager, T second, class_1860<?> first) {
        return IRecipeHandlerRegistry.getHandlerFor(second).doesConflict((IRecipeManager)GenericUtil.uncheck(manager), second, first);
    }

    private static boolean checkConflictsMaybeDifferent(class_1860<?> first, class_1860<?> second) {
        if (first instanceof class_1869) {
            class_1869 shapedFirst = (class_1869)first;
            if (second instanceof class_1869) {
                class_1869 shapedSecond = (class_1869)second;
                return CraftingTableRecipeConflictChecker.doShapedShapedConflict(shapedFirst, shapedSecond);
            }
            return CraftingTableRecipeConflictChecker.doShapedShapelessConflict(shapedFirst, second);
        }
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict(first, second);
    }

    private static boolean doShapedShapedConflict(class_1869 first, class_1869 second) {
        if (first.method_8158() != second.method_8158()) {
            return false;
        }
        if (first.method_8150() != second.method_8150()) {
            return false;
        }
        class_2371 firstIngredients = first.method_8117();
        class_2371 secondIngredients = second.method_8117();
        for (int i = 0; i < firstIngredients.size(); ++i) {
            class_1856 secondIngredient;
            class_1856 firstIngredient = (class_1856)firstIngredients.get(i);
            if (IngredientUtil.canConflict(firstIngredient, secondIngredient = (class_1856)secondIngredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean doShapedShapelessConflict(class_1869 first, class_1860<?> second) {
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict(first.method_8117().stream().filter(it -> it != class_1856.field_9017).collect(Collectors.toList()), (List<class_1856>)second.method_8117());
    }

    private static boolean doShapelessShapelessConflict(class_1860<?> first, class_1860<?> second) {
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict((List<class_1856>)first.method_8117(), (List<class_1856>)second.method_8117());
    }

    private static boolean doShapelessShapelessConflict(List<class_1856> first, List<class_1856> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return IngredientUtil.doIngredientsConflict(first, second);
    }
}

