/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

public class RecipeList<T extends class_1860<?>> {
    private final class_3956<T> recipeType;
    private final Collection<class_8786<T>> recipes;
    private final Map<class_2960, class_8786<T>> byName;
    private final Collection<class_8786<T>> unmodifiableRecipes;
    private final Map<class_2960, class_8786<T>> unmodifiableByName;

    public RecipeList(class_3956<T> recipeType, Collection<class_8786<T>> recipes, Map<class_2960, class_8786<?>> byName) {
        this.recipeType = recipeType;
        this.recipes = recipes;
        this.byName = (Map)GenericUtil.uncheck(byName);
        this.unmodifiableRecipes = Collections.unmodifiableCollection(this.recipes);
        this.unmodifiableByName = Collections.unmodifiableMap(this.byName);
    }

    public List<class_8786<T>> getRecipesByOutput(IIngredient output) {
        return AccessibleElementsProvider.get().registryAccess(registryAccess -> this.getRecipes().stream().filter(recipe -> output.matches(IItemStack.of(recipe.comp_1933().method_8110((class_7225.class_7874)registryAccess)))).toList());
    }

    public List<class_8786<T>> getRecipesMatching(Predicate<class_8786<T>> predicate) {
        return this.getRecipes().stream().filter(predicate).toList();
    }

    public class_8786<T> get(class_2960 id) {
        return this.getByName().get(id);
    }

    public class_8786<T> get(String id) {
        return this.get(class_2960.method_12829((String)id));
    }

    public boolean has(class_2960 id) {
        return this.getByName().containsKey(id);
    }

    public boolean has(String id) {
        return this.has(class_2960.method_12829((String)id));
    }

    public void add(class_2960 id, class_8786<T> recipe) {
        if (this.getByName().containsKey(recipe.comp_1932())) {
            CommonLoggers.api().warn("A recipe with the name '{}' already exists and will be overwritten: this is most likely an error in your scripts", (Object)recipe.comp_1932().method_12832());
        }
        this.recipes.add(recipe);
        this.byName.put(id, recipe);
    }

    public void remove(class_2960 id) {
        this.recipes.removeIf(tRecipeHolder -> tRecipeHolder.comp_1932().equals((Object)id));
        this.byName.remove(id);
    }

    public void removeByRecipeTest(Predicate<class_8786<T>> recipePredicate) {
        Iterator<class_8786<T>> iterator = this.recipes.iterator();
        while (iterator.hasNext()) {
            class_8786<T> next = iterator.next();
            if (!recipePredicate.test(next)) continue;
            this.byName.remove(next.comp_1932());
            iterator.remove();
        }
    }

    public void removeByIdTest(Predicate<class_2960> idPredicate) {
        this.removeByIdTest(idPredicate, s -> false);
    }

    public void removeByIdTest(Predicate<class_2960> idPredicate, Predicate<String> exclusions) {
        Iterator<class_8786<T>> iterator = this.recipes.iterator();
        while (iterator.hasNext()) {
            class_2960 next = iterator.next().comp_1932();
            if (!idPredicate.test(next) || exclusions.test(next.method_12832())) continue;
            this.byName.remove(next);
            iterator.remove();
        }
    }

    public void removeAll() {
        this.byName.values().removeAll(this.recipes);
        this.recipes.clear();
    }

    public class_3956<T> getRecipeType() {
        return this.recipeType;
    }

    public Collection<class_8786<T>> getRecipes() {
        return this.unmodifiableRecipes;
    }

    public Map<class_2960, class_8786<T>> getByName() {
        return this.unmodifiableByName;
    }

    public int getSize() {
        return this.getRecipes().size();
    }
}

