/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.vanilla.DelegatingCustomIngredient;
import com.blamejared.crafttweaker.api.ingredient.vanilla.DelegatingCustomIngredientSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.CraftTweakerVanillaIngredientSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientAnySerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientCraftTweakerSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientIItemStackSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientListSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.CraftTweakerVanillaIngredient;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientAny;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientCraftTweaker;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientIItemStack;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientList;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;

public class CraftTweakerIngredients {
    private static final BiMap<CraftTweakerVanillaIngredientSerializer<?>, DelegatingCustomIngredientSerializer<?>> SERIALIZER_CACHE = HashBiMap.create();
    private static final BiMap<CraftTweakerVanillaIngredient, DelegatingCustomIngredient<?>> SINGLETON_CACHE = HashBiMap.create();

    public static class Serializers {
        public static final CustomIngredientSerializer<?> ANY = (CustomIngredientSerializer)SERIALIZER_CACHE.computeIfAbsent((Object)IngredientAnySerializer.INSTANCE, DelegatingCustomIngredientSerializer::new);
        public static final CustomIngredientSerializer<?> LIST = (CustomIngredientSerializer)SERIALIZER_CACHE.computeIfAbsent((Object)IngredientListSerializer.INSTANCE, DelegatingCustomIngredientSerializer::new);
        public static final CustomIngredientSerializer<?> CRAFTTWEAKER = (CustomIngredientSerializer)SERIALIZER_CACHE.computeIfAbsent((Object)IngredientCraftTweakerSerializer.INSTANCE, DelegatingCustomIngredientSerializer::new);
        public static final CustomIngredientSerializer<?> IITEMSTACK = (CustomIngredientSerializer)SERIALIZER_CACHE.computeIfAbsent((Object)IngredientIItemStackSerializer.INSTANCE, DelegatingCustomIngredientSerializer::new);

        static <T extends CraftTweakerVanillaIngredient> CustomIngredientSerializer<DelegatingCustomIngredient<T>> of(CraftTweakerVanillaIngredientSerializer<T> ingredient) {
            return (CustomIngredientSerializer)GenericUtil.uncheck(SERIALIZER_CACHE.computeIfAbsent(ingredient, DelegatingCustomIngredientSerializer::new));
        }
    }

    public static class Ingredients {
        public static CustomIngredient any() {
            return (CustomIngredient)SINGLETON_CACHE.computeIfAbsent((Object)IngredientAny.of(), DelegatingCustomIngredient::new);
        }

        public static <T extends IIngredient> CustomIngredient crafttweaker(T internal) {
            return new DelegatingCustomIngredient<IngredientCraftTweaker<T>>(IngredientCraftTweaker.of(internal));
        }

        public static CustomIngredient iitemstack(IItemStack internal) {
            return new DelegatingCustomIngredient<IngredientIItemStack>(IngredientIItemStack.of(internal));
        }

        public static CustomIngredient list(List<class_1856> children) {
            return new DelegatingCustomIngredient<IngredientList>(IngredientList.of(children));
        }

        static <T extends CraftTweakerVanillaIngredient> DelegatingCustomIngredient<T> of(T ingredient) {
            if (ingredient.singleton()) {
                return (DelegatingCustomIngredient)GenericUtil.uncheck(SINGLETON_CACHE.computeIfAbsent(ingredient, DelegatingCustomIngredient::new));
            }
            return new DelegatingCustomIngredient<T>(ingredient);
        }
    }
}

