/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.ByteArrayData;
import com.blamejared.crafttweaker.api.data.ByteData;
import com.blamejared.crafttweaker.api.data.IntArrayData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.ListData;
import com.blamejared.crafttweaker.api.data.LongArrayData;
import com.blamejared.crafttweaker.api.data.LongData;
import com.blamejared.crafttweaker.api.data.ShortData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.data.visitor.DataToStringVisitor;
import com.blamejared.crafttweaker.api.data.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2483;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.type.BasicTypeID;

@ZenRegister(loaders={"crafttweaker", "tags"})
@ZenCodeType.Name(value="crafttweaker.api.data.IData")
@Document(value="vanilla/api/data/IData")
public interface IData
extends Comparable<IData>,
Iterable<IData> {
    @ZenCodeType.Method
    public static IData listOf(IData ... members) {
        int i;
        Object[] result;
        if (members == null) {
            return new ListData();
        }
        int type = 0;
        boolean byteIndex = true;
        int intIndex = 2;
        int longIndex = 4;
        int otherIndex = 8;
        for (IData member : members) {
            if (member instanceof ByteData) {
                type |= 1;
                continue;
            }
            if (member instanceof IntData || member instanceof ShortData) {
                type |= 2;
                continue;
            }
            if (member instanceof LongData) {
                type |= 4;
                continue;
            }
            type |= 8;
        }
        if ((type & 8) != 0) {
            return new ListData(members);
        }
        if ((type & 4) != 0) {
            result = new long[members.length];
            for (i = 0; i < members.length; ++i) {
                result[i] = members[i].asLong();
            }
            return new LongArrayData((long[])result);
        }
        if ((type & 2) != 0) {
            result = new int[members.length];
            for (i = 0; i < members.length; ++i) {
                result[i] = members[i].asInt();
            }
            return new IntArrayData((int[])result);
        }
        if ((type & 1) != 0) {
            result = new byte[members.length];
            for (i = 0; i < members.length; ++i) {
                result[i] = members[i].asByte();
            }
            return new ByteArrayData((byte[])result);
        }
        return new ListData();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.ADD)
    @ZenCodeType.Method
    default public IData add(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.ADD);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.SUB)
    default public IData sub(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.SUB);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public IData mul(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.MUL);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.DIV)
    default public IData div(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.DIV);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MOD)
    default public IData mod(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.MOD);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CAT)
    default public IData cat(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.CAT);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    default public IData or(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.OR);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.AND)
    default public IData and(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.AND);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.XOR)
    default public IData xor(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.XOR);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.NEG)
    default public IData neg() {
        return (IData)this.notSupportedOperator(OperatorType.NEG);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.NOT)
    default public IData not() {
        return (IData)this.notSupportedOperator(OperatorType.NOT);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.INDEXSET)
    default public void put(String index, @ZenCodeType.Nullable IData value) {
        this.notSupportedOperator(OperatorType.INDEXSET);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.INDEXGET)
    default public IData getAt(int index) {
        return (IData)this.notSupportedOperator(OperatorType.INDEXGET);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.INDEXGET)
    default public IData getAt(String key) {
        return (IData)this.notSupportedOperator(OperatorType.INDEXGET);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean contains(IData other) {
        return (Boolean)this.notSupportedOperator(OperatorType.CONTAINS);
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.COMPARE)
    default public int compareTo(@NotNull IData other) {
        return (Integer)this.notSupportedOperator(OperatorType.COMPARE);
    }

    @ZenCodeType.Method
    default public void remove(int index) {
        this.doesNot("support removal by index");
    }

    @ZenCodeType.Method
    default public void remove(String key) {
        this.doesNot("support removal by key");
    }

    @ZenCodeType.Method
    default public void setAt(String name, @ZenCodeType.Nullable IData data) {
        this.put(name, data);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    default public boolean equalTo(IData other) {
        return (Boolean)this.notSupportedOperator(OperatorType.EQUALS);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.SHL)
    default public IData shl(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.SHL);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.SHR)
    default public IData shr(IData other) {
        return (IData)this.notSupportedOperator(OperatorType.SHR);
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public boolean asBool() {
        return (Boolean)this.notSupportedCast(BasicTypeID.BOOL);
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public @ZenCodeType.Unsigned byte asByte() {
        return (Byte)this.notSupportedCast(BasicTypeID.BYTE);
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public short asShort() {
        return (Short)this.notSupportedCast(BasicTypeID.SHORT);
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public int asInt() {
        return (Integer)this.notSupportedCast(BasicTypeID.INT);
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public long asLong() {
        return (Long)this.notSupportedCast(BasicTypeID.LONG);
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public float asFloat() {
        return ((Float)this.notSupportedCast(BasicTypeID.FLOAT)).floatValue();
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public double asDouble() {
        return (Double)this.notSupportedCast(BasicTypeID.DOUBLE);
    }

    @ZenCodeType.Method
    default public String asString() {
        return this.accept(DataToStringVisitor.ESCAPE);
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public String getAsString() {
        return this.accept(DataToStringVisitor.PLAIN);
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public List<IData> asList() {
        return (List)this.notSupportedCast("IData[]");
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public Map<String, IData> asMap() {
        return (Map)this.notSupportedCast("IData[string]");
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public byte[] asByteArray() {
        return (byte[])this.notSupportedCast("byte[]");
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public int[] asIntArray() {
        return (int[])this.notSupportedCast("int[]");
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    default public long[] asLongArray() {
        return (long[])this.notSupportedCast("long[]");
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="length")
    default public int length() {
        return (Integer)this.doesNot("have a length");
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="keys")
    default public Set<String> getKeys() {
        return (Set)this.doesNot("is not indexable by keys");
    }

    @Override
    @NotNull
    default public Iterator<IData> iterator() {
        return (Iterator)this.doesNot("support iteration");
    }

    @ZenCodeType.Method
    default public IData merge(IData other) {
        return (IData)this.doesNot("support merging");
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isEmpty")
    default public boolean isEmpty() {
        return this.length() == 0;
    }

    @ZenCodeType.Method
    default public byte getId() {
        return this.getInternal().method_10711();
    }

    public class_2520 getInternal();

    @ZenCodeType.Method
    public IData copy();

    public IData copyInternal();

    public <T> T accept(DataVisitor<T> var1);

    @ZenCodeType.Method
    default public IData map(Function<IData, IData> operation) {
        return operation.apply(this);
    }

    public Type getType();

    private <T> T doesNot(String message) {
        throw new UnsupportedOperationException("Data type: '%s' does not %s!".formatted(new Object[]{this.getType(), message}));
    }

    private <T> T notSupportedOperator(OperatorType operator) {
        return this.doesNot("support the '%s' ('%s') operator".formatted(operator.compiledName, operator.operator));
    }

    private <T> T notSupportedCast(String toType) {
        return this.doesNot("support being cast to '%s'".formatted(toType));
    }

    private <T> T notSupportedCast(BasicTypeID toType) {
        return this.notSupportedCast(toType.name);
    }

    @ApiStatus.Internal
    default public boolean isListable() {
        return false;
    }

    @ApiStatus.Internal
    default public boolean isMappable() {
        return false;
    }

    default public boolean containsList(List<IData> dataValues) {
        class_2520 class_25202 = this.getInternal();
        if (class_25202 instanceof class_2483) {
            class_2483 internal = (class_2483)class_25202;
            block0: for (IData dataValue : dataValues) {
                for (class_2520 value : internal) {
                    if (!TagToDataConverter.convert(value).contains(dataValue)) continue;
                    continue block0;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static enum Type {
        BOOL,
        BYTE_ARRAY,
        BYTE,
        DOUBLE,
        FLOAT,
        INT_ARRAY,
        INT,
        LIST,
        LONG_ARRAY,
        LONG,
        MAP,
        SHORT,
        STRING,
        EMPTY;

    }
}

