/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.registry;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.api.StructurifyStructurePlacement;
import com.faboslav.structurify.common.events.common.UpdateRegistriesEvent;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public final class StructurifyRegistryUpdater {
    public static void updateRegistries(UpdateRegistriesEvent event) {
        if (!Structurify.getConfig().isLoaded) {
            return;
        }
        try {
            Structurify.getLogger().info("Updating registries...");
            class_7225.class_7874 registryManager = event.registryManager();
            if (registryManager == null) {
                return;
            }
            StructurifyRegistryUpdater.updateStructures(registryManager);
            StructurifyRegistryUpdater.updateStructureSets(registryManager);
            Structurify.getLogger().info("Registries updated");
        }
        catch (Exception e) {
            Structurify.getLogger().info("Failed to update registries");
        }
    }

    private static void updateStructures(class_7225.class_7874 registryManager) {
        class_7225.class_7226 structureRegistry = registryManager.method_46759(class_7924.field_41246).orElse(null);
        if (structureRegistry == null) {
            return;
        }
        for (class_6880.class_6883 structureReference : structureRegistry.method_42017().toList()) {
            class_3195 structure = (class_3195)structureReference.comp_349();
            class_5321 structureRegistryKey = structureReference.method_40237();
            class_2960 structureId = structureRegistryKey.method_29177();
            StructurifyStructure structurifyStructure = (StructurifyStructure)structure;
            structurifyStructure.structurify$setStructureIdentifier(structureId);
            structurifyStructure.structurify$setStructureBiomes(null);
        }
        Structurify.getLogger().info("Structure registries updated");
    }

    private static void updateStructureSets(class_7225.class_7874 registryManager) {
        class_7225.class_7226 structureSetRegistry = registryManager.method_46759(class_7924.field_41248).orElse(null);
        if (structureSetRegistry == null) {
            return;
        }
        for (class_6880.class_6883 structureSetReference : structureSetRegistry.method_42017().toList()) {
            class_7059 structureSet = (class_7059)structureSetReference.comp_349();
            class_5321 structureSetRegistryKey = structureSetReference.method_40237();
            class_2960 structureSetId = structureSetRegistryKey.method_29177();
            StructurifyStructurePlacement structurifyStructurePlacement = (StructurifyStructurePlacement)structureSet.comp_511();
            structurifyStructurePlacement.structurify$setStructureSetIdentifier(structureSetId);
        }
        Structurify.getLogger().info("Structure Sets registries updated");
    }
}

