/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Displayable;
import lombok.Generated;
import me.frankv.jmi.api.event.Event;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlayHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OverlayHelper.class);
    private static final List<Runnable> waitingQueue = new LinkedList<Runnable>();
    private static IClientAPI jmAPI;
    private static boolean jmMappingStarted;

    public static void showOverlay(Displayable overlay) {
        if (!jmMappingStarted) {
            waitingQueue.add(() -> OverlayHelper.safeShowOverlay(overlay));
        } else {
            OverlayHelper.safeShowOverlay(overlay);
        }
    }

    public static void removeOverlay(Displayable overlay) {
        if (!jmMappingStarted) {
            waitingQueue.add(() -> OverlayHelper.safeRemoveOverlay(overlay));
        } else {
            OverlayHelper.safeRemoveOverlay(overlay);
        }
    }

    public static void showOverlays(Collection<? extends Displayable> overlays) {
        overlays.forEach(OverlayHelper::showOverlay);
    }

    public static void removeOverlays(Collection<? extends Displayable> overlays) {
        overlays.forEach(OverlayHelper::removeOverlay);
    }

    private static void safeShowOverlay(Displayable overlay) {
        try {
            jmAPI.show(overlay);
        }
        catch (Throwable t) {
            log.error(String.valueOf(t));
        }
    }

    private static void safeRemoveOverlay(Displayable overlay) {
        try {
            jmAPI.remove(overlay);
        }
        catch (Throwable t) {
            log.error(String.valueOf(t));
        }
    }

    public static void onJMMapping(Event.JMMappingEvent event) {
        switch (event.mappingEvent().getStage()) {
            case MAPPING_STARTED: {
                jmMappingStarted = true;
                waitingQueue.forEach(Runnable::run);
                break;
            }
            case MAPPING_STOPPED: {
                jmMappingStarted = false;
                break;
            }
            default: {
                jmMappingStarted = false;
                throw new IllegalStateException("Unexpected value: " + String.valueOf(event.mappingEvent().getStage()));
            }
        }
        waitingQueue.clear();
    }

    public static class_2960 getIcon(String string) {
        return class_2960.method_60655((String)"journeymap", (String)("theme/flat/icon/" + string + ".png"));
    }

    @Generated
    public static void setJmAPI(IClientAPI jmAPI) {
        OverlayHelper.jmAPI = jmAPI;
    }

    static {
        jmMappingStarted = false;
    }
}

