/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import me.frankv.jmi.api.jmoverlay.ClientConfig;

public class FabricClientConfig
implements ClientConfig {
    public static final String fileName = "jmi-client.json5";
    private final ConfigTree configTree;
    private final PropertyMirror<Boolean> ftbChunks = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private final PropertyMirror<Boolean> waystone = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private final PropertyMirror<List<String>> waypointMessageBlocks = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));
    private final PropertyMirror<Boolean> waypointMessageEmptyHandOnly = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private final PropertyMirror<Double> claimedChunkOverlayOpacity = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
    private final PropertyMirror<Boolean> disableFTBFunction = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private final PropertyMirror<Integer> waystoneColor = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    private final PropertyMirror<Integer> defaultConfigVersion = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);

    public FabricClientConfig() {
        ConfigTreeBuilder builder = ConfigTree.builder();
        builder.fork("FTBChunks").beginValue("ftbChunks", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("\nEnable FTBChunks Integration\nDefault: true\n").finishValue(arg_0 -> this.ftbChunks.mirror(arg_0)).beginValue("claimedChunkOverlayOpacity", (ConfigType)ConfigTypes.DOUBLE.withMinimum((Object)0.0).withMaximum((Object)1.0), (Object)0.175).withComment("\nRange: 0 ~ 1.0, Default: 0.175\n").finishValue(arg_0 -> this.claimedChunkOverlayOpacity.mirror(arg_0)).beginValue("disableFTBFunction", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("\nDisable conflict functions for FTBChunks (MiniMap, Waypoint beam, Death waypoint)\nDefault: true\n").finishValue(arg_0 -> this.disableFTBFunction.mirror(arg_0)).build();
        builder.fork("Waystones").beginValue("waystones", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("\nEnable Waystones Integration\nDefault: true\n").finishValue(arg_0 -> this.waystone.mirror(arg_0)).beginValue("wayStoneMarkerColor", (ConfigType)ConfigTypes.NATURAL.withMaximum((Object)0xFFFFFF), (Object)0xFFFFFF).withComment("\nThe color code for Waystone marker. You can generate the color code from https://www.mathsisfun.com/hexadecimal-decimal-colors.html\nDefault: 0xffffff\n").finishValue(arg_0 -> this.waystoneColor.mirror(arg_0)).build();
        builder.fork("WaypointMessage").beginValue("waypointMessageBlocks", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), Collections.emptyList()).withComment("\nList of block id and tags for WaypointMessage. e.g., [\\\"#forge:ores/diamond\\\", \\\"minecraft:diamond_block\\\"]\nDefault: []\n").finishValue(arg_0 -> this.waypointMessageBlocks.mirror(arg_0)).beginValue("emptyHandOnly", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("\nDefault: true\n").finishValue(arg_0 -> this.waypointMessageEmptyHandOnly.mirror(arg_0)).build();
        builder.fork("JourneyMap Default Config").beginValue("defaultConfigVersion", (ConfigType)ConfigTypes.INTEGER.withMinimum((Object)-1), (Object)-1).withComment("\nWhen local JM default config version is older than `defaultConfigVersion` it will copy everything under `/config/jmdefaultconfig/` to `/journeymap/` and replace the existing files. Set to -1 to disable.\nRange: -1 ~ 2,147,483,647, Default: -1\n").finishValue(arg_0 -> this.defaultConfigVersion.mirror(arg_0)).build();
        this.configTree = builder;
    }

    @Override
    public Boolean getFtbChunks() {
        return (Boolean)this.ftbChunks.getValue();
    }

    @Override
    public Boolean getWaystone() {
        return (Boolean)this.waystone.getValue();
    }

    @Override
    public List<? extends String> getWaypointMessageBlocks() {
        return (List)this.waypointMessageBlocks.getValue();
    }

    @Override
    public Boolean getWaypointMessageEmptyHandOnly() {
        return (Boolean)this.waypointMessageEmptyHandOnly.getValue();
    }

    @Override
    public Double getClaimedChunkOverlayOpacity() {
        return (Double)this.claimedChunkOverlayOpacity.getValue();
    }

    @Override
    public Boolean getDisableFTBFunction() {
        return (Boolean)this.disableFTBFunction.getValue();
    }

    @Override
    public Integer getWaystoneColor() {
        return (Integer)this.waystoneColor.getValue();
    }

    @Override
    public Integer getDefaultConfigVersion() {
        return (Integer)this.defaultConfigVersion.getValue();
    }

    @Generated
    public ConfigTree getConfigTree() {
        return this.configTree;
    }
}

