/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.compat.waystones;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.IOverlayListener;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.fullscreen.IThemeButton;
import journeymap.api.v2.client.model.MapImage;
import journeymap.api.v2.client.model.TextProperties;
import lombok.Generated;
import me.frankv.jmi.api.event.Event;
import me.frankv.jmi.api.jmoverlay.ClientConfig;
import me.frankv.jmi.api.jmoverlay.ToggleableOverlay;
import me.frankv.jmi.compat.waystones.WaystonesMarkerListener;
import me.frankv.jmi.util.OverlayHelper;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WaystonesMarker implements ToggleableOverlay
{
    INSTANCE;

    @Generated
    private static final Logger log;
    private final class_310 mc = class_310.method_1551();
    private final String buttonLabel = "jmi.toggleable_overlay.waystones";
    private final int order = 2;
    private final Map<class_2960, Set<WaystoneMeta>> waystones = new HashMap<class_2960, Set<WaystoneMeta>>();
    private final HashMap<WaystoneMeta, MarkerOverlay> markers = new HashMap();
    private IClientAPI jmAPI;
    private ClientConfig clientConfig;
    private boolean activated = true;

    public void init(IClientAPI jmAPI, ClientConfig clientConfig) {
        this.jmAPI = jmAPI;
        this.clientConfig = clientConfig;
        Balm.getEvents().onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceived);
    }

    private void createMarker(WaystoneMeta waystone) {
        class_2960 marker = class_2960.method_60655((String)"jmi", (String)"images/waystone.png");
        MapImage icon = new MapImage(marker, 32, 32).setAnchorX(16.0).setAnchorY(38.0).setDisplayWidth(32.0).setDisplayHeight(32.0).setColor(this.clientConfig.getWaystoneColor().intValue());
        TextProperties textProperties = new TextProperties().setBackgroundOpacity(0.4f).setOpacity(1.0f);
        MarkerOverlay markerOverlay = new MarkerOverlay("jmi", waystone.pos, icon);
        markerOverlay.setDimension(waystone.dim).setLabel(waystone.name).setTextProperties(textProperties);
        markerOverlay.setOverlayListener((IOverlayListener)new WaystonesMarkerListener(markerOverlay, this.jmAPI));
        this.markers.put(waystone, markerOverlay);
        if (this.activated) {
            OverlayHelper.showOverlay((Displayable)markerOverlay);
        }
    }

    private void removeMarker(WaystoneMeta waystone) {
        if (!this.markers.containsKey(waystone)) {
            return;
        }
        try {
            this.jmAPI.remove((Displayable)this.markers.remove(waystone));
            this.markers.remove(waystone);
        }
        catch (Exception e) {
            log.error(String.valueOf(e));
        }
    }

    private void createMarkersOnMappingStarted() {
        class_638 level = this.mc.field_1687;
        if (level == null) {
            return;
        }
        this.waystones.values().stream().flatMap(Collection::stream).filter(waystoneMeta -> waystoneMeta.dim.equals((Object)level.method_27983())).forEach(this::createMarker);
    }

    @Override
    public void onToggle(IThemeButton button) {
        if (this.activated) {
            OverlayHelper.removeOverlays(this.markers.values());
        } else {
            OverlayHelper.showOverlays(this.markers.values());
        }
        this.activated = !this.activated;
        button.setToggled(Boolean.valueOf(this.activated));
    }

    public void onJMMapping(Event.JMMappingEvent event) {
        switch (event.mappingEvent().getStage()) {
            case MAPPING_STARTED: {
                if (!event.firstLogin()) {
                    this.createMarkersOnMappingStarted();
                }
                log.debug("re-added waystones overlays");
                break;
            }
            case MAPPING_STOPPED: {
                this.markers.clear();
            }
        }
    }

    public void onWaystonesListReceived(WaystonesListReceivedEvent event) {
        if (!this.clientConfig.getWaystone().booleanValue()) {
            return;
        }
        Set oldWaystones = Optional.ofNullable(this.waystones.get(event.getWaystoneType())).orElseGet(HashSet::new);
        HashSet<WaystoneMeta> newWaystones = new HashSet<WaystoneMeta>(WaystoneMeta.fromEvent(event));
        HashSet<WaystoneMeta> addWaystones = new HashSet<WaystoneMeta>(newWaystones);
        HashSet rmvWaystones = new HashSet(oldWaystones);
        rmvWaystones.removeAll(newWaystones);
        addWaystones.removeAll(oldWaystones);
        rmvWaystones.forEach(this::removeMarker);
        addWaystones.forEach(this::createMarker);
        this.waystones.put(event.getWaystoneType(), newWaystones);
    }

    @Override
    public class_2960 getButtonIconName() {
        return OverlayHelper.getIcon("waypoints");
    }

    @Override
    @Generated
    public String getButtonLabel() {
        return this.buttonLabel;
    }

    @Override
    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public Map<class_2960, Set<WaystoneMeta>> getWaystones() {
        return this.waystones;
    }

    @Override
    @Generated
    public boolean isActivated() {
        return this.activated;
    }

    static {
        log = LoggerFactory.getLogger(WaystonesMarker.class);
    }

    record WaystoneMeta(UUID uuid, String name, class_2338 pos, class_5321<class_1937> dim) {
        public static Set<WaystoneMeta> fromEvent(WaystonesListReceivedEvent event) {
            HashSet<WaystoneMeta> waystones = new HashSet<WaystoneMeta>();
            event.getWaystones().forEach(w -> {
                if (!w.hasName()) {
                    return;
                }
                waystones.add(new WaystoneMeta(w.getWaystoneUid(), w.getName().method_54160(), w.getPos(), (class_5321<class_1937>)w.getDimension()));
            });
            return waystones;
        }
    }
}

