/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.compat.ftbchunks.claimingmode;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.event.FullscreenMapEvent;
import lombok.Generated;
import me.frankv.jmi.compat.ftbchunks.claimingmode.ClaimingMode;
import me.frankv.jmi.util.OverlayHelper;
import net.minecraft.class_1923;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_8710;

public class ClaimingModeHandler {
    private static final List<Integer> ALLOWED_BUTTONS = List.of(Integer.valueOf(0), Integer.valueOf(1));
    private final ClaimingMode claimingMode;
    private final Map<XZ, PolygonOverlay> dragPolygons = new HashMap<XZ, PolygonOverlay>();
    private final Set<XZ> chunks = new HashSet<XZ>();
    private boolean mouseTracking = false;
    private Integer mouseButton = null;

    public void onClick(FullscreenMapEvent.ClickEvent event) {
        if (this.mouseTracking) {
            event.cancel();
            return;
        }
        if (!this.claimingMode.isActivated()) {
            return;
        }
        if (!ALLOWED_BUTTONS.contains(event.getButton())) {
            return;
        }
        if (event.getStage() != FullscreenMapEvent.Stage.PRE) {
            return;
        }
        XZ xz = XZ.chunkFromBlock((int)event.getLocation().method_10263(), (int)event.getLocation().method_10260());
        if (!this.claimingMode.getArea().contains(new class_1923(xz.x(), xz.z()))) {
            return;
        }
        this.mouseTracking = true;
        this.mouseButton = event.getButton();
        this.addToWaitingList(xz);
        event.cancel();
    }

    public void onDrag(FullscreenMapEvent.MouseDraggedEvent event) {
        if (event.getStage() != FullscreenMapEvent.Stage.PRE) {
            return;
        }
        if (!this.claimingMode.isActivated()) {
            return;
        }
        XZ xz = XZ.chunkFromBlock((int)event.getLocation().method_10263(), (int)event.getLocation().method_10260());
        if (this.mouseTracking || this.claimingMode.getArea().contains(new class_1923(xz.x(), xz.z()))) {
            event.cancel();
        }
    }

    public void onMouseMove(FullscreenMapEvent.MouseMoveEvent event) {
        if (!this.mouseTracking) {
            return;
        }
        XZ xz = XZ.chunkFromBlock((int)event.getLocation().method_10263(), (int)event.getLocation().method_10260());
        if (this.claimingMode.getArea().contains(new class_1923(xz.x(), xz.z())) && !this.chunks.contains(xz)) {
            this.addToWaitingList(xz);
        }
    }

    public void onMouseReleased() {
        if (!this.mouseTracking) {
            return;
        }
        this.applyChanges();
    }

    private void addToWaitingList(XZ xz) {
        PolygonOverlay polygon = this.claimingMode.dragPolygon(xz);
        OverlayHelper.showOverlay((Displayable)polygon);
        this.dragPolygons.put(xz, polygon);
        this.chunks.add(xz);
    }

    private void applyChanges() {
        RequestChunkChangePacket.ChunkChangeOp chunkChangeOp = RequestChunkChangePacket.ChunkChangeOp.create((this.mouseButton == 0 ? 1 : 0) != 0, (boolean)class_437.method_25442());
        RequestChunkChangePacket packet = new RequestChunkChangePacket(chunkChangeOp, this.chunks, false, Optional.empty());
        NetworkManager.sendToServer((class_8710)packet);
        GuiHelper.playSound((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.0f);
        this.clearStates();
    }

    void clearStates() {
        this.mouseTracking = false;
        OverlayHelper.removeOverlays(this.dragPolygons.values());
        this.chunks.clear();
        this.dragPolygons.clear();
        this.mouseButton = null;
    }

    @Generated
    public ClaimingModeHandler(ClaimingMode claimingMode) {
        this.claimingMode = claimingMode;
    }

    @Generated
    public Map<XZ, PolygonOverlay> getDragPolygons() {
        return this.dragPolygons;
    }
}

