/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource.resources.audio;

public class AudioPlayTimeTracker {
    private long playStartTime = -1L;
    private long totalPlayedTime = 0L;
    private boolean isPaused = false;

    public void onPlay() {
        if (this.isPaused) {
            this.isPaused = false;
            this.playStartTime = System.currentTimeMillis();
        } else {
            this.reset();
            this.playStartTime = System.currentTimeMillis();
        }
    }

    public void onPause() {
        if (!this.isPaused && this.playStartTime != -1L) {
            this.totalPlayedTime += System.currentTimeMillis() - this.playStartTime;
            this.isPaused = true;
        }
    }

    public void onStop() {
        this.reset();
    }

    public void reset() {
        this.playStartTime = -1L;
        this.totalPlayedTime = 0L;
        this.isPaused = false;
    }

    public float getCurrentPlayTime() {
        if (this.playStartTime == -1L) {
            return 0.0f;
        }
        long currentTime = this.isPaused ? this.totalPlayedTime : this.totalPlayedTime + (System.currentTimeMillis() - this.playStartTime);
        return (float)currentTime / 1000.0f;
    }
}

