/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource;

import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.input.TextValidators;
import java.util.Objects;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ResourceSourceType implements LocalizedCycleEnum<ResourceSourceType>
{
    LOCATION("location"),
    LOCAL("local"),
    WEB("web");

    private final String name;

    private ResourceSourceType(String name) {
        this.name = name;
    }

    @NotNull
    public String getSourcePrefix() {
        return "[source:" + this.name + "]";
    }

    public static boolean hasSourcePrefix(@NotNull String resourceSource) {
        if (resourceSource.startsWith(LOCATION.getSourcePrefix())) {
            return true;
        }
        if (resourceSource.startsWith(LOCAL.getSourcePrefix())) {
            return true;
        }
        return resourceSource.startsWith(WEB.getSourcePrefix());
    }

    @NotNull
    public static String getWithoutSourcePrefix(@NotNull String resourceSource) {
        resourceSource = resourceSource.replace(LOCATION.getSourcePrefix(), "");
        resourceSource = resourceSource.replace(LOCAL.getSourcePrefix(), "");
        resourceSource = resourceSource.replace(WEB.getSourcePrefix(), "");
        return resourceSource;
    }

    @NotNull
    public static ResourceSourceType getSourceTypeOf(@NotNull String resourceSource) {
        Objects.requireNonNull(resourceSource);
        if (resourceSource.startsWith(LOCAL.getSourcePrefix())) {
            return LOCAL;
        }
        if (resourceSource.startsWith(WEB.getSourcePrefix())) {
            return WEB;
        }
        if (resourceSource.startsWith(LOCATION.getSourcePrefix())) {
            return LOCATION;
        }
        if (TextValidators.BASIC_URL_TEXT_VALIDATOR.get(ResourceSourceType.getWithoutSourcePrefix(resourceSource)).booleanValue()) {
            return WEB;
        }
        if (resourceSource.contains(":") && class_2960.method_12829((String)ResourceSourceType.getWithoutSourcePrefix(resourceSource)) != null) {
            return LOCATION;
        }
        return LOCAL;
    }

    @Override
    @NotNull
    public class_2583 getValueComponentStyle() {
        return (class_2583)WARNING_TEXT_STYLE.get();
    }

    @Override
    @NotNull
    public String getLocalizationKeyBase() {
        return "fancymenu.resources.source_type";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public ResourceSourceType[] getValues() {
        return ResourceSourceType.values();
    }

    @Override
    @Nullable
    public ResourceSourceType getByNameInternal(@NotNull String name) {
        return ResourceSourceType.getByName(name);
    }

    @Nullable
    public static ResourceSourceType getByName(@NotNull String name) {
        for (ResourceSourceType t : ResourceSourceType.values()) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        return null;
    }
}

