/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.auth;

import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.mod.UniversalModContainer;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.awt.Color;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModValidator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor INVALID_COLOR = DrawableColor.of(Color.RED);

    public static boolean isFancyMenuLoaded() {
        return Services.PLATFORM.isModLoaded("fancymenu");
    }

    public static boolean isFancyMenuDisplayName() {
        UniversalModContainer mod = Services.PLATFORM.getLoadedMod("fancymenu");
        if (mod == null) {
            return false;
        }
        return "FancyMenu".equals(mod.name());
    }

    public static boolean isFancyMenuDescription() {
        UniversalModContainer mod = Services.PLATFORM.getLoadedMod("fancymenu");
        if (mod == null) {
            return false;
        }
        if (mod.description() == null) {
            return false;
        }
        return mod.description().contains("Customize Minecraft's menus with ease!");
    }

    public static boolean isFancyMenuLicense() {
        UniversalModContainer mod = Services.PLATFORM.getLoadedMod("fancymenu");
        if (mod == null) {
            return false;
        }
        if (mod.license() == null) {
            return false;
        }
        return mod.license().contains("DSMSLv3");
    }

    public static boolean isFancyMenuMetadataValid() {
        if (!ModValidator.isFancyMenuLoaded()) {
            return false;
        }
        if (!ModValidator.isFancyMenuDisplayName()) {
            return false;
        }
        if (!ModValidator.isFancyMenuDescription()) {
            return false;
        }
        return ModValidator.isFancyMenuLicense();
    }

    public static void printInfo() {
        LOGGER.warn("");
        LOGGER.warn("================ FANCYMENU ================");
        LOGGER.warn("");
        LOGGER.warn("FM found in loaded mods: " + ModValidator.isFancyMenuLoaded());
        LOGGER.warn("FM metadata has correct display name: " + ModValidator.isFancyMenuDisplayName());
        LOGGER.warn("FM metadata has correct description: " + ModValidator.isFancyMenuDescription());
        LOGGER.warn("FM metadata has correct license: " + ModValidator.isFancyMenuLicense());
        LOGGER.warn("");
        LOGGER.warn("===========================================");
        LOGGER.warn("");
    }

    public static void renderInvalidError(class_332 graphics) {
        class_437 current = class_310.method_1551().field_1755;
        if (current == null) {
            return;
        }
        if (!current.getClass().getName().startsWith("net.minecraft.")) {
            return;
        }
        graphics.method_51452();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        graphics.method_25294(0, 0, current.field_22789, current.field_22790, DrawableColor.BLACK.getColorInt());
        graphics.method_25300(class_310.method_1551().field_1772, "MODIFIED FANCYMENU JAR FOUND!", current.field_22789 / 2, current.field_22790 / 2 - 10, INVALID_COLOR.getColorInt());
        graphics.method_25300(class_310.method_1551().field_1772, "PLEASE DOWNLOAD A VALID BUILD FROM CURSEFORGE OR MODRINTH!", current.field_22789 / 2, current.field_22790 / 2 + 5, INVALID_COLOR.getColorInt());
        graphics.method_51448().method_22909();
    }
}

