/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.audio;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.elements.audio.AudioElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AudioPlaytimePlaceholder
extends Placeholder {
    public AudioPlaytimePlaceholder() {
        super("audio_playtime");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        AbstractElement element;
        ScreenCustomizationLayer layer;
        String elementId = dps.values.get("element_identifier");
        String showPercentageStr = dps.values.get("show_percentage");
        boolean showPercentage = StringUtils.equalsIgnoreCase((CharSequence)showPercentageStr, (CharSequence)"true");
        if (elementId != null && (layer = ScreenCustomizationLayerHandler.getActiveLayer()) != null && (element = layer.getElementByInstanceIdentifier(elementId)) instanceof AudioElement) {
            AudioElement audio = (AudioElement)element;
            if (audio.currentAudio != null && audio.currentAudio.isReady() && (audio.currentAudio.isPlaying() || audio.currentAudio.isPaused())) {
                float playTimeSeconds = audio.currentAudio.getPlayTime();
                float durationSeconds = audio.currentAudio.getDuration();
                if (showPercentage) {
                    if (durationSeconds > 0.0f) {
                        int percentage = (int)(playTimeSeconds / durationSeconds * 100.0f);
                        return String.valueOf(Math.min(100, Math.max(0, percentage)));
                    }
                    return "0";
                }
                int minutes = (int)(playTimeSeconds / 60.0f);
                int seconds = (int)(playTimeSeconds % 60.0f);
                return String.format("%02d:%02d", minutes, seconds);
            }
        }
        return showPercentage ? "0" : "00:00";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("element_identifier");
        l.add("show_percentage");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.audio_playtime", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.audio_playtime.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.placeholders.categories.audio", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("element_identifier", "put_identifier_of_audio_element_here");
        m.put("show_percentage", "false");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

