/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.panorama;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.ScreenUtils;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class LocalTexturePanoramaRenderer
implements class_4068 {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    public File propertiesFile;
    @NotNull
    public File panoramaImageDir;
    @Nullable
    public File overlayImageFile;
    protected String name = null;
    public final List<ResourceSupplier<ITexture>> panoramaImageSuppliers = new ArrayList<ResourceSupplier<ITexture>>();
    @Nullable
    public ResourceSupplier<ITexture> overlayTextureSupplier;
    protected float speed = 1.0f;
    protected double fov = 85.0;
    protected float angle = 25.0f;
    public float opacity = 1.0f;
    protected volatile boolean tickerThreadRunning = false;
    protected volatile float currentRotation = 0.0f;
    protected volatile long lastRenderCall = -1L;

    @Nullable
    public static LocalTexturePanoramaRenderer build(@NotNull File propertiesFile, @NotNull File panoramaImageDir, @Nullable File overlayImageFile) {
        LocalTexturePanoramaRenderer renderer = new LocalTexturePanoramaRenderer(propertiesFile, panoramaImageDir, overlayImageFile);
        try {
            if (renderer.propertiesFile.isFile() && renderer.panoramaImageDir.isDirectory()) {
                PropertyContainerSet panoProperties = PropertiesParser.deserializeSetFromFile(renderer.propertiesFile.getAbsolutePath());
                if (panoProperties != null) {
                    PropertyContainer panoMeta = panoProperties.getFirstContainerOfType("panorama-meta");
                    if (panoMeta != null) {
                        String rot;
                        String an;
                        String fo;
                        renderer.name = panoMeta.getValue("name");
                        if (renderer.name == null) {
                            LOGGER.error("[FANCYMENU] Unable to load panorama! Missing 'name' value in panorama meta section: " + renderer.propertiesFile.getAbsolutePath(), (Throwable)new NullPointerException());
                            return null;
                        }
                        String sp = panoMeta.getValue("speed");
                        if (sp != null && MathUtils.isFloat((String)sp)) {
                            renderer.speed = Float.parseFloat(sp);
                        }
                        if ((fo = panoMeta.getValue("fov")) != null && MathUtils.isDouble((String)fo)) {
                            renderer.fov = Double.parseDouble(fo);
                        }
                        if ((an = panoMeta.getValue("angle")) != null && MathUtils.isFloat((String)an)) {
                            renderer.angle = Float.parseFloat(an);
                        }
                        if ((rot = panoMeta.getValue("start_rotation")) != null && MathUtils.isFloat((String)rot)) {
                            renderer.currentRotation = Float.parseFloat(rot);
                            if (renderer.currentRotation > 360.0f || renderer.currentRotation < 0.0f) {
                                renderer.currentRotation = 0.0f;
                            }
                        }
                        renderer.prepare();
                        return renderer;
                    }
                    LOGGER.error("[FANCYMENU] Unable to load panorama! Missing 'panorama-meta' section in properties instance: " + renderer.propertiesFile.getAbsolutePath(), (Throwable)new NullPointerException());
                } else {
                    LOGGER.error("[FANCYMENU] Unable to load panorama! Parsed properties instance was NULL: " + renderer.propertiesFile.getAbsolutePath(), (Throwable)new NullPointerException());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] An error happened while trying to build a cubic panorama!", (Throwable)ex);
        }
        return null;
    }

    protected LocalTexturePanoramaRenderer(@NotNull File propertiesFile, @NotNull File panoramaImageDir, @Nullable File overlayImageFile) {
        this.propertiesFile = Objects.requireNonNull(propertiesFile);
        this.panoramaImageDir = Objects.requireNonNull(panoramaImageDir);
        this.overlayImageFile = overlayImageFile;
    }

    protected void prepare() {
        this.panoramaImageSuppliers.clear();
        this.overlayTextureSupplier = null;
        for (int i = 0; i < 6; ++i) {
            File panoImage = new File(this.panoramaImageDir, "panorama_" + i + ".png");
            if (!panoImage.isFile()) {
                LOGGER.error("[FANCYMENU] Unable to load panorama! Missing panorama image 'panorama_" + i + ".png': " + this.name);
                return;
            }
            this.panoramaImageSuppliers.add(ResourceSupplier.image(ResourceSource.of(panoImage.getAbsolutePath(), ResourceSourceType.LOCAL).getSourceWithPrefix()));
        }
        if (this.overlayImageFile != null && this.overlayImageFile.isFile()) {
            this.panoramaImageSuppliers.add(ResourceSupplier.image(ResourceSource.of(this.overlayImageFile.getAbsolutePath(), ResourceSourceType.LOCAL).getSourceWithPrefix()));
        }
    }

    protected void startTickerThreadIfNeeded() {
        if (this.tickerThreadRunning) {
            return;
        }
        this.lastRenderCall = System.currentTimeMillis();
        this.tickerThreadRunning = true;
        new Thread(() -> {
            while (this.lastRenderCall + 5000L > System.currentTimeMillis()) {
                try {
                    this.currentRotation += 0.03f;
                    if (this.currentRotation >= 360.0f) {
                        this.currentRotation = 0.0f;
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error while ticking panorama!", (Throwable)ex);
                }
                try {
                    Thread.sleep(Math.max(2, (int)(20.0f / this.speed)));
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error while ticking panorama!", (Throwable)ex);
                }
            }
            this.tickerThreadRunning = false;
        }, "FancyMenu Panorama Ticker Thread").start();
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.lastRenderCall = System.currentTimeMillis();
        this.startTickerThreadIfNeeded();
        if (this.panoramaImageSuppliers.size() < 6) {
            RenderSystem.enableBlend();
            RenderingUtils.resetShaderColor(graphics);
            graphics.method_25290(ITexture.MISSING_TEXTURE_LOCATION, 0, 0, 0.0f, 0.0f, ScreenUtils.getScreenWidth(), ScreenUtils.getScreenHeight(), ScreenUtils.getScreenWidth(), ScreenUtils.getScreenHeight());
            RenderingUtils.resetShaderColor(graphics);
        } else {
            this._render(graphics, class_310.method_1551(), this.opacity);
        }
    }

    private void _render(@NotNull class_332 graphics, class_310 mc, float panoAlpha) {
        class_2960 location;
        ITexture texture;
        int screenW = ScreenUtils.getScreenWidth();
        int screenH = ScreenUtils.getScreenHeight();
        float pitch = this.angle;
        float yaw = -this.currentRotation;
        float fovF = (float)this.fov * ((float)Math.PI / 180);
        class_289 tesselator = class_289.method_1348();
        Matrix4f $$5 = new Matrix4f().setPerspective(fovF, (float)mc.method_22683().method_4489() / (float)mc.method_22683().method_4506(), 0.05f, 10.0f);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)$$5, (class_8251)class_8251.field_43360);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.rotationX((float)Math.PI);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        for (int $$8 = 0; $$8 < 4; ++$$8) {
            modelViewStack.pushMatrix();
            float $$9 = ((float)($$8 % 2) / 2.0f - 0.5f) / 256.0f;
            float $$10 = ((float)($$8 / 2) / 2.0f - 0.5f) / 256.0f;
            float $$11 = 0.0f;
            modelViewStack.translate($$9, $$10, 0.0f);
            modelViewStack.rotateX(pitch * ((float)Math.PI / 180));
            modelViewStack.rotateY(yaw * ((float)Math.PI / 180));
            RenderSystem.applyModelViewMatrix();
            for (int texNum = 0; texNum < 6; ++texNum) {
                ResourceSupplier<ITexture> texSupplier;
                ITexture texture2;
                class_2960 location2 = null;
                if (this.panoramaImageSuppliers.size() >= texNum + 1 && (texture2 = (texSupplier = this.panoramaImageSuppliers.get(texNum)).get()) != null) {
                    location2 = texture2.getResourceLocation();
                }
                if (location2 == null) {
                    location2 = ITexture.MISSING_TEXTURE_LOCATION;
                }
                RenderSystem.setShaderTexture((int)0, (class_2960)location2);
                class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
                int $$14 = Math.round(255.0f * panoAlpha) / ($$8 + 1);
                if (texNum == 0) {
                    bufferBuilder.method_22912(-1.0f, -1.0f, 1.0f).method_22913(0.0f, 0.0f).method_60832($$14);
                    bufferBuilder.method_22912(-1.0f, 1.0f, 1.0f).method_22913(0.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, 1.0f, 1.0f).method_22913(1.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, -1.0f, 1.0f).method_22913(1.0f, 0.0f).method_60832($$14);
                }
                if (texNum == 1) {
                    bufferBuilder.method_22912(1.0f, -1.0f, 1.0f).method_22913(0.0f, 0.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, 1.0f, 1.0f).method_22913(0.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, 1.0f, -1.0f).method_22913(1.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, -1.0f, -1.0f).method_22913(1.0f, 0.0f).method_60832($$14);
                }
                if (texNum == 2) {
                    bufferBuilder.method_22912(1.0f, -1.0f, -1.0f).method_22913(0.0f, 0.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, 1.0f, -1.0f).method_22913(0.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(-1.0f, 1.0f, -1.0f).method_22913(1.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(-1.0f, -1.0f, -1.0f).method_22913(1.0f, 0.0f).method_60832($$14);
                }
                if (texNum == 3) {
                    bufferBuilder.method_22912(-1.0f, -1.0f, -1.0f).method_22913(0.0f, 0.0f).method_60832($$14);
                    bufferBuilder.method_22912(-1.0f, 1.0f, -1.0f).method_22913(0.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(-1.0f, 1.0f, 1.0f).method_22913(1.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(-1.0f, -1.0f, 1.0f).method_22913(1.0f, 0.0f).method_60832($$14);
                }
                if (texNum == 4) {
                    bufferBuilder.method_22912(-1.0f, -1.0f, -1.0f).method_22913(0.0f, 0.0f).method_60832($$14);
                    bufferBuilder.method_22912(-1.0f, -1.0f, 1.0f).method_22913(0.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, -1.0f, 1.0f).method_22913(1.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, -1.0f, -1.0f).method_22913(1.0f, 0.0f).method_60832($$14);
                }
                if (texNum == 5) {
                    bufferBuilder.method_22912(-1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_60832($$14);
                    bufferBuilder.method_22912(-1.0f, 1.0f, -1.0f).method_22913(0.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, 1.0f, -1.0f).method_22913(1.0f, 1.0f).method_60832($$14);
                    bufferBuilder.method_22912(1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_60832($$14);
                }
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
            }
            modelViewStack.popMatrix();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.restoreProjectionMatrix();
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderingUtils.resetShaderColor(graphics);
        if (this.overlayTextureSupplier != null && (texture = this.overlayTextureSupplier.get()) != null && (location = texture.getResourceLocation()) != null) {
            graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
            RenderSystem.enableBlend();
            graphics.method_25290(location, 0, 0, 0.0f, 0.0f, screenW, screenH, screenW, screenH);
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    public String getName() {
        return this.name;
    }

    public void setSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.speed = speed;
    }

    public void setFov(double fov) {
        if (fov > 179.0) {
            fov = 179.0;
        }
        this.fov = fov;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

