/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.TamagotchiBuddySerializer;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.animation.AnimationState;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.animation.AnimationStates;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.gui.BuddyGui;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.items.FoodItem;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.items.PlayBall;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.items.Poop;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_8030;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TamagotchiBuddy
extends class_362
implements class_4068,
FancyMenuUiComponent {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 TEXTURE_ICON_WANTS_BEING_PET = class_2960.method_60655((String)"fancymenu", (String)"textures/buddy/heart.png");
    public static final class_2960 TEXTURE_ICON_WANTS_TO_PLAY = class_2960.method_60655((String)"fancymenu", (String)"textures/buddy/play.png");
    public static final class_2960 TEXTURE_THOUGHT_BUBBLE = class_2960.method_60655((String)"fancymenu", (String)"textures/buddy/thought.png");
    public int buddyPosX;
    public int buddyPosY;
    public int screenWidth;
    public int screenHeight;
    public boolean facingLeft = false;
    public boolean isDisabled = true;
    public boolean isOffScreen = false;
    @NotNull
    public AnimationState currentState = AnimationStates.WALKING;
    public int currentStateDuration = 0;
    public int currentFrame = 0;
    public int animationRenderTicks = 0;
    public float hopAnimationCounter = 0.0f;
    public float hopAnimationSpeed = 0.3f;
    public int hopAnimationDuration = 0;
    public float hunger = 100.0f;
    public float happiness = 100.0f;
    public float energy = 100.0f;
    public float funLevel = 100.0f;
    public boolean needsFood = false;
    public boolean needsPet = false;
    public boolean needsPlay = false;
    public boolean isBeingPet = false;
    public boolean isEating = false;
    public boolean isPlaying = false;
    public boolean isSleeping = false;
    public boolean isChasingBall = false;
    public boolean isHoldingBall = false;
    public boolean isSleepy = false;
    public boolean isStanding = false;
    public boolean isHopping = false;
    public boolean isLookingAround = false;
    public boolean isStretching = false;
    public boolean isExcited = false;
    public boolean isGrumpy = false;
    public boolean isSitting = false;
    public boolean isWaving = false;
    public boolean isYawning = false;
    public int stateChangeTimer;
    public Random random = new Random();
    public int pixelsSinceLastDirectionChange = 0;
    public int minWalkDistance = 30;
    public int maxWalkDistance = 200;
    public float standChancePercentage = 1.0f;
    public float hopChancePercentage = 0.3f;
    public float lookChancePercentage = 0.2f;
    public float stretchChancePercentage = 0.1f;
    public float excitedChancePercentage = 0.1f;
    public FoodItem droppedFood = null;
    public PlayBall playBall = null;
    public List<Poop> poops = new ArrayList<Poop>();
    public boolean isPooping = false;
    public int timeSinceLastPoop = 0;
    public int poopingInterval = 1500;
    public float poopChancePercentage = 5.0f;
    public static final int MAX_POOPS_BEFORE_SAD = 3;
    public boolean wasDisabled = true;
    public boolean wasOffScreen = false;
    public BuddyGui gui;
    public final List<class_364> children = new ArrayList<class_364>();

    public TamagotchiBuddy(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.buddyPosX = screenWidth / 2;
        this.buddyPosY = screenHeight - 32 - 10;
        this.stateChangeTimer = this.random.nextInt(200) + 100;
        this.gui = new BuddyGui(this);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.wasDisabled != this.isDisabled) {
            LOGGER.info("Buddy disabled state changed: {} -> {}", (Object)this.wasDisabled, (Object)this.isDisabled);
            this.wasDisabled = this.isDisabled;
        }
        if (!this.isDisabled) {
            return;
        }
        if (this.wasOffScreen != this.isOffScreen) {
            LOGGER.info("Buddy off-screen state changed: {} -> {}", (Object)this.wasOffScreen, (Object)this.isOffScreen);
            this.wasOffScreen = this.isOffScreen;
            if (!this.isOffScreen) {
                this.isStanding = false;
            }
        }
        this.renderPoops(graphics);
        ++this.animationRenderTicks;
        int currentAnimationSpeed = this.currentState.getAnimationSpeed(this);
        if (this.animationRenderTicks >= currentAnimationSpeed) {
            this.animationRenderTicks = 0;
            this.currentFrame = (this.currentFrame + 1) % 4;
        }
        int texX = this.currentFrame * 32;
        int texY = this.currentState.getAtlasIndex() * 32;
        if (this.playBall != null && !this.playBall.isBeingDragged()) {
            this.playBall.render(graphics);
        }
        if (this.isHopping && !this.isExcited) {
            float hopOffset = (float)Math.sin(this.hopAnimationCounter) * 10.0f;
            int renderY = this.buddyPosY - (int)hopOffset;
            if (this.facingLeft) {
                RenderingUtils.blitMirrored(graphics, AnimationState.TEXTURE_ATLAS, this.buddyPosX, renderY, texX, texY, 32, 32, 128, 544);
            } else {
                graphics.method_25290(AnimationState.TEXTURE_ATLAS, this.buddyPosX, renderY, (float)texX, (float)texY, 32, 32, 128, 544);
            }
        } else if (this.facingLeft) {
            RenderingUtils.blitMirrored(graphics, AnimationState.TEXTURE_ATLAS, this.buddyPosX, this.buddyPosY, texX, texY, 32, 32, 128, 544);
        } else {
            graphics.method_25290(AnimationState.TEXTURE_ATLAS, this.buddyPosX, this.buddyPosY, (float)texX, (float)texY, 32, 32, 128, 544);
        }
        if (!(this.isEating || this.isBeingPet || this.isPlaying || this.isSleeping)) {
            this.renderNeedsIndicator(graphics);
        }
        if (this.playBall != null && this.playBall.isBeingDragged()) {
            this.playBall.render(graphics);
        }
        if (this.droppedFood != null) {
            this.droppedFood.render(graphics);
        }
        this.gui.render(graphics, mouseX, mouseY);
    }

    public void renderPoops(class_332 graphics) {
        for (Poop poop : new ArrayList<Poop>(this.poops)) {
            poop.render(graphics);
        }
    }

    public void renderNeedsIndicator(class_332 graphics) {
        if (this.isEating || this.isBeingPet || this.isPlaying || this.isSleeping) {
            return;
        }
        int iconSize = 16;
        int iconX = this.buddyPosX + 16 - iconSize / 2;
        int iconY = this.buddyPosY - iconSize - 5;
        class_2960 icon = null;
        if (this.needsFood) {
            icon = FoodItem.TEXTURE_FOOD;
        } else if (this.needsPet) {
            icon = TEXTURE_ICON_WANTS_BEING_PET;
        } else if (this.needsPlay && !this.isChasingBall) {
            icon = TEXTURE_ICON_WANTS_TO_PLAY;
        }
        if (icon != null) {
            graphics.method_25290(TEXTURE_THOUGHT_BUBBLE, iconX - 4, iconY - 4, 0.0f, 0.0f, iconSize + 8, iconSize + 8, iconSize + 8, iconSize + 8);
            graphics.method_25290(icon, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
    }

    public void tick() {
        if (!this.isDisabled) {
            return;
        }
        if (this.isHopping && this.isSad()) {
            LOGGER.info("Stopping hopping because buddy is sad");
            this.isHopping = false;
            this.hopAnimationCounter = 0.0f;
        }
        if (this.isHopping && this.hopAnimationDuration > 0) {
            --this.hopAnimationDuration;
            if (this.hopAnimationDuration <= 0) {
                this.isHopping = false;
                this.hopAnimationCounter = 0.0f;
            }
        }
        if (this.isHopping) {
            this.hopAnimationCounter += this.hopAnimationSpeed;
            if ((double)this.hopAnimationCounter >= Math.PI * 2) {
                this.hopAnimationCounter -= (float)Math.PI * 2;
            }
        } else {
            this.hopAnimationCounter = 0.0f;
        }
        this.updateStatsAndNeeds();
        if (this.droppedFood != null) {
            this.droppedFood.tick();
            if (this.droppedFood.isNearBuddy(this.buddyPosX + 16, this.buddyPosY + 16)) {
                this.eatFood();
                this.droppedFood = null;
            }
            if (this.droppedFood != null && this.droppedFood.shouldRemove()) {
                this.droppedFood = null;
            }
        }
        if (this.playBall != null) {
            this.playBall.tick();
            if (this.playBall.shouldRemove()) {
                this.playBall = null;
                this.isPlaying = false;
                this.isHoldingBall = false;
                this.isChasingBall = false;
            }
        }
        if (this.isPlaying && this.playBall == null) {
            LOGGER.info("Ending play due to no ball");
            this.isPlaying = false;
            this.isHoldingBall = false;
            this.isChasingBall = false;
        }
        for (int i = this.poops.size() - 1; i >= 0; --i) {
            Poop poop = this.poops.get(i);
            poop.tick();
            if (!poop.shouldRemove()) continue;
            this.poops.remove(i);
        }
        if (this.animationRenderTicks % 600 == 0) {
            this.cleanupInvalidPoops();
        }
        if (!(this.animationRenderTicks % 100 != 0 || !this.isStanding || this.isLookingAround || this.isStretching || this.isGrumpy || this.currentStateDuration > 0 || this.isOffScreen)) {
            LOGGER.info("Buddy has been standing still too long, forcing movement");
            this.isStanding = false;
        }
        if (this.poops.size() >= 3) {
            this.happiness = Math.max(0.0f, this.happiness - 0.05f);
        }
        if (!this.isPooping) {
            ++this.timeSinceLastPoop;
            if (!(this.timeSinceLastPoop < this.poopingInterval || this.isSleeping || this.isEating || this.isPlaying || this.isChasingBall || !this.chanceCheck(this.poopChancePercentage))) {
                this.startPooping();
            }
        }
        --this.stateChangeTimer;
        if (this.stateChangeTimer <= 0) {
            this.decideNextBehavior();
            this.stateChangeTimer = this.random.nextInt(300) + 100;
        }
        if (this.currentStateDuration > 0) {
            --this.currentStateDuration;
            if (this.currentStateDuration <= 0) {
                LOGGER.info("Buddy activity duration ended for temporary state: {}", (Object)this.currentState.getName());
                if (this.isPooping) {
                    this.dropPoop();
                }
                this.isPooping = false;
                this.isLookingAround = false;
                this.isStretching = false;
                this.isExcited = false;
                this.isGrumpy = false;
                this.isEating = false;
                this.isBeingPet = false;
                this.isYawning = false;
                this.isSitting = false;
                this.isWaving = false;
            }
        }
        if (this.isSleeping && this.energy >= 100.0f) {
            this.isSleeping = false;
        }
        this.updateMovement();
        this.updateVisualState();
    }

    public void updateStatsAndNeeds() {
        this.hunger = Math.max(0.0f, this.hunger - 0.05f);
        this.happiness = Math.max(0.0f, this.happiness - 0.03f);
        this.funLevel = Math.max(0.0f, this.funLevel - 0.02f);
        if (this.isSleeping) {
            this.energy = Math.min(100.0f, this.energy + 0.3f);
        } else {
            this.energy = Math.max(0.0f, this.energy - 0.02f);
            if (this.isPlaying) {
                this.energy = Math.max(0.0f, this.energy - 0.1f);
                this.funLevel = Math.min(100.0f, this.funLevel + 0.5f);
            }
            if (this.isChasingBall) {
                this.energy = Math.max(0.0f, this.energy - 0.08f);
            }
            if (this.isHopping) {
                this.energy = Math.max(0.0f, this.energy - 0.05f);
            }
            if (this.isExcited) {
                this.energy = Math.max(0.0f, this.energy - 0.1f);
                this.happiness = Math.min(100.0f, this.happiness + 0.1f);
            }
            if (this.currentState == AnimationStates.RUNNING) {
                this.energy = Math.max(0.0f, this.energy - 0.1f);
            }
        }
        this.needsFood = this.hunger < 30.0f;
        this.needsPet = this.happiness < 30.0f;
        this.needsPlay = this.funLevel < 30.0f;
        boolean bl = this.isSleepy = this.energy < 30.0f && this.energy >= 10.0f;
        if (this.energy < 10.0f && !this.isSleeping) {
            this.startSleeping();
        }
    }

    public void updateMovement() {
        boolean shouldTurn;
        if (!this.currentState.allowsMovement()) {
            return;
        }
        int currentWalkSpeed = this.currentState.getCurrentWalkingSpeed(this);
        if (this.isChasingBall && this.playBall != null) {
            int ballCenterX = this.playBall.getX();
            if (ballCenterX < this.buddyPosX + 16 - 5) {
                this.facingLeft = true;
                this.buddyPosX -= currentWalkSpeed;
                if (this.buddyPosX < this.screenWidth) {
                    this.isOffScreen = false;
                }
            } else if (ballCenterX > this.buddyPosX + 16 + 5) {
                this.facingLeft = false;
                this.buddyPosX += currentWalkSpeed;
                if (this.buddyPosX > 0) {
                    this.isOffScreen = false;
                }
            }
            if (this.playBall.isNearBuddy(this.buddyPosX + 16, this.buddyPosY + 16)) {
                this.grabBall();
            }
            return;
        }
        ++this.pixelsSinceLastDirectionChange;
        boolean bl = shouldTurn = this.pixelsSinceLastDirectionChange > this.minWalkDistance && this.chanceCheck(1.0f) || this.pixelsSinceLastDirectionChange > this.maxWalkDistance;
        if (this.facingLeft) {
            this.buddyPosX -= currentWalkSpeed;
            if (this.buddyPosX < -32) {
                if (!this.isOffScreen) {
                    LOGGER.info("Buddy going offscreen to the left at x={}", (Object)this.buddyPosX);
                    this.isOffScreen = true;
                    return;
                }
                if (this.chanceCheck(1.0f)) {
                    LOGGER.info("Buddy coming back onscreen from the left");
                    this.facingLeft = false;
                    this.isOffScreen = false;
                    this.buddyPosX = -32;
                    this.pixelsSinceLastDirectionChange = 0;
                    this.stopAllStandingActions();
                }
            } else if (this.buddyPosX < 0 && this.chanceCheck(1.0f) || shouldTurn) {
                this.facingLeft = false;
                this.pixelsSinceLastDirectionChange = 0;
                this.performRandomAction();
            }
        } else {
            this.buddyPosX += currentWalkSpeed;
            if (this.buddyPosX > this.screenWidth) {
                if (!this.isOffScreen) {
                    LOGGER.info("Buddy going offscreen to the right at x={}", (Object)this.buddyPosX);
                    this.isOffScreen = true;
                    return;
                }
                if (this.chanceCheck(1.0f)) {
                    LOGGER.info("Buddy coming back onscreen from the right");
                    this.facingLeft = true;
                    this.isOffScreen = false;
                    this.buddyPosX = this.screenWidth;
                    this.pixelsSinceLastDirectionChange = 0;
                    this.stopAllStandingActions();
                }
            } else if (this.buddyPosX > this.screenWidth - 32 && this.chanceCheck(1.0f) || shouldTurn) {
                this.facingLeft = true;
                this.pixelsSinceLastDirectionChange = 0;
                this.performRandomAction();
            }
        }
    }

    public void decideNextBehavior() {
        if (this.chanceCheck(10.0f)) {
            this.facingLeft = this.buddyPosX < this.screenWidth / 2;
        } else {
            if (this.chanceCheck(50.0f)) {
                this.facingLeft = !this.facingLeft;
                this.pixelsSinceLastDirectionChange = 0;
            }
            if (this.chanceCheck(20.0f)) {
                this.performRandomAction();
            }
        }
    }

    public void performRandomAction() {
        if (this.pixelsSinceLastDirectionChange > this.minWalkDistance && this.chanceCheck(this.standChancePercentage)) {
            this.startStanding();
            return;
        }
        if (this.happiness > 70.0f && this.funLevel > 80.0f && this.chanceCheck(this.excitedChancePercentage) && !this.isSad()) {
            this.startExcitement();
            return;
        }
        if (this.happiness > 60.0f && this.chanceCheck(1.0f) && !this.isSad() && !this.isSleepy) {
            this.startWaving();
            return;
        }
        if (this.energy < 60.0f && this.chanceCheck(2.0f)) {
            this.startYawning();
            return;
        }
        if (this.chanceCheck(1.5f)) {
            this.startSitting();
            return;
        }
        if (this.chanceCheck(this.lookChancePercentage)) {
            this.startLookingAround();
            return;
        }
        if (this.chanceCheck(this.stretchChancePercentage) && !this.isSad()) {
            this.startStretching();
            return;
        }
        if (!this.isHopping && this.chanceCheck(this.hopChancePercentage) && !this.isSad()) {
            this.startHopping();
        }
    }

    public void updateVisualState() {
        AnimationState selectedState = AnimationStates.findFirstValidStateFor(this);
        this.setState(selectedState);
        if (this.isHopping && !this.currentState.allowsHopping()) {
            LOGGER.info("Stopping hopping because current state {} doesn't allow it", (Object)this.currentState.getName());
            this.isHopping = false;
            this.hopAnimationCounter = 0.0f;
        }
    }

    public void setState(@NotNull AnimationState state) {
        if (this.lockedInState() && !state.shouldIgnoreLockedState()) {
            return;
        }
        Objects.requireNonNull(state);
        if (this.currentState != state) {
            LOGGER.info("Changing buddy state: {} -> {}", (Object)this.currentState.getName(), (Object)state.getName());
            this.currentState.onDeactivate(this);
            state.onActivate(this);
            this.currentState = state;
        }
    }

    public boolean lockedInState() {
        return this.currentState.shouldLockStateUntilFinished() && this.currentStateDuration > 0;
    }

    public void stopAllStandingActions() {
        this.isStanding = false;
        this.isStretching = false;
        this.isLookingAround = false;
        this.isPooping = false;
        this.isEating = false;
        this.isSleeping = false;
        this.isBeingPet = false;
        this.isSitting = false;
        this.isWaving = false;
        this.isYawning = false;
    }

    public void startStanding() {
        if (this.lockedInState()) {
            return;
        }
        LOGGER.info("Buddy starting to stand: x={}, y={}, state={}", (Object)this.buddyPosX, (Object)this.buddyPosY, (Object)this.currentState.getName());
        this.isStanding = true;
        this.isHopping = false;
        this.isLookingAround = false;
        this.isStretching = false;
        this.isExcited = false;
    }

    public void startHopping() {
        if (this.isSad()) {
            LOGGER.info("Buddy is too sad to hop right now");
            return;
        }
        if (!this.currentState.allowsHopping()) {
            LOGGER.info("Current state {} doesn't allow hopping", (Object)this.currentState.getName());
            return;
        }
        LOGGER.info("Buddy starting to hop: x={}, y={}, state={}", (Object)this.buddyPosX, (Object)this.buddyPosY, (Object)this.currentState.getName());
        this.isHopping = true;
        this.hopAnimationCounter = 0.0f;
        this.hopAnimationDuration = MathUtils.getRandomNumberInRange((int)30, (int)100);
        if (this.chanceCheck(30.0f) && this.happiness > 60.0f) {
            this.isExcited = true;
            LOGGER.info("Buddy switching to excited animation during hop");
        }
    }

    public void startLookingAround() {
        if (this.lockedInState()) {
            return;
        }
        LOGGER.info("Buddy starting to look around: x={}, y={}, state={}", (Object)this.buddyPosX, (Object)this.buddyPosY, (Object)this.currentState.getName());
        this.isLookingAround = true;
        this.isStanding = true;
    }

    public void startStretching() {
        if (this.lockedInState()) {
            return;
        }
        if (this.isSad()) {
            LOGGER.info("Buddy is too sad to stretch right now");
            return;
        }
        LOGGER.info("Buddy starting to stretch: x={}, y={}, state={}", (Object)this.buddyPosX, (Object)this.buddyPosY, (Object)this.currentState.getName());
        this.isStretching = true;
    }

    public void startSitting() {
        if (this.lockedInState()) {
            return;
        }
        LOGGER.info("Buddy starting to sit: x={}, y={}, state={}", (Object)this.buddyPosX, (Object)this.buddyPosY, (Object)this.currentState.getName());
        this.isSitting = true;
        this.isHopping = false;
        this.isLookingAround = false;
        this.isStretching = false;
        this.isExcited = false;
        this.isStanding = false;
    }

    public void startWaving() {
        if (this.lockedInState()) {
            return;
        }
        if (this.happiness < 60.0f) {
            LOGGER.info("Buddy is not happy enough to wave right now");
            return;
        }
        if (this.isSad() || this.isSleepy) {
            LOGGER.info("Buddy doesn't feel like waving right now");
            return;
        }
        LOGGER.info("Buddy starting to wave: x={}, y={}, state={}", (Object)this.buddyPosX, (Object)this.buddyPosY, (Object)this.currentState.getName());
        this.isWaving = true;
        this.isHopping = false;
        this.isLookingAround = false;
        this.isStretching = false;
        this.isExcited = false;
        this.isSitting = false;
    }

    public void startYawning() {
        if (this.lockedInState()) {
            return;
        }
        LOGGER.info("Buddy starting to yawn: x={}, y={}, state={}", (Object)this.buddyPosX, (Object)this.buddyPosY, (Object)this.currentState.getName());
        this.isYawning = true;
        this.isHopping = false;
        this.isLookingAround = false;
        this.isStretching = false;
        this.isExcited = false;
        this.isSitting = false;
        this.isWaving = false;
    }

    public void startExcitement() {
        if (this.lockedInState()) {
            return;
        }
        if (this.isSad() || this.happiness < 50.0f) {
            LOGGER.info("Buddy is too sad to get excited right now");
            return;
        }
        LOGGER.info("Buddy starting to get excited: x={}, y={}, state={}", (Object)this.buddyPosX, (Object)this.buddyPosY, (Object)this.currentState.getName());
        this.isExcited = true;
    }

    public void startPooping() {
        if (this.isOffScreen) {
            LOGGER.info("Buddy tried to poop while off-screen, preventing");
            return;
        }
        LOGGER.info("Buddy starting to poop: x={}, y={}", (Object)this.buddyPosX, (Object)this.buddyPosY);
        this.isPooping = true;
        this.timeSinceLastPoop = 0;
    }

    public void dropPoop() {
        int poopX = this.facingLeft ? this.buddyPosX + 32 + 5 : this.buddyPosX - 5;
        int poopY = this.buddyPosY + 32 - 8;
        int minX = 50;
        int maxX = this.screenWidth - 50;
        if (poopX < minX) {
            poopX = this.buddyPosX + 32 + 5;
            poopX = Math.max(minX, Math.min(maxX, poopX));
        } else if (poopX > maxX) {
            poopX = this.buddyPosX - 5;
            poopX = Math.max(minX, Math.min(maxX, poopX));
        }
        poopY = Math.max(10, Math.min(this.screenHeight - 10, poopY));
        if (poopX < 0 || poopX > this.screenWidth || poopY < 0 || poopY > this.screenHeight || poopX == Integer.MAX_VALUE || poopY == Integer.MAX_VALUE) {
            LOGGER.warn("Attempted to create poop with invalid coordinates: ({}, {}), skipping", (Object)poopX, (Object)poopY);
            return;
        }
        this.poops.add(new Poop(poopX, poopY, this));
        LOGGER.info("Buddy pooped at position: x={}, y={}, total poops: {}", (Object)poopX, (Object)poopY, (Object)this.poops.size());
        if (this.poops.size() >= 3) {
            LOGGER.info("Too many poops! Buddy is getting sad");
        }
    }

    public void grabBall() {
        if (this.playBall != null) {
            this.playBall.resetInactivityTimer();
            this.isChasingBall = false;
            this.isHoldingBall = true;
            this.isPlaying = true;
            this.playBall.setGrabbedByBuddy(true);
        }
    }

    public void eatFood() {
        this.isEating = true;
        this.hunger = Math.min(100.0f, this.hunger + 40.0f);
        this.happiness = Math.min(100.0f, this.happiness + 10.0f);
    }

    public void pet() {
        if (this.isSleeping) {
            this.isSleeping = false;
            this.happiness = Math.max(0.0f, this.happiness - 5.0f);
            this.startGrumpyState();
        } else {
            this.isBeingPet = true;
            this.happiness = Math.min(100.0f, this.happiness + 30.0f);
            if (this.happiness > 70.0f && this.chanceCheck(30.0f)) {
                this.startExcitement();
            }
        }
    }

    public void startGrumpyState() {
        LOGGER.info("Buddy is grumpy after being woken up");
        this.isHopping = false;
        this.isLookingAround = false;
        this.isStretching = false;
        this.isExcited = false;
        this.isGrumpy = true;
    }

    public boolean isSad() {
        if (this.isPlaying || this.isChasingBall) {
            return false;
        }
        if (this.happiness < 20.0f) {
            return true;
        }
        return this.needsFood || this.needsPet || this.needsPlay;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isDisabled) {
            return false;
        }
        if (this.droppedFood != null && !this.droppedFood.justCreated) {
            this.droppedFood.stickToCursor = false;
        }
        if (this.playBall != null && !this.playBall.justCreated) {
            this.playBall.stickToCursor = false;
            if (this.playBall.isNearBuddy(this.buddyPosX + 16, this.buddyPosY + 16)) {
                this.isPlaying = true;
                this.isHoldingBall = true;
                this.isChasingBall = false;
                this.playBall.setGrabbedByBuddy(true);
                this.needsPlay = false;
            } else {
                this.isPlaying = true;
                this.isChasingBall = true;
                this.isHoldingBall = false;
            }
        }
        if (button == 0) {
            for (Poop poop : new ArrayList<Poop>(this.poops)) {
                if (!poop.isMouseOver(mouseX, mouseY)) continue;
                poop.startCleaning();
                this.happiness = Math.min(100.0f, this.happiness + 5.0f);
                LOGGER.info("Cleaned up poop at ({},{}), happiness: {}", (Object)poop.getX(), (Object)poop.getY(), (Object)Float.valueOf(this.happiness));
                return true;
            }
        }
        if (this.gui.isVisible()) {
            return this.gui.mouseClicked(mouseX, mouseY, button);
        }
        if (button == 1) {
            if (this.isMouseOverBuddy(mouseX, mouseY)) {
                this.gui.show(this.screenWidth, this.screenHeight);
                LOGGER.info("Opening buddy GUI");
                return true;
            }
        } else if (button == 0) {
            if (this.isMouseOverBuddy(mouseX, mouseY)) {
                this.pet();
                return true;
            }
            if (this.droppedFood != null && this.droppedFood.isMouseOver(mouseX, mouseY)) {
                this.droppedFood.pickup((int)mouseX, (int)mouseY);
                return true;
            }
            if (this.playBall != null && this.playBall.isMouseOver(mouseX, mouseY)) {
                this.playBall.pickup((int)mouseX, (int)mouseY);
                if (this.isHoldingBall) {
                    this.isHoldingBall = false;
                } else if (!this.isChasingBall) {
                    this.isChasingBall = true;
                    this.isPlaying = true;
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.isDisabled) {
            return false;
        }
        if (button == 0) {
            if (this.droppedFood != null && this.droppedFood.isBeingDragged()) {
                if (this.droppedFood.isNearBuddy(this.buddyPosX + 16, this.buddyPosY + 16)) {
                    this.eatFood();
                    this.droppedFood = null;
                } else {
                    this.droppedFood.drop((int)mouseX, (int)mouseY);
                }
                return true;
            }
            if (this.playBall != null && this.playBall.isBeingDragged()) {
                if (this.playBall.isNearBuddy(this.buddyPosX + 16, this.buddyPosY + 16)) {
                    this.isPlaying = true;
                    this.isHoldingBall = true;
                    this.isChasingBall = false;
                    this.playBall.setGrabbedByBuddy(true);
                    this.needsPlay = false;
                } else {
                    this.playBall.throwBall((int)mouseX, (int)mouseY);
                    this.isPlaying = true;
                    this.isChasingBall = true;
                    this.isHoldingBall = false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDisabled) {
            return false;
        }
        if (button == 0) {
            if (this.droppedFood != null && this.droppedFood.isBeingDragged()) {
                this.droppedFood.setPosition((int)mouseX, (int)mouseY);
                return true;
            }
            if (this.playBall != null && this.playBall.isBeingDragged()) {
                this.playBall.updateDragPosition((int)mouseX, (int)mouseY);
                return true;
            }
        }
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (!this.isDisabled) {
            return;
        }
        if (this.droppedFood != null && this.droppedFood.isBeingDragged()) {
            LOGGER.debug("Updating dragged food position to: ({}, {})", (Object)((int)mouseX), (Object)((int)mouseY));
            this.droppedFood.setPosition((int)mouseX, (int)mouseY);
        }
        if (this.playBall != null && this.playBall.isBeingDragged()) {
            LOGGER.debug("Updating dragged ball position to: ({}, {})", (Object)((int)mouseX), (Object)((int)mouseY));
            this.playBall.updateDragPosition((int)mouseX, (int)mouseY);
        }
    }

    public boolean isMouseOverBuddy(double mouseX, double mouseY) {
        return mouseX >= (double)this.buddyPosX && mouseX < (double)(this.buddyPosX + 32) && mouseY >= (double)this.buddyPosY && mouseY < (double)(this.buddyPosY + 32);
    }

    public void setScreenSize(int width, int height) {
        LOGGER.info("Screen size changed: {}x{} -> {}x{}", (Object)this.screenWidth, (Object)this.screenHeight, (Object)width, (Object)height);
        width = Math.max(1, width);
        height = Math.max(1, height);
        this.screenWidth = width;
        this.screenHeight = height;
        this.buddyPosY = height - 32 - 10;
        for (Poop poop : new ArrayList<Poop>(this.poops)) {
            poop.updatePosition(width, height);
        }
        this.cleanupInvalidPoops();
        if (this.gui.isVisible()) {
            this.gui.show(width, height);
        }
        LOGGER.info("Updated buddy position to y={}", (Object)this.buddyPosY);
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    @NotNull
    public class_8030 method_48202() {
        return new class_8030(this.buddyPosX, this.buddyPosY, 32, 32);
    }

    public void resetAnimationFrame() {
        this.currentFrame = 0;
        this.animationRenderTicks = 0;
    }

    public void setCurrentStateDuration(int duration) {
        this.currentStateDuration = duration;
    }

    public int getBuddyPosX() {
        return this.buddyPosX;
    }

    public int getBuddyPosY() {
        return this.buddyPosY;
    }

    public int getSpriteWidth() {
        return 32;
    }

    public int getSpriteHeight() {
        return 32;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public boolean isFacingLeft() {
        return this.facingLeft;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public int getAnimationRenderTicks() {
        return this.animationRenderTicks;
    }

    public void increaseFunLevel(float amount) {
        this.funLevel = Math.min(100.0f, this.funLevel + amount);
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public void setHoldingBall(boolean holdingBall) {
        this.isHoldingBall = holdingBall;
    }

    public boolean isChasingBall() {
        return this.isChasingBall;
    }

    public void setChasingBall(boolean chasingBall) {
        this.isChasingBall = chasingBall;
    }

    public float getHunger() {
        return this.hunger;
    }

    public void setHunger(float hunger) {
        this.hunger = hunger;
        this.needsFood = hunger < 30.0f;
    }

    public float getHappiness() {
        return this.happiness;
    }

    public void setHappiness(float happiness) {
        this.happiness = happiness;
        this.needsPet = happiness < 30.0f;
    }

    public float getEnergy() {
        return this.energy;
    }

    public void setEnergy(float energy) {
        this.energy = energy;
        if (energy < 10.0f && !this.isSleeping) {
            this.startSleeping();
        }
    }

    public void startSleeping() {
        this.isSleeping = true;
        this.isEating = false;
        this.isBeingPet = false;
        this.isPlaying = false;
        this.isHoldingBall = false;
        this.isChasingBall = false;
        if (this.playBall != null) {
            this.playBall = null;
        }
        this.isStanding = false;
        this.isHopping = false;
        this.isLookingAround = false;
        this.isStretching = false;
        this.isExcited = false;
    }

    public float getFunLevel() {
        return this.funLevel;
    }

    public void setFunLevel(float funLevel) {
        this.funLevel = funLevel;
        this.needsPlay = funLevel < 30.0f;
    }

    public List<Poop> getPoops() {
        return new ArrayList<Poop>(this.poops);
    }

    public void setPoops(List<Poop> poops) {
        this.poops = new ArrayList<Poop>(poops);
    }

    public FoodItem getDroppedFood() {
        return this.droppedFood;
    }

    public void setDroppedFood(FoodItem food) {
        this.droppedFood = food;
    }

    public PlayBall getPlayBall() {
        return this.playBall;
    }

    public void setPlayBall(PlayBall ball) {
        this.playBall = ball;
    }

    public boolean isSleeping() {
        return this.isSleeping;
    }

    public void saveState() {
        TamagotchiBuddySerializer.saveBuddy(this);
    }

    public boolean loadState() {
        boolean result = TamagotchiBuddySerializer.loadBuddy(this);
        this.cleanupInvalidPoops();
        return result;
    }

    public void cleanupInvalidPoops() {
        ArrayList<Poop> validPoops = new ArrayList<Poop>();
        boolean madeChanges = false;
        for (Poop poop : this.poops) {
            boolean isExtremelyInvalid;
            int x = poop.getX();
            int y = poop.getY();
            boolean bl = isExtremelyInvalid = x < 0 || y < 0 || x > 10000 || y > 10000;
            if (isExtremelyInvalid) {
                LOGGER.info("Removed invalid poop at position ({}, {})", (Object)x, (Object)y);
                madeChanges = true;
                continue;
            }
            if (x > this.screenWidth || y > this.screenHeight) {
                LOGGER.info("Repositioning off-screen poop from ({}, {}) to within screen bounds", (Object)x, (Object)y);
                poop.updatePosition(this.screenWidth, this.screenHeight);
                madeChanges = true;
            }
            validPoops.add(poop);
        }
        if (madeChanges) {
            LOGGER.info("Cleaned up {} invalid poops", (Object)(this.poops.size() - validPoops.size()));
            this.poops = validPoops;
        }
    }

    public boolean chanceCheck(float percentage) {
        if (percentage < 0.0f) {
            percentage = 0.0f;
        }
        if (percentage > 100.0f) {
            percentage = 100.0f;
        }
        return this.random.nextFloat() < percentage / 100.0f;
    }
}

