/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.moresparkles.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import me.unariginal.moresparkles.MoreSparkles;
import me.unariginal.moresparkles.data.CuboidArea;
import me.unariginal.moresparkles.data.CylinderArea;
import me.unariginal.moresparkles.data.SparkleArea;
import net.fabricmc.loader.api.FabricLoader;

public class SparkleAreasConfig {
    public List<SparkleArea> areas = new ArrayList<SparkleArea>();

    public SparkleAreasConfig() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            MoreSparkles.logError("Unable to load boost areas config file. Error: " + e.getMessage());
        }
    }

    public void loadConfig() throws IOException {
        JsonObject areaObject;
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles").toFile();
        if (!rootFolder.exists()) {
            rootFolder.mkdir();
        }
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/boost_areas.json").toFile();
        JsonObject newRoot = new JsonObject();
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            root = JsonParser.parseReader((Reader)new FileReader(configFile)).getAsJsonObject();
        }
        this.areas.clear();
        for (String key : root.keySet()) {
            String world;
            areaObject = root.getAsJsonObject(key);
            if (!areaObject.has("type") || !areaObject.has("shape") || !areaObject.has("multiplier")) continue;
            String type = areaObject.get("type").getAsString();
            float multiplier = areaObject.get("multiplier").getAsFloat();
            boolean particlesEnabled = false;
            String identifier = "minecraft:end_rod";
            float speed = 0.0f;
            int count = 0;
            if (areaObject.has("particles")) {
                JsonObject particlesObject = areaObject.getAsJsonObject("particles");
                if (particlesObject.has("enabled")) {
                    particlesEnabled = particlesObject.get("enabled").getAsBoolean();
                }
                if (particlesEnabled) {
                    if (!(particlesObject.has("identifier") && particlesObject.has("speed") && particlesObject.has("count"))) {
                        particlesEnabled = false;
                    } else {
                        identifier = particlesObject.get("identifier").getAsString();
                        speed = particlesObject.get("speed").getAsFloat();
                        count = particlesObject.get("count").getAsInt();
                    }
                }
            }
            JsonObject shapeObject = areaObject.getAsJsonObject("shape");
            if (type.equalsIgnoreCase("cuboid")) {
                if (!shapeObject.has("world") || !shapeObject.has("x_min") || !shapeObject.has("x_max") || !shapeObject.has("y_min") || !shapeObject.has("y_max") || !shapeObject.has("z_min") || !shapeObject.has("z_max")) continue;
                world = shapeObject.get("world").getAsString();
                double minX = shapeObject.get("x_min").getAsDouble();
                double maxX = shapeObject.get("x_max").getAsDouble();
                double minY = shapeObject.get("y_min").getAsDouble();
                double maxY = shapeObject.get("y_max").getAsDouble();
                double minZ = shapeObject.get("z_min").getAsDouble();
                double maxZ = shapeObject.get("z_max").getAsDouble();
                if (particlesEnabled) {
                    this.areas.add(new CuboidArea(key, type, multiplier, world, particlesEnabled, identifier, speed, count, minX, maxX, minY, maxY, minZ, maxZ));
                    continue;
                }
                this.areas.add(new CuboidArea(key, type, multiplier, world, minX, maxX, minY, maxY, minZ, maxZ));
                continue;
            }
            if (!type.equalsIgnoreCase("cylinder") || !shapeObject.has("world") || !shapeObject.has("center_x") || !shapeObject.has("center_z") || !shapeObject.has("radius") || !shapeObject.has("y_min") || !shapeObject.has("y_max")) continue;
            world = shapeObject.get("world").getAsString();
            double centerX = shapeObject.get("center_x").getAsDouble();
            double centerZ = shapeObject.get("center_z").getAsDouble();
            double radius = shapeObject.get("radius").getAsDouble();
            double minY = shapeObject.get("y_min").getAsDouble();
            double maxY = shapeObject.get("y_max").getAsDouble();
            if (particlesEnabled) {
                this.areas.add(new CylinderArea(key, type, multiplier, world, particlesEnabled, identifier, speed, count, centerX, centerZ, radius, minY, maxY));
                continue;
            }
            this.areas.add(new CylinderArea(key, type, multiplier, world, centerX, centerZ, radius, minY, maxY));
        }
        for (SparkleArea area : this.areas) {
            areaObject = new JsonObject();
            areaObject.addProperty("type", area.type);
            areaObject.addProperty("multiplier", (Number)Float.valueOf(area.multiplier));
            JsonObject shapeObject = new JsonObject();
            shapeObject.addProperty("world", area.world);
            if (area instanceof CuboidArea) {
                CuboidArea cuboidArea = (CuboidArea)area;
                shapeObject.addProperty("x_min", (Number)cuboidArea.xMin);
                shapeObject.addProperty("x_max", (Number)cuboidArea.xMax);
                shapeObject.addProperty("y_min", (Number)cuboidArea.yMin);
                shapeObject.addProperty("y_max", (Number)cuboidArea.yMax);
                shapeObject.addProperty("z_min", (Number)cuboidArea.zMin);
                shapeObject.addProperty("z_max", (Number)cuboidArea.zMax);
                areaObject.add("shape", (JsonElement)shapeObject);
            } else if (area instanceof CylinderArea) {
                CylinderArea cylinderArea = (CylinderArea)area;
                shapeObject.addProperty("center_x", (Number)cylinderArea.centerX);
                shapeObject.addProperty("center_z", (Number)cylinderArea.centerZ);
                shapeObject.addProperty("radius", (Number)cylinderArea.radius);
                shapeObject.addProperty("y_min", (Number)cylinderArea.yMin);
                shapeObject.addProperty("y_max", (Number)cylinderArea.yMax);
                areaObject.add("shape", (JsonElement)shapeObject);
            }
            if (area.particlesEnabled) {
                JsonObject particlesObject = new JsonObject();
                particlesObject.addProperty("enabled", Boolean.valueOf(true));
                particlesObject.addProperty("identifier", area.particleIdentifier);
                particlesObject.addProperty("speed", (Number)Float.valueOf(area.particleSpeed));
                particlesObject.addProperty("count", (Number)area.particleCount);
                areaObject.add("particles", (JsonElement)particlesObject);
            }
            newRoot.add(area.id, (JsonElement)areaObject);
        }
        configFile.delete();
        configFile.createNewFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        FileWriter writer = new FileWriter(configFile);
        gson.toJson((JsonElement)newRoot, (Appendable)writer);
        ((Writer)writer).close();
    }

    public SparkleArea getBoostArea(String id) {
        for (SparkleArea area : this.areas) {
            if (!area.id.equals(id)) continue;
            return area;
        }
        return null;
    }
}

