/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.moresparkles.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import me.unariginal.moresparkles.MoreSparkles;
import me.unariginal.moresparkles.data.ShinyBoost;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;

public class PlayerDataManager {
    public static ShinyBoost loadPlayerBoostData(class_3222 player) {
        File playerFile;
        File playersFolder;
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles").toFile();
        if (!rootFolder.exists()) {
            rootFolder.mkdir();
        }
        if (!(playersFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/playerdata").toFile()).exists()) {
            playersFolder.mkdir();
        }
        if ((playerFile = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/playerdata/" + player.method_5845() + ".json").toFile()).exists()) {
            try {
                JsonObject root = JsonParser.parseReader((Reader)new FileReader(playerFile)).getAsJsonObject();
                if (!root.has("active_boost")) {
                    MoreSparkles.LOGGER.error("[MoreSparkles] Failed To Load Player Data File: {}", (Object)playerFile.getName());
                    MoreSparkles.LOGGER.error(" - File is missing data!");
                    return null;
                }
                JsonObject activeBoost = root.getAsJsonObject("active_boost");
                if (!(activeBoost.has("multiplier") && activeBoost.has("time_remaining") && activeBoost.has("duration"))) {
                    MoreSparkles.LOGGER.error("[MoreSparkles] Failed To Load Player Data File: {}", (Object)playerFile.getName());
                    MoreSparkles.LOGGER.error(" - File is missing data!");
                    return null;
                }
                float multiplier = activeBoost.get("multiplier").getAsFloat();
                long time_remaining = activeBoost.get("time_remaining").getAsLong();
                int duration = activeBoost.get("duration").getAsInt();
                if (MoreSparkles.INSTANCE.getConfig().allowQueuedBoosts && root.has("queued_boosts")) {
                    MoreSparkles.INSTANCE.clearQueue(player);
                    JsonArray queuedBoostsArray = root.getAsJsonArray("queued_boosts");
                    for (JsonElement queuedBoostElement : queuedBoostsArray) {
                        JsonObject queuedBoost = queuedBoostElement.getAsJsonObject();
                        if (!queuedBoost.has("multiplier") || !queuedBoost.has("duration")) continue;
                        MoreSparkles.INSTANCE.queuedBoosts.add(new ShinyBoost(player, queuedBoost.get("multiplier").getAsFloat(), queuedBoost.get("duration").getAsInt()));
                    }
                }
                return new ShinyBoost(player, multiplier, duration, time_remaining);
            }
            catch (FileNotFoundException e) {
                MoreSparkles.LOGGER.error("[MoreSparkles] Failed To Load Player Data File: {}", (Object)playerFile.getName());
                MoreSparkles.LOGGER.error(" - {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public static void savePlayerBoostData(class_3222 player) {
        File playersFolder;
        ShinyBoost shinyBoost = MoreSparkles.INSTANCE.getActiveBoost(player);
        if (shinyBoost == null) {
            PlayerDataManager.deletePlayerBoostFile(player);
            return;
        }
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles").toFile();
        if (!rootFolder.exists()) {
            rootFolder.mkdir();
        }
        if (!(playersFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/playerdata").toFile()).exists()) {
            playersFolder.mkdir();
        }
        File playerFile = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/playerdata/" + player.method_5845() + ".json").toFile();
        JsonObject root = new JsonObject();
        root.addProperty("uuid", player.method_5845());
        root.addProperty("username", player.method_5820());
        JsonObject activeBoost = new JsonObject();
        activeBoost.addProperty("multiplier", (Number)Float.valueOf(shinyBoost.multiplier));
        activeBoost.addProperty("time_remaining", (Number)shinyBoost.timeRemaining);
        activeBoost.addProperty("duration", (Number)shinyBoost.duration);
        root.add("active_boost", (JsonElement)activeBoost);
        JsonArray queuedBoostsArray = new JsonArray();
        for (ShinyBoost queuedBoost : MoreSparkles.INSTANCE.getQueuedBoosts(player)) {
            JsonObject queuedBoostObject = new JsonObject();
            queuedBoostObject.addProperty("multiplier", (Number)Float.valueOf(queuedBoost.multiplier));
            queuedBoostObject.addProperty("duration", (Number)queuedBoost.duration);
            queuedBoostsArray.add((JsonElement)queuedBoostObject);
        }
        root.add("queued_boosts", (JsonElement)queuedBoostsArray);
        try {
            playerFile.delete();
            playerFile.createNewFile();
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            FileWriter writer = new FileWriter(playerFile);
            gson.toJson((JsonElement)root, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            MoreSparkles.LOGGER.error("[MoreSparkles] Failed To Save Player Data File: {}", (Object)playerFile.getName());
            MoreSparkles.LOGGER.error(e.getMessage());
        }
    }

    public static void savePlayerBoostData(ShinyBoost shinyBoost) {
        File playersFolder;
        if (shinyBoost.playerUUID == null) {
            return;
        }
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles").toFile();
        if (!rootFolder.exists()) {
            rootFolder.mkdir();
        }
        if (!(playersFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/playerdata").toFile()).exists()) {
            playersFolder.mkdir();
        }
        File playerFile = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/playerdata/" + String.valueOf(shinyBoost.playerUUID) + ".json").toFile();
        JsonObject root = new JsonObject();
        class_3222 player = MoreSparkles.INSTANCE.getServer().method_3760().method_14602(shinyBoost.playerUUID);
        root.addProperty("uuid", shinyBoost.playerUUID.toString());
        if (player != null) {
            root.addProperty("username", player.method_5820());
        }
        JsonObject activeBoost = new JsonObject();
        activeBoost.addProperty("multiplier", (Number)Float.valueOf(shinyBoost.multiplier));
        activeBoost.addProperty("time_remaining", (Number)shinyBoost.timeRemaining);
        activeBoost.addProperty("duration", (Number)shinyBoost.duration);
        root.add("active_boost", (JsonElement)activeBoost);
        JsonArray queuedBoostsArray = new JsonArray();
        for (ShinyBoost queuedBoost : MoreSparkles.INSTANCE.getQueuedBoosts(shinyBoost.playerUUID)) {
            JsonObject queuedBoostObject = new JsonObject();
            queuedBoostObject.addProperty("multiplier", (Number)Float.valueOf(queuedBoost.multiplier));
            queuedBoostObject.addProperty("duration", (Number)queuedBoost.duration);
            queuedBoostsArray.add((JsonElement)queuedBoostObject);
        }
        root.add("queued_boosts", (JsonElement)queuedBoostsArray);
        try {
            playerFile.delete();
            playerFile.createNewFile();
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            FileWriter writer = new FileWriter(playerFile);
            gson.toJson((JsonElement)root, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            MoreSparkles.LOGGER.error("[MoreSparkles] Failed To Save Player Data File: {}", (Object)playerFile.getName());
            MoreSparkles.LOGGER.error(e.getMessage());
        }
    }

    public static void deletePlayerBoostFile(class_3222 player) {
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles").toFile();
        if (!rootFolder.exists()) {
            return;
        }
        File playersFolder = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/playerdata").toFile();
        if (!playersFolder.exists()) {
            return;
        }
        File playerFile = FabricLoader.getInstance().getConfigDir().resolve("MoreSparkles/playerdata/" + player.method_5845() + ".json").toFile();
        if (playerFile.exists()) {
            playerFile.delete();
        }
    }
}

